/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.jacobpeterson.alpaca.openapi.broker.JSON;

public class IssueOAuthTokenResponse {
    public static final String SERIALIZED_NAME_ACCESS_TOKEN = "access_token";
    @SerializedName(value="access_token")
    private String accessToken;
    public static final String SERIALIZED_NAME_TOKEN_TYPE = "token_type";
    @SerializedName(value="token_type")
    private TokenTypeEnum tokenType;
    public static final String SERIALIZED_NAME_SCOPE = "scope";
    @SerializedName(value="scope")
    private String scope;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public IssueOAuthTokenResponse accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @Nonnull
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public IssueOAuthTokenResponse tokenType(TokenTypeEnum tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    @Nonnull
    public TokenTypeEnum getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(TokenTypeEnum tokenType) {
        this.tokenType = tokenType;
    }

    public IssueOAuthTokenResponse scope(String scope) {
        this.scope = scope;
        return this;
    }

    @Nonnull
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueOAuthTokenResponse issueOAuthTokenResponse = (IssueOAuthTokenResponse)o;
        return Objects.equals(this.accessToken, issueOAuthTokenResponse.accessToken) && Objects.equals((Object)this.tokenType, (Object)issueOAuthTokenResponse.tokenType) && Objects.equals(this.scope, issueOAuthTokenResponse.scope);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accessToken, this.tokenType, this.scope});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IssueOAuthTokenResponse {\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    tokenType: ").append(this.toIndentedString((Object)this.tokenType)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in IssueOAuthTokenResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `IssueOAuthTokenResponse` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ACCESS_TOKEN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `access_token` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCESS_TOKEN).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_TOKEN_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `token_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TOKEN_TYPE).toString()));
        }
        TokenTypeEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TOKEN_TYPE));
        if (!jsonObj.get(SERIALIZED_NAME_SCOPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `scope` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SCOPE).toString()));
        }
    }

    public static IssueOAuthTokenResponse fromJson(String jsonString) throws IOException {
        return (IssueOAuthTokenResponse)JSON.getGson().fromJson(jsonString, IssueOAuthTokenResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCESS_TOKEN);
        openapiFields.add(SERIALIZED_NAME_TOKEN_TYPE);
        openapiFields.add(SERIALIZED_NAME_SCOPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ACCESS_TOKEN);
        openapiRequiredFields.add(SERIALIZED_NAME_TOKEN_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_SCOPE);
        validate = false;
        isValid = jsonElement -> true;
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TokenTypeEnum {
        BEARER("Bearer");

        private String value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private TokenTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TokenTypeEnum fromValue(String value) {
            for (TokenTypeEnum b : TokenTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            String value = jsonElement.getAsString();
            TokenTypeEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<TokenTypeEnum> {
            public void write(JsonWriter jsonWriter, TokenTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TokenTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TokenTypeEnum.fromValue(value);
            }
        }
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!IssueOAuthTokenResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(IssueOAuthTokenResponse.class));
            return new TypeAdapter<IssueOAuthTokenResponse>(){

                public void write(JsonWriter out, IssueOAuthTokenResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public IssueOAuthTokenResponse read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    IssueOAuthTokenResponse.validateJsonElement(jsonElement);
                    return (IssueOAuthTokenResponse)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

