/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.broker.JSON;
import net.jacobpeterson.alpaca.openapi.broker.model.JournalEntryType;

public class JournalData {
    public static final String SERIALIZED_NAME_ENTRY_TYPE = "entry_type";
    @SerializedName(value="entry_type")
    private JournalEntryType entryType;
    public static final String SERIALIZED_NAME_FROM_ACCOUNT = "from_account";
    @SerializedName(value="from_account")
    private UUID fromAccount;
    public static final String SERIALIZED_NAME_TO_ACCOUNT = "to_account";
    @SerializedName(value="to_account")
    private UUID toAccount;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigDecimal amount;
    public static final String SERIALIZED_NAME_SYMBOL = "symbol";
    @SerializedName(value="symbol")
    private String symbol;
    public static final String SERIALIZED_NAME_QTY = "qty";
    @SerializedName(value="qty")
    private BigDecimal qty;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public JournalData entryType(JournalEntryType entryType) {
        this.entryType = entryType;
        return this;
    }

    @Nonnull
    public JournalEntryType getEntryType() {
        return this.entryType;
    }

    public void setEntryType(JournalEntryType entryType) {
        this.entryType = entryType;
    }

    public JournalData fromAccount(UUID fromAccount) {
        this.fromAccount = fromAccount;
        return this;
    }

    @Nonnull
    public UUID getFromAccount() {
        return this.fromAccount;
    }

    public void setFromAccount(UUID fromAccount) {
        this.fromAccount = fromAccount;
    }

    public JournalData toAccount(UUID toAccount) {
        this.toAccount = toAccount;
        return this;
    }

    @Nonnull
    public UUID getToAccount() {
        return this.toAccount;
    }

    public void setToAccount(UUID toAccount) {
        this.toAccount = toAccount;
    }

    public JournalData amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public JournalData symbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Nullable
    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public JournalData qty(BigDecimal qty) {
        this.qty = qty;
        return this;
    }

    @Nullable
    public BigDecimal getQty() {
        return this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JournalData journalData = (JournalData)o;
        return Objects.equals((Object)this.entryType, (Object)journalData.entryType) && Objects.equals(this.fromAccount, journalData.fromAccount) && Objects.equals(this.toAccount, journalData.toAccount) && Objects.equals(this.amount, journalData.amount) && Objects.equals(this.symbol, journalData.symbol) && Objects.equals(this.qty, journalData.qty);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.entryType, this.fromAccount, this.toAccount, this.amount, this.symbol, this.qty});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JournalData {\n");
        sb.append("    entryType: ").append(this.toIndentedString((Object)this.entryType)).append("\n");
        sb.append("    fromAccount: ").append(this.toIndentedString(this.fromAccount)).append("\n");
        sb.append("    toAccount: ").append(this.toIndentedString(this.toAccount)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    symbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("    qty: ").append(this.toIndentedString(this.qty)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in JournalData is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `JournalData` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        JournalEntryType.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ENTRY_TYPE));
        if (!jsonObj.get(SERIALIZED_NAME_FROM_ACCOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `from_account` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FROM_ACCOUNT).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_TO_ACCOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `to_account` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TO_ACCOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AMOUNT) != null && !jsonObj.get(SERIALIZED_NAME_AMOUNT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_AMOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AMOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SYMBOL) != null && !jsonObj.get(SERIALIZED_NAME_SYMBOL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SYMBOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SYMBOL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_QTY) != null && !jsonObj.get(SERIALIZED_NAME_QTY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_QTY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_QTY).toString()));
        }
    }

    public static JournalData fromJson(String jsonString) throws IOException {
        return (JournalData)JSON.getGson().fromJson(jsonString, JournalData.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ENTRY_TYPE);
        openapiFields.add(SERIALIZED_NAME_FROM_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_TO_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_SYMBOL);
        openapiFields.add(SERIALIZED_NAME_QTY);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ENTRY_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_FROM_ACCOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_TO_ACCOUNT);
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!JournalData.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(JournalData.class));
            return new TypeAdapter<JournalData>(){

                public void write(JsonWriter out, JournalData value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public JournalData read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    JournalData.validateJsonElement(jsonElement);
                    return (JournalData)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

