/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jacobpeterson.alpaca.openapi.broker.JSON;
import net.jacobpeterson.alpaca.openapi.broker.model.AbstractOpenApiSchema;
import net.jacobpeterson.alpaca.openapi.broker.model.JNLC;
import net.jacobpeterson.alpaca.openapi.broker.model.JNLS;

public class JournalResource
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(JournalResource.class.getName());
    public static final Map<String, Class<?>> schemas = new HashMap();
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public JournalResource() {
        super("oneOf", Boolean.FALSE);
    }

    public JournalResource(JNLC o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    public JournalResource(JNLS o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, Class<?>> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (instance instanceof JNLC) {
            super.setActualInstance(instance);
            return;
        }
        if (instance instanceof JNLS) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be JNLC, JNLS");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public JNLC getJNLC() throws ClassCastException {
        return (JNLC)super.getActualInstance();
    }

    public JNLS getJNLS() throws ClassCastException {
        return (JNLS)super.getActualInstance();
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        int validCount = 0;
        ArrayList<String> errorMessages = new ArrayList<String>();
        try {
            JNLC.validateJsonElement(jsonElement);
            ++validCount;
        }
        catch (Exception e) {
            errorMessages.add(String.format("Deserialization for JNLC failed with `%s`.", e.getMessage()));
        }
        try {
            JNLS.validateJsonElement(jsonElement);
            ++validCount;
        }
        catch (Exception e) {
            errorMessages.add(String.format("Deserialization for JNLS failed with `%s`.", e.getMessage()));
        }
        if (validCount != 1) {
            throw new IOException(String.format("The JSON string is invalid for JournalResource with oneOf schemas: JNLC, JNLS. %d class(es) match the result, expected 1. Detailed failure message for oneOf schemas: %s. JSON: %s", validCount, errorMessages, jsonElement.toString()));
        }
    }

    public static JournalResource fromJson(String jsonString) throws IOException {
        return (JournalResource)JSON.getGson().fromJson(jsonString, JournalResource.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        schemas.put("JNLC", JNLC.class);
        schemas.put("JNLS", JNLS.class);
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!JournalResource.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter adapterJNLC = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(JNLC.class));
            final TypeAdapter adapterJNLS = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(JNLS.class));
            return new TypeAdapter<JournalResource>(){

                public void write(JsonWriter out, JournalResource value) throws IOException {
                    if (value == null || value.getActualInstance() == null) {
                        elementAdapter.write(out, null);
                        return;
                    }
                    if (value.getActualInstance() instanceof JNLC) {
                        JsonElement element = adapterJNLC.toJsonTree((Object)((JNLC)value.getActualInstance()));
                        elementAdapter.write(out, (Object)element);
                        return;
                    }
                    if (value.getActualInstance() instanceof JNLS) {
                        JsonElement element = adapterJNLS.toJsonTree((Object)((JNLS)value.getActualInstance()));
                        elementAdapter.write(out, (Object)element);
                        return;
                    }
                    throw new IOException("Failed to serialize as the type doesn't match oneOf schemas: JNLC, JNLS");
                }

                public JournalResource read(JsonReader in) throws IOException {
                    Object deserialized = null;
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    int match = 0;
                    ArrayList<String> errorMessages = new ArrayList<String>();
                    TypeAdapter actualAdapter = elementAdapter;
                    try {
                        JNLC.validateJsonElement(jsonElement);
                        actualAdapter = adapterJNLC;
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'JNLC'");
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format("Deserialization for JNLC failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'JNLC'", e);
                    }
                    try {
                        JNLS.validateJsonElement(jsonElement);
                        actualAdapter = adapterJNLS;
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'JNLS'");
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format("Deserialization for JNLS failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'JNLS'", e);
                    }
                    if (match == 1) {
                        JournalResource ret = new JournalResource();
                        ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                        return ret;
                    }
                    throw new IOException(String.format("Failed deserialization for JournalResource: %d classes match result, expected 1. Detailed failure message for oneOf schemas: %s. JSON: %s", match, errorMessages, jsonElement.toString()));
                }
            }.nullSafe();
        }
    }
}

