/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.jacobpeterson.alpaca.openapi.broker.JSON;
import net.jacobpeterson.alpaca.openapi.broker.model.JournalEntryType;
import net.jacobpeterson.alpaca.openapi.broker.model.JournalStatus;

public class JournalStatusEvent {
    public static final String SERIALIZED_NAME_AT = "at";
    @SerializedName(value="at")
    private OffsetDateTime at;
    public static final String SERIALIZED_NAME_ENTRY_TYPE = "entry_type";
    @SerializedName(value="entry_type")
    private JournalEntryType entryType;
    public static final String SERIALIZED_NAME_EVENT_ID = "event_id";
    @SerializedName(value="event_id")
    private Integer eventId;
    public static final String SERIALIZED_NAME_EVENT_ULID = "event_ulid";
    @SerializedName(value="event_ulid")
    private String eventUlid;
    public static final String SERIALIZED_NAME_JOURNAL_ID = "journal_id";
    @SerializedName(value="journal_id")
    private UUID journalId;
    public static final String SERIALIZED_NAME_STATUS_FROM = "status_from";
    @SerializedName(value="status_from")
    private JournalStatus statusFrom;
    public static final String SERIALIZED_NAME_STATUS_TO = "status_to";
    @SerializedName(value="status_to")
    private JournalStatus statusTo;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public JournalStatusEvent at(OffsetDateTime at) {
        this.at = at;
        return this;
    }

    @Nonnull
    public OffsetDateTime getAt() {
        return this.at;
    }

    public void setAt(OffsetDateTime at) {
        this.at = at;
    }

    public JournalStatusEvent entryType(JournalEntryType entryType) {
        this.entryType = entryType;
        return this;
    }

    @Nonnull
    public JournalEntryType getEntryType() {
        return this.entryType;
    }

    public void setEntryType(JournalEntryType entryType) {
        this.entryType = entryType;
    }

    public JournalStatusEvent eventId(Integer eventId) {
        this.eventId = eventId;
        return this;
    }

    @Nonnull
    public Integer getEventId() {
        return this.eventId;
    }

    public void setEventId(Integer eventId) {
        this.eventId = eventId;
    }

    public JournalStatusEvent eventUlid(String eventUlid) {
        this.eventUlid = eventUlid;
        return this;
    }

    @Nonnull
    public String getEventUlid() {
        return this.eventUlid;
    }

    public void setEventUlid(String eventUlid) {
        this.eventUlid = eventUlid;
    }

    public JournalStatusEvent journalId(UUID journalId) {
        this.journalId = journalId;
        return this;
    }

    @Nonnull
    public UUID getJournalId() {
        return this.journalId;
    }

    public void setJournalId(UUID journalId) {
        this.journalId = journalId;
    }

    public JournalStatusEvent statusFrom(JournalStatus statusFrom) {
        this.statusFrom = statusFrom;
        return this;
    }

    @Nonnull
    public JournalStatus getStatusFrom() {
        return this.statusFrom;
    }

    public void setStatusFrom(JournalStatus statusFrom) {
        this.statusFrom = statusFrom;
    }

    public JournalStatusEvent statusTo(JournalStatus statusTo) {
        this.statusTo = statusTo;
        return this;
    }

    @Nonnull
    public JournalStatus getStatusTo() {
        return this.statusTo;
    }

    public void setStatusTo(JournalStatus statusTo) {
        this.statusTo = statusTo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JournalStatusEvent journalStatusEvent = (JournalStatusEvent)o;
        return Objects.equals(this.at, journalStatusEvent.at) && Objects.equals((Object)this.entryType, (Object)journalStatusEvent.entryType) && Objects.equals(this.eventId, journalStatusEvent.eventId) && Objects.equals(this.eventUlid, journalStatusEvent.eventUlid) && Objects.equals(this.journalId, journalStatusEvent.journalId) && Objects.equals((Object)this.statusFrom, (Object)journalStatusEvent.statusFrom) && Objects.equals((Object)this.statusTo, (Object)journalStatusEvent.statusTo);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.at, this.entryType, this.eventId, this.eventUlid, this.journalId, this.statusFrom, this.statusTo});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JournalStatusEvent {\n");
        sb.append("    at: ").append(this.toIndentedString(this.at)).append("\n");
        sb.append("    entryType: ").append(this.toIndentedString((Object)this.entryType)).append("\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    eventUlid: ").append(this.toIndentedString(this.eventUlid)).append("\n");
        sb.append("    journalId: ").append(this.toIndentedString(this.journalId)).append("\n");
        sb.append("    statusFrom: ").append(this.toIndentedString((Object)this.statusFrom)).append("\n");
        sb.append("    statusTo: ").append(this.toIndentedString((Object)this.statusTo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in JournalStatusEvent is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `JournalStatusEvent` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        JournalEntryType.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ENTRY_TYPE));
        if (!jsonObj.get(SERIALIZED_NAME_EVENT_ULID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `event_ulid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EVENT_ULID).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_JOURNAL_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `journal_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_JOURNAL_ID).toString()));
        }
        JournalStatus.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATUS_FROM));
        JournalStatus.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATUS_TO));
    }

    public static JournalStatusEvent fromJson(String jsonString) throws IOException {
        return (JournalStatusEvent)JSON.getGson().fromJson(jsonString, JournalStatusEvent.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AT);
        openapiFields.add(SERIALIZED_NAME_ENTRY_TYPE);
        openapiFields.add(SERIALIZED_NAME_EVENT_ID);
        openapiFields.add(SERIALIZED_NAME_EVENT_ULID);
        openapiFields.add(SERIALIZED_NAME_JOURNAL_ID);
        openapiFields.add(SERIALIZED_NAME_STATUS_FROM);
        openapiFields.add(SERIALIZED_NAME_STATUS_TO);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_AT);
        openapiRequiredFields.add(SERIALIZED_NAME_ENTRY_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_EVENT_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_EVENT_ULID);
        openapiRequiredFields.add(SERIALIZED_NAME_JOURNAL_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS_FROM);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS_TO);
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!JournalStatusEvent.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(JournalStatusEvent.class));
            return new TypeAdapter<JournalStatusEvent>(){

                public void write(JsonWriter out, JournalStatusEvent value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public JournalStatusEvent read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    JournalStatusEvent.validateJsonElement(jsonElement);
                    return (JournalStatusEvent)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

