/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.jacobpeterson.alpaca.openapi.broker.JSON;

public class OAuthTokenRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_CLIENT_SECRET = "client_secret";
    @SerializedName(value="client_secret")
    private String clientSecret;
    public static final String SERIALIZED_NAME_REDIRECT_URI = "redirect_uri";
    @SerializedName(value="redirect_uri")
    private String redirectUri;
    public static final String SERIALIZED_NAME_SCOPE = "scope";
    @SerializedName(value="scope")
    private String scope;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private UUID accountId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public OAuthTokenRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nonnull
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public OAuthTokenRequest clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @Nonnull
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public OAuthTokenRequest redirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
        return this;
    }

    @Nonnull
    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public OAuthTokenRequest scope(String scope) {
        this.scope = scope;
        return this;
    }

    @Nonnull
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public OAuthTokenRequest accountId(UUID accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nonnull
    public UUID getAccountId() {
        return this.accountId;
    }

    public void setAccountId(UUID accountId) {
        this.accountId = accountId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthTokenRequest oauthTokenRequest = (OAuthTokenRequest)o;
        return Objects.equals(this.clientId, oauthTokenRequest.clientId) && Objects.equals(this.clientSecret, oauthTokenRequest.clientSecret) && Objects.equals(this.redirectUri, oauthTokenRequest.redirectUri) && Objects.equals(this.scope, oauthTokenRequest.scope) && Objects.equals(this.accountId, oauthTokenRequest.accountId);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.clientSecret, this.redirectUri, this.scope, this.accountId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuthTokenRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientSecret: ").append(this.toIndentedString(this.clientSecret)).append("\n");
        sb.append("    redirectUri: ").append(this.toIndentedString(this.redirectUri)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in OAuthTokenRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `OAuthTokenRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_CLIENT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `client_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CLIENT_ID).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_CLIENT_SECRET).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `client_secret` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CLIENT_SECRET).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_REDIRECT_URI).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `redirect_uri` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REDIRECT_URI).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_SCOPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `scope` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SCOPE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `account_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID).toString()));
        }
    }

    public static OAuthTokenRequest fromJson(String jsonString) throws IOException {
        return (OAuthTokenRequest)JSON.getGson().fromJson(jsonString, OAuthTokenRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CLIENT_ID);
        openapiFields.add(SERIALIZED_NAME_CLIENT_SECRET);
        openapiFields.add(SERIALIZED_NAME_REDIRECT_URI);
        openapiFields.add(SERIALIZED_NAME_SCOPE);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_ID);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_CLIENT_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_CLIENT_SECRET);
        openapiRequiredFields.add(SERIALIZED_NAME_REDIRECT_URI);
        openapiRequiredFields.add(SERIALIZED_NAME_SCOPE);
        openapiRequiredFields.add(SERIALIZED_NAME_ACCOUNT_ID);
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!OAuthTokenRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(OAuthTokenRequest.class));
            return new TypeAdapter<OAuthTokenRequest>(){

                public void write(JsonWriter out, OAuthTokenRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public OAuthTokenRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    OAuthTokenRequest.validateJsonElement(jsonElement);
                    return (OAuthTokenRequest)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

