/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.broker.JSON;

public class OptionContract {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_SYMBOL = "symbol";
    @SerializedName(value="symbol")
    private String symbol;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static final String SERIALIZED_NAME_TRADABLE = "tradable";
    @SerializedName(value="tradable")
    private Boolean tradable;
    public static final String SERIALIZED_NAME_EXPIRATION_DATE = "expiration_date";
    @SerializedName(value="expiration_date")
    private LocalDate expirationDate;
    public static final String SERIALIZED_NAME_ROOT_SYMBOL = "root_symbol";
    @SerializedName(value="root_symbol")
    private String rootSymbol;
    public static final String SERIALIZED_NAME_UNDERLYING_SYMBOL = "underlying_symbol";
    @SerializedName(value="underlying_symbol")
    private String underlyingSymbol;
    public static final String SERIALIZED_NAME_UNDERLYING_ASSET_ID = "underlying_asset_id";
    @SerializedName(value="underlying_asset_id")
    private String underlyingAssetId;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_STYLE = "style";
    @SerializedName(value="style")
    private StyleEnum style;
    public static final String SERIALIZED_NAME_STRIKE_PRICE = "strike_price";
    @SerializedName(value="strike_price")
    private String strikePrice;
    public static final String SERIALIZED_NAME_SIZE = "size";
    @SerializedName(value="size")
    private String size;
    public static final String SERIALIZED_NAME_OPEN_INTEREST = "open_interest";
    @SerializedName(value="open_interest")
    private String openInterest;
    public static final String SERIALIZED_NAME_OPEN_INTEREST_DATE = "open_interest_date";
    @SerializedName(value="open_interest_date")
    private LocalDate openInterestDate;
    public static final String SERIALIZED_NAME_CLOSE_PRICE = "close_price";
    @SerializedName(value="close_price")
    private String closePrice;
    public static final String SERIALIZED_NAME_CLOSE_PRICE_DATE = "close_price_date";
    @SerializedName(value="close_price_date")
    private LocalDate closePriceDate;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public OptionContract id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public OptionContract symbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Nonnull
    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public OptionContract name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OptionContract status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public OptionContract tradable(Boolean tradable) {
        this.tradable = tradable;
        return this;
    }

    @Nonnull
    public Boolean getTradable() {
        return this.tradable;
    }

    public void setTradable(Boolean tradable) {
        this.tradable = tradable;
    }

    public OptionContract expirationDate(LocalDate expirationDate) {
        this.expirationDate = expirationDate;
        return this;
    }

    @Nonnull
    public LocalDate getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(LocalDate expirationDate) {
        this.expirationDate = expirationDate;
    }

    public OptionContract rootSymbol(String rootSymbol) {
        this.rootSymbol = rootSymbol;
        return this;
    }

    @Nullable
    public String getRootSymbol() {
        return this.rootSymbol;
    }

    public void setRootSymbol(String rootSymbol) {
        this.rootSymbol = rootSymbol;
    }

    public OptionContract underlyingSymbol(String underlyingSymbol) {
        this.underlyingSymbol = underlyingSymbol;
        return this;
    }

    @Nonnull
    public String getUnderlyingSymbol() {
        return this.underlyingSymbol;
    }

    public void setUnderlyingSymbol(String underlyingSymbol) {
        this.underlyingSymbol = underlyingSymbol;
    }

    public OptionContract underlyingAssetId(String underlyingAssetId) {
        this.underlyingAssetId = underlyingAssetId;
        return this;
    }

    @Nonnull
    public String getUnderlyingAssetId() {
        return this.underlyingAssetId;
    }

    public void setUnderlyingAssetId(String underlyingAssetId) {
        this.underlyingAssetId = underlyingAssetId;
    }

    public OptionContract type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public OptionContract style(StyleEnum style) {
        this.style = style;
        return this;
    }

    @Nonnull
    public StyleEnum getStyle() {
        return this.style;
    }

    public void setStyle(StyleEnum style) {
        this.style = style;
    }

    public OptionContract strikePrice(String strikePrice) {
        this.strikePrice = strikePrice;
        return this;
    }

    @Nonnull
    public String getStrikePrice() {
        return this.strikePrice;
    }

    public void setStrikePrice(String strikePrice) {
        this.strikePrice = strikePrice;
    }

    public OptionContract size(String size) {
        this.size = size;
        return this;
    }

    @Nonnull
    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public OptionContract openInterest(String openInterest) {
        this.openInterest = openInterest;
        return this;
    }

    @Nullable
    public String getOpenInterest() {
        return this.openInterest;
    }

    public void setOpenInterest(String openInterest) {
        this.openInterest = openInterest;
    }

    public OptionContract openInterestDate(LocalDate openInterestDate) {
        this.openInterestDate = openInterestDate;
        return this;
    }

    @Nullable
    public LocalDate getOpenInterestDate() {
        return this.openInterestDate;
    }

    public void setOpenInterestDate(LocalDate openInterestDate) {
        this.openInterestDate = openInterestDate;
    }

    public OptionContract closePrice(String closePrice) {
        this.closePrice = closePrice;
        return this;
    }

    @Nullable
    public String getClosePrice() {
        return this.closePrice;
    }

    public void setClosePrice(String closePrice) {
        this.closePrice = closePrice;
    }

    public OptionContract closePriceDate(LocalDate closePriceDate) {
        this.closePriceDate = closePriceDate;
        return this;
    }

    @Nullable
    public LocalDate getClosePriceDate() {
        return this.closePriceDate;
    }

    public void setClosePriceDate(LocalDate closePriceDate) {
        this.closePriceDate = closePriceDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptionContract optionContract = (OptionContract)o;
        return Objects.equals(this.id, optionContract.id) && Objects.equals(this.symbol, optionContract.symbol) && Objects.equals(this.name, optionContract.name) && Objects.equals((Object)this.status, (Object)optionContract.status) && Objects.equals(this.tradable, optionContract.tradable) && Objects.equals(this.expirationDate, optionContract.expirationDate) && Objects.equals(this.rootSymbol, optionContract.rootSymbol) && Objects.equals(this.underlyingSymbol, optionContract.underlyingSymbol) && Objects.equals(this.underlyingAssetId, optionContract.underlyingAssetId) && Objects.equals((Object)this.type, (Object)optionContract.type) && Objects.equals((Object)this.style, (Object)optionContract.style) && Objects.equals(this.strikePrice, optionContract.strikePrice) && Objects.equals(this.size, optionContract.size) && Objects.equals(this.openInterest, optionContract.openInterest) && Objects.equals(this.openInterestDate, optionContract.openInterestDate) && Objects.equals(this.closePrice, optionContract.closePrice) && Objects.equals(this.closePriceDate, optionContract.closePriceDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.symbol, this.name, this.status, this.tradable, this.expirationDate, this.rootSymbol, this.underlyingSymbol, this.underlyingAssetId, this.type, this.style, this.strikePrice, this.size, this.openInterest, this.openInterestDate, this.closePrice, this.closePriceDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OptionContract {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    symbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    tradable: ").append(this.toIndentedString(this.tradable)).append("\n");
        sb.append("    expirationDate: ").append(this.toIndentedString(this.expirationDate)).append("\n");
        sb.append("    rootSymbol: ").append(this.toIndentedString(this.rootSymbol)).append("\n");
        sb.append("    underlyingSymbol: ").append(this.toIndentedString(this.underlyingSymbol)).append("\n");
        sb.append("    underlyingAssetId: ").append(this.toIndentedString(this.underlyingAssetId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    style: ").append(this.toIndentedString((Object)this.style)).append("\n");
        sb.append("    strikePrice: ").append(this.toIndentedString(this.strikePrice)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    openInterest: ").append(this.toIndentedString(this.openInterest)).append("\n");
        sb.append("    openInterestDate: ").append(this.toIndentedString(this.openInterestDate)).append("\n");
        sb.append("    closePrice: ").append(this.toIndentedString(this.closePrice)).append("\n");
        sb.append("    closePriceDate: ").append(this.toIndentedString(this.closePriceDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in OptionContract is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `OptionContract` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_SYMBOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SYMBOL).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
        }
        StatusEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATUS));
        if (jsonObj.get(SERIALIZED_NAME_ROOT_SYMBOL) != null && !jsonObj.get(SERIALIZED_NAME_ROOT_SYMBOL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ROOT_SYMBOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `root_symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ROOT_SYMBOL).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_UNDERLYING_SYMBOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `underlying_symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UNDERLYING_SYMBOL).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_UNDERLYING_ASSET_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `underlying_asset_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UNDERLYING_ASSET_ID).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
        }
        TypeEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TYPE));
        if (!jsonObj.get(SERIALIZED_NAME_STYLE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `style` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STYLE).toString()));
        }
        StyleEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STYLE));
        if (!jsonObj.get(SERIALIZED_NAME_STRIKE_PRICE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `strike_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STRIKE_PRICE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_SIZE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `size` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SIZE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OPEN_INTEREST) != null && !jsonObj.get(SERIALIZED_NAME_OPEN_INTEREST).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_OPEN_INTEREST).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `open_interest` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OPEN_INTEREST).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CLOSE_PRICE) != null && !jsonObj.get(SERIALIZED_NAME_CLOSE_PRICE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CLOSE_PRICE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `close_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CLOSE_PRICE).toString()));
        }
    }

    public static OptionContract fromJson(String jsonString) throws IOException {
        return (OptionContract)JSON.getGson().fromJson(jsonString, OptionContract.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_SYMBOL);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_TRADABLE);
        openapiFields.add(SERIALIZED_NAME_EXPIRATION_DATE);
        openapiFields.add(SERIALIZED_NAME_ROOT_SYMBOL);
        openapiFields.add(SERIALIZED_NAME_UNDERLYING_SYMBOL);
        openapiFields.add(SERIALIZED_NAME_UNDERLYING_ASSET_ID);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_STYLE);
        openapiFields.add(SERIALIZED_NAME_STRIKE_PRICE);
        openapiFields.add(SERIALIZED_NAME_SIZE);
        openapiFields.add(SERIALIZED_NAME_OPEN_INTEREST);
        openapiFields.add(SERIALIZED_NAME_OPEN_INTEREST_DATE);
        openapiFields.add(SERIALIZED_NAME_CLOSE_PRICE);
        openapiFields.add(SERIALIZED_NAME_CLOSE_PRICE_DATE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_SYMBOL);
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields.add(SERIALIZED_NAME_TRADABLE);
        openapiRequiredFields.add(SERIALIZED_NAME_EXPIRATION_DATE);
        openapiRequiredFields.add(SERIALIZED_NAME_UNDERLYING_SYMBOL);
        openapiRequiredFields.add(SERIALIZED_NAME_UNDERLYING_ASSET_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_STYLE);
        openapiRequiredFields.add(SERIALIZED_NAME_STRIKE_PRICE);
        openapiRequiredFields.add(SERIALIZED_NAME_SIZE);
        validate = false;
        isValid = jsonElement -> true;
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        ACTIVE("active"),
        INACTIVE("inactive");

        private String value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            String value = jsonElement.getAsString();
            StatusEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        CALL("call"),
        PUT("put");

        private String value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            String value = jsonElement.getAsString();
            TypeEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StyleEnum {
        AMERICAN("american"),
        EUROPEAN("european");

        private String value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private StyleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StyleEnum fromValue(String value) {
            for (StyleEnum b : StyleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            String value = jsonElement.getAsString();
            StyleEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<StyleEnum> {
            public void write(JsonWriter jsonWriter, StyleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StyleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StyleEnum.fromValue(value);
            }
        }
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!OptionContract.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(OptionContract.class));
            return new TypeAdapter<OptionContract>(){

                public void write(JsonWriter out, OptionContract value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public OptionContract read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    OptionContract.validateJsonElement(jsonElement);
                    return (OptionContract)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

