/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.function.Predicate;

@JsonAdapter(value=Adapter.class)
public enum OrderStatus {
    NEW("new"),
    PARTIALLY_FILLED("partially_filled"),
    FILLED("filled"),
    DONE_FOR_DAY("done_for_day"),
    CANCELED("canceled"),
    EXPIRED("expired"),
    REPLACED("replaced"),
    PENDING_CANCEL("pending_cancel"),
    PENDING_REPLACE("pending_replace"),
    ACCEPTED("accepted"),
    PENDING_NEW("pending_new"),
    ACCEPTED_FOR_BIDDING("accepted_for_bidding"),
    STOPPED("stopped"),
    REJECTED("rejected"),
    SUSPENDED("suspended"),
    CALCULATED("calculated");

    private String value;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    private OrderStatus(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OrderStatus fromValue(String value) {
        for (OrderStatus b : OrderStatus.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        return null;
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        String value = jsonElement.getAsString();
        OrderStatus.fromValue(value);
    }

    static {
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class Adapter
    extends TypeAdapter<OrderStatus> {
        public void write(JsonWriter jsonWriter, OrderStatus enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public OrderStatus read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return OrderStatus.fromValue(value);
        }
    }
}

