/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.broker.JSON;
import net.jacobpeterson.alpaca.openapi.broker.model.PortfolioWeights;

public class Portfolio {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private String status;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_WEIGHTS = "weights";
    @SerializedName(value="weights")
    private List<PortfolioWeights> weights;
    public static final String SERIALIZED_NAME_COOLDOWN_DAYS = "cooldown_days";
    @SerializedName(value="cooldown_days")
    private String cooldownDays;
    public static final String SERIALIZED_NAME_REBALANCING_CONDITIONS = "rebalancing_conditions";
    @SerializedName(value="rebalancing_conditions")
    private String rebalancingConditions;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private String createdAt;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updated_at";
    @SerializedName(value="updated_at")
    private String updatedAt;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public Portfolio id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Portfolio name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Portfolio status(String status) {
        this.status = status;
        return this;
    }

    @Nullable
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Portfolio description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Portfolio weights(List<PortfolioWeights> weights) {
        this.weights = weights;
        return this;
    }

    public Portfolio addWeightsItem(PortfolioWeights weightsItem) {
        if (this.weights == null) {
            this.weights = new ArrayList<PortfolioWeights>();
        }
        this.weights.add(weightsItem);
        return this;
    }

    @Nullable
    public List<PortfolioWeights> getWeights() {
        return this.weights;
    }

    public void setWeights(List<PortfolioWeights> weights) {
        this.weights = weights;
    }

    public Portfolio cooldownDays(String cooldownDays) {
        this.cooldownDays = cooldownDays;
        return this;
    }

    @Nullable
    public String getCooldownDays() {
        return this.cooldownDays;
    }

    public void setCooldownDays(String cooldownDays) {
        this.cooldownDays = cooldownDays;
    }

    public Portfolio rebalancingConditions(String rebalancingConditions) {
        this.rebalancingConditions = rebalancingConditions;
        return this;
    }

    @Nullable
    public String getRebalancingConditions() {
        return this.rebalancingConditions;
    }

    public void setRebalancingConditions(String rebalancingConditions) {
        this.rebalancingConditions = rebalancingConditions;
    }

    public Portfolio createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public Portfolio updatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Portfolio portfolio = (Portfolio)o;
        return Objects.equals(this.id, portfolio.id) && Objects.equals(this.name, portfolio.name) && Objects.equals(this.status, portfolio.status) && Objects.equals(this.description, portfolio.description) && Objects.equals(this.weights, portfolio.weights) && Objects.equals(this.cooldownDays, portfolio.cooldownDays) && Objects.equals(this.rebalancingConditions, portfolio.rebalancingConditions) && Objects.equals(this.createdAt, portfolio.createdAt) && Objects.equals(this.updatedAt, portfolio.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.status, this.description, this.weights, this.cooldownDays, this.rebalancingConditions, this.createdAt, this.updatedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Portfolio {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    weights: ").append(this.toIndentedString(this.weights)).append("\n");
        sb.append("    cooldownDays: ").append(this.toIndentedString(this.cooldownDays)).append("\n");
        sb.append("    rebalancingConditions: ").append(this.toIndentedString(this.rebalancingConditions)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayweights;
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Portfolio is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Portfolio` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_WEIGHTS) != null && !jsonObj.get(SERIALIZED_NAME_WEIGHTS).isJsonNull() && (jsonArrayweights = jsonObj.getAsJsonArray(SERIALIZED_NAME_WEIGHTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_WEIGHTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `weights` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WEIGHTS).toString()));
            }
            for (int i = 0; i < jsonArrayweights.size(); ++i) {
                PortfolioWeights.validateJsonElement(jsonArrayweights.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_COOLDOWN_DAYS) != null && !jsonObj.get(SERIALIZED_NAME_COOLDOWN_DAYS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_COOLDOWN_DAYS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cooldown_days` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COOLDOWN_DAYS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REBALANCING_CONDITIONS) != null && !jsonObj.get(SERIALIZED_NAME_REBALANCING_CONDITIONS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REBALANCING_CONDITIONS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `rebalancing_conditions` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REBALANCING_CONDITIONS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CREATED_AT) != null && !jsonObj.get(SERIALIZED_NAME_CREATED_AT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CREATED_AT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `created_at` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CREATED_AT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UPDATED_AT) != null && !jsonObj.get(SERIALIZED_NAME_UPDATED_AT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UPDATED_AT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `updated_at` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UPDATED_AT).toString()));
        }
    }

    public static Portfolio fromJson(String jsonString) throws IOException {
        return (Portfolio)JSON.getGson().fromJson(jsonString, Portfolio.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_WEIGHTS);
        openapiFields.add(SERIALIZED_NAME_COOLDOWN_DAYS);
        openapiFields.add(SERIALIZED_NAME_REBALANCING_CONDITIONS);
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiFields.add(SERIALIZED_NAME_UPDATED_AT);
        openapiRequiredFields = new HashSet();
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Portfolio.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Portfolio.class));
            return new TypeAdapter<Portfolio>(){

                public void write(JsonWriter out, Portfolio value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Portfolio read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Portfolio.validateJsonElement(jsonElement);
                    return (Portfolio)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

