/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.broker.JSON;

public class PortfolioHistory {
    public static final String SERIALIZED_NAME_TIMESTAMP = "timestamp";
    @SerializedName(value="timestamp")
    private List<Integer> timestamp = new ArrayList<Integer>();
    public static final String SERIALIZED_NAME_EQUITY = "equity";
    @SerializedName(value="equity")
    private List<BigDecimal> equity = new ArrayList<BigDecimal>();
    public static final String SERIALIZED_NAME_PROFIT_LOSS = "profit_loss";
    @SerializedName(value="profit_loss")
    private List<BigDecimal> profitLoss = new ArrayList<BigDecimal>();
    public static final String SERIALIZED_NAME_PROFIT_LOSS_PCT = "profit_loss_pct";
    @SerializedName(value="profit_loss_pct")
    private List<BigDecimal> profitLossPct = new ArrayList<BigDecimal>();
    public static final String SERIALIZED_NAME_BASE_VALUE = "base_value";
    @SerializedName(value="base_value")
    private BigDecimal baseValue;
    public static final String SERIALIZED_NAME_BASE_VALUE_ASOF = "base_value_asof";
    @SerializedName(value="base_value_asof")
    private LocalDate baseValueAsof;
    public static final String SERIALIZED_NAME_TIMEFRAME = "timeframe";
    @SerializedName(value="timeframe")
    private String timeframe;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public PortfolioHistory timestamp(List<Integer> timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public PortfolioHistory addTimestampItem(Integer timestampItem) {
        if (this.timestamp == null) {
            this.timestamp = new ArrayList<Integer>();
        }
        this.timestamp.add(timestampItem);
        return this;
    }

    @Nonnull
    public List<Integer> getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(List<Integer> timestamp) {
        this.timestamp = timestamp;
    }

    public PortfolioHistory equity(List<BigDecimal> equity) {
        this.equity = equity;
        return this;
    }

    public PortfolioHistory addEquityItem(BigDecimal equityItem) {
        if (this.equity == null) {
            this.equity = new ArrayList<BigDecimal>();
        }
        this.equity.add(equityItem);
        return this;
    }

    @Nonnull
    public List<BigDecimal> getEquity() {
        return this.equity;
    }

    public void setEquity(List<BigDecimal> equity) {
        this.equity = equity;
    }

    public PortfolioHistory profitLoss(List<BigDecimal> profitLoss) {
        this.profitLoss = profitLoss;
        return this;
    }

    public PortfolioHistory addProfitLossItem(BigDecimal profitLossItem) {
        if (this.profitLoss == null) {
            this.profitLoss = new ArrayList<BigDecimal>();
        }
        this.profitLoss.add(profitLossItem);
        return this;
    }

    @Nonnull
    public List<BigDecimal> getProfitLoss() {
        return this.profitLoss;
    }

    public void setProfitLoss(List<BigDecimal> profitLoss) {
        this.profitLoss = profitLoss;
    }

    public PortfolioHistory profitLossPct(List<BigDecimal> profitLossPct) {
        this.profitLossPct = profitLossPct;
        return this;
    }

    public PortfolioHistory addProfitLossPctItem(BigDecimal profitLossPctItem) {
        if (this.profitLossPct == null) {
            this.profitLossPct = new ArrayList<BigDecimal>();
        }
        this.profitLossPct.add(profitLossPctItem);
        return this;
    }

    @Nonnull
    public List<BigDecimal> getProfitLossPct() {
        return this.profitLossPct;
    }

    public void setProfitLossPct(List<BigDecimal> profitLossPct) {
        this.profitLossPct = profitLossPct;
    }

    public PortfolioHistory baseValue(BigDecimal baseValue) {
        this.baseValue = baseValue;
        return this;
    }

    @Nonnull
    public BigDecimal getBaseValue() {
        return this.baseValue;
    }

    public void setBaseValue(BigDecimal baseValue) {
        this.baseValue = baseValue;
    }

    public PortfolioHistory baseValueAsof(LocalDate baseValueAsof) {
        this.baseValueAsof = baseValueAsof;
        return this;
    }

    @Nullable
    public LocalDate getBaseValueAsof() {
        return this.baseValueAsof;
    }

    public void setBaseValueAsof(LocalDate baseValueAsof) {
        this.baseValueAsof = baseValueAsof;
    }

    public PortfolioHistory timeframe(String timeframe) {
        this.timeframe = timeframe;
        return this;
    }

    @Nonnull
    public String getTimeframe() {
        return this.timeframe;
    }

    public void setTimeframe(String timeframe) {
        this.timeframe = timeframe;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PortfolioHistory portfolioHistory = (PortfolioHistory)o;
        return Objects.equals(this.timestamp, portfolioHistory.timestamp) && Objects.equals(this.equity, portfolioHistory.equity) && Objects.equals(this.profitLoss, portfolioHistory.profitLoss) && Objects.equals(this.profitLossPct, portfolioHistory.profitLossPct) && Objects.equals(this.baseValue, portfolioHistory.baseValue) && Objects.equals(this.baseValueAsof, portfolioHistory.baseValueAsof) && Objects.equals(this.timeframe, portfolioHistory.timeframe);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.equity, this.profitLoss, this.profitLossPct, this.baseValue, this.baseValueAsof, this.timeframe);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PortfolioHistory {\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    equity: ").append(this.toIndentedString(this.equity)).append("\n");
        sb.append("    profitLoss: ").append(this.toIndentedString(this.profitLoss)).append("\n");
        sb.append("    profitLossPct: ").append(this.toIndentedString(this.profitLossPct)).append("\n");
        sb.append("    baseValue: ").append(this.toIndentedString(this.baseValue)).append("\n");
        sb.append("    baseValueAsof: ").append(this.toIndentedString(this.baseValueAsof)).append("\n");
        sb.append("    timeframe: ").append(this.toIndentedString(this.timeframe)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in PortfolioHistory is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PortfolioHistory` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_TIMESTAMP) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_TIMESTAMP).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `timestamp` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TIMESTAMP).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EQUITY) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_EQUITY).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `equity` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EQUITY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PROFIT_LOSS) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_PROFIT_LOSS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `profit_loss` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROFIT_LOSS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PROFIT_LOSS_PCT) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_PROFIT_LOSS_PCT).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `profit_loss_pct` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROFIT_LOSS_PCT).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_TIMEFRAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `timeframe` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TIMEFRAME).toString()));
        }
    }

    public static PortfolioHistory fromJson(String jsonString) throws IOException {
        return (PortfolioHistory)JSON.getGson().fromJson(jsonString, PortfolioHistory.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_TIMESTAMP);
        openapiFields.add(SERIALIZED_NAME_EQUITY);
        openapiFields.add(SERIALIZED_NAME_PROFIT_LOSS);
        openapiFields.add(SERIALIZED_NAME_PROFIT_LOSS_PCT);
        openapiFields.add(SERIALIZED_NAME_BASE_VALUE);
        openapiFields.add(SERIALIZED_NAME_BASE_VALUE_ASOF);
        openapiFields.add(SERIALIZED_NAME_TIMEFRAME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TIMESTAMP);
        openapiRequiredFields.add(SERIALIZED_NAME_EQUITY);
        openapiRequiredFields.add(SERIALIZED_NAME_PROFIT_LOSS);
        openapiRequiredFields.add(SERIALIZED_NAME_PROFIT_LOSS_PCT);
        openapiRequiredFields.add(SERIALIZED_NAME_BASE_VALUE);
        openapiRequiredFields.add(SERIALIZED_NAME_TIMEFRAME);
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PortfolioHistory.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PortfolioHistory.class));
            return new TypeAdapter<PortfolioHistory>(){

                public void write(JsonWriter out, PortfolioHistory value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PortfolioHistory read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    PortfolioHistory.validateJsonElement(jsonElement);
                    return (PortfolioHistory)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

