/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.broker.JSON;
import net.jacobpeterson.alpaca.openapi.broker.model.Order;
import net.jacobpeterson.alpaca.openapi.broker.model.PortfolioRunStatus;
import net.jacobpeterson.alpaca.openapi.broker.model.PortfolioWeights;
import net.jacobpeterson.alpaca.openapi.broker.model.SkippedOrder;

public class PortfolioRun {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_PORTFOLIO_ID = "portfolio_id";
    @SerializedName(value="portfolio_id")
    private String portfolioId;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_INITIATED_BY = "initiated_by";
    @SerializedName(value="initiated_by")
    private String initiatedBy;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updated_at";
    @SerializedName(value="updated_at")
    private String updatedAt;
    public static final String SERIALIZED_NAME_COMPLETED_AT = "completed_at";
    @SerializedName(value="completed_at")
    private String completedAt;
    public static final String SERIALIZED_NAME_CANCELED_AT = "canceled_at";
    @SerializedName(value="canceled_at")
    private String canceledAt;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private PortfolioRunStatus status;
    public static final String SERIALIZED_NAME_REASON = "reason";
    @SerializedName(value="reason")
    private String reason;
    public static final String SERIALIZED_NAME_WEIGHTS = "weights";
    @SerializedName(value="weights")
    private List<PortfolioWeights> weights;
    public static final String SERIALIZED_NAME_ORDERS = "orders";
    @SerializedName(value="orders")
    private List<Order> orders;
    public static final String SERIALIZED_NAME_FAILED_ORDERS = "failed_orders";
    @SerializedName(value="failed_orders")
    private List<Order> failedOrders;
    public static final String SERIALIZED_NAME_SKIPPED_ORDERS = "skipped_orders";
    @SerializedName(value="skipped_orders")
    private List<SkippedOrder> skippedOrders;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public PortfolioRun id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public PortfolioRun accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public PortfolioRun portfolioId(String portfolioId) {
        this.portfolioId = portfolioId;
        return this;
    }

    @Nullable
    public String getPortfolioId() {
        return this.portfolioId;
    }

    public void setPortfolioId(String portfolioId) {
        this.portfolioId = portfolioId;
    }

    public PortfolioRun type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public PortfolioRun initiatedBy(String initiatedBy) {
        this.initiatedBy = initiatedBy;
        return this;
    }

    @Nullable
    public String getInitiatedBy() {
        return this.initiatedBy;
    }

    public void setInitiatedBy(String initiatedBy) {
        this.initiatedBy = initiatedBy;
    }

    public PortfolioRun updatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public PortfolioRun completedAt(String completedAt) {
        this.completedAt = completedAt;
        return this;
    }

    @Nullable
    public String getCompletedAt() {
        return this.completedAt;
    }

    public void setCompletedAt(String completedAt) {
        this.completedAt = completedAt;
    }

    public PortfolioRun canceledAt(String canceledAt) {
        this.canceledAt = canceledAt;
        return this;
    }

    @Nullable
    public String getCanceledAt() {
        return this.canceledAt;
    }

    public void setCanceledAt(String canceledAt) {
        this.canceledAt = canceledAt;
    }

    public PortfolioRun status(PortfolioRunStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    public PortfolioRunStatus getStatus() {
        return this.status;
    }

    public void setStatus(PortfolioRunStatus status) {
        this.status = status;
    }

    public PortfolioRun reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public PortfolioRun weights(List<PortfolioWeights> weights) {
        this.weights = weights;
        return this;
    }

    public PortfolioRun addWeightsItem(PortfolioWeights weightsItem) {
        if (this.weights == null) {
            this.weights = new ArrayList<PortfolioWeights>();
        }
        this.weights.add(weightsItem);
        return this;
    }

    @Nullable
    public List<PortfolioWeights> getWeights() {
        return this.weights;
    }

    public void setWeights(List<PortfolioWeights> weights) {
        this.weights = weights;
    }

    public PortfolioRun orders(List<Order> orders) {
        this.orders = orders;
        return this;
    }

    public PortfolioRun addOrdersItem(Order ordersItem) {
        if (this.orders == null) {
            this.orders = new ArrayList<Order>();
        }
        this.orders.add(ordersItem);
        return this;
    }

    @Nullable
    public List<Order> getOrders() {
        return this.orders;
    }

    public void setOrders(List<Order> orders) {
        this.orders = orders;
    }

    public PortfolioRun failedOrders(List<Order> failedOrders) {
        this.failedOrders = failedOrders;
        return this;
    }

    public PortfolioRun addFailedOrdersItem(Order failedOrdersItem) {
        if (this.failedOrders == null) {
            this.failedOrders = new ArrayList<Order>();
        }
        this.failedOrders.add(failedOrdersItem);
        return this;
    }

    @Nullable
    public List<Order> getFailedOrders() {
        return this.failedOrders;
    }

    public void setFailedOrders(List<Order> failedOrders) {
        this.failedOrders = failedOrders;
    }

    public PortfolioRun skippedOrders(List<SkippedOrder> skippedOrders) {
        this.skippedOrders = skippedOrders;
        return this;
    }

    public PortfolioRun addSkippedOrdersItem(SkippedOrder skippedOrdersItem) {
        if (this.skippedOrders == null) {
            this.skippedOrders = new ArrayList<SkippedOrder>();
        }
        this.skippedOrders.add(skippedOrdersItem);
        return this;
    }

    @Nullable
    public List<SkippedOrder> getSkippedOrders() {
        return this.skippedOrders;
    }

    public void setSkippedOrders(List<SkippedOrder> skippedOrders) {
        this.skippedOrders = skippedOrders;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PortfolioRun portfolioRun = (PortfolioRun)o;
        return Objects.equals(this.id, portfolioRun.id) && Objects.equals(this.accountId, portfolioRun.accountId) && Objects.equals(this.portfolioId, portfolioRun.portfolioId) && Objects.equals(this.type, portfolioRun.type) && Objects.equals(this.initiatedBy, portfolioRun.initiatedBy) && Objects.equals(this.updatedAt, portfolioRun.updatedAt) && Objects.equals(this.completedAt, portfolioRun.completedAt) && Objects.equals(this.canceledAt, portfolioRun.canceledAt) && Objects.equals(this.status, portfolioRun.status) && Objects.equals(this.reason, portfolioRun.reason) && Objects.equals(this.weights, portfolioRun.weights) && Objects.equals(this.orders, portfolioRun.orders) && Objects.equals(this.failedOrders, portfolioRun.failedOrders) && Objects.equals(this.skippedOrders, portfolioRun.skippedOrders);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.accountId, this.portfolioId, this.type, this.initiatedBy, this.updatedAt, this.completedAt, this.canceledAt, this.status, this.reason, this.weights, this.orders, this.failedOrders, this.skippedOrders);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PortfolioRun {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    portfolioId: ").append(this.toIndentedString(this.portfolioId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    initiatedBy: ").append(this.toIndentedString(this.initiatedBy)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    completedAt: ").append(this.toIndentedString(this.completedAt)).append("\n");
        sb.append("    canceledAt: ").append(this.toIndentedString(this.canceledAt)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    weights: ").append(this.toIndentedString(this.weights)).append("\n");
        sb.append("    orders: ").append(this.toIndentedString(this.orders)).append("\n");
        sb.append("    failedOrders: ").append(this.toIndentedString(this.failedOrders)).append("\n");
        sb.append("    skippedOrders: ").append(this.toIndentedString(this.skippedOrders)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayskippedOrders;
        JsonArray jsonArrayfailedOrders;
        JsonArray jsonArrayorders;
        int i;
        JsonArray jsonArrayweights;
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in PortfolioRun is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PortfolioRun` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `account_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PORTFOLIO_ID) != null && !jsonObj.get(SERIALIZED_NAME_PORTFOLIO_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PORTFOLIO_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `portfolio_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PORTFOLIO_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INITIATED_BY) != null && !jsonObj.get(SERIALIZED_NAME_INITIATED_BY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INITIATED_BY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `initiated_by` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INITIATED_BY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UPDATED_AT) != null && !jsonObj.get(SERIALIZED_NAME_UPDATED_AT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UPDATED_AT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `updated_at` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UPDATED_AT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMPLETED_AT) != null && !jsonObj.get(SERIALIZED_NAME_COMPLETED_AT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_COMPLETED_AT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `completed_at` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMPLETED_AT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CANCELED_AT) != null && !jsonObj.get(SERIALIZED_NAME_CANCELED_AT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CANCELED_AT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `canceled_at` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CANCELED_AT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonNull()) {
            PortfolioRunStatus.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATUS));
        }
        if (jsonObj.get(SERIALIZED_NAME_REASON) != null && !jsonObj.get(SERIALIZED_NAME_REASON).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REASON).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reason` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REASON).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_WEIGHTS) != null && !jsonObj.get(SERIALIZED_NAME_WEIGHTS).isJsonNull() && (jsonArrayweights = jsonObj.getAsJsonArray(SERIALIZED_NAME_WEIGHTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_WEIGHTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `weights` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WEIGHTS).toString()));
            }
            for (i = 0; i < jsonArrayweights.size(); ++i) {
                PortfolioWeights.validateJsonElement(jsonArrayweights.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_ORDERS) != null && !jsonObj.get(SERIALIZED_NAME_ORDERS).isJsonNull() && (jsonArrayorders = jsonObj.getAsJsonArray(SERIALIZED_NAME_ORDERS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ORDERS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `orders` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORDERS).toString()));
            }
            for (i = 0; i < jsonArrayorders.size(); ++i) {
                Order.validateJsonElement(jsonArrayorders.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_FAILED_ORDERS) != null && !jsonObj.get(SERIALIZED_NAME_FAILED_ORDERS).isJsonNull() && (jsonArrayfailedOrders = jsonObj.getAsJsonArray(SERIALIZED_NAME_FAILED_ORDERS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_FAILED_ORDERS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `failed_orders` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FAILED_ORDERS).toString()));
            }
            for (i = 0; i < jsonArrayfailedOrders.size(); ++i) {
                Order.validateJsonElement(jsonArrayfailedOrders.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_SKIPPED_ORDERS) != null && !jsonObj.get(SERIALIZED_NAME_SKIPPED_ORDERS).isJsonNull() && (jsonArrayskippedOrders = jsonObj.getAsJsonArray(SERIALIZED_NAME_SKIPPED_ORDERS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SKIPPED_ORDERS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `skipped_orders` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SKIPPED_ORDERS).toString()));
            }
            for (i = 0; i < jsonArrayskippedOrders.size(); ++i) {
                SkippedOrder.validateJsonElement(jsonArrayskippedOrders.get(i));
            }
        }
    }

    public static PortfolioRun fromJson(String jsonString) throws IOException {
        return (PortfolioRun)JSON.getGson().fromJson(jsonString, PortfolioRun.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_ID);
        openapiFields.add(SERIALIZED_NAME_PORTFOLIO_ID);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_INITIATED_BY);
        openapiFields.add(SERIALIZED_NAME_UPDATED_AT);
        openapiFields.add(SERIALIZED_NAME_COMPLETED_AT);
        openapiFields.add(SERIALIZED_NAME_CANCELED_AT);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_REASON);
        openapiFields.add(SERIALIZED_NAME_WEIGHTS);
        openapiFields.add(SERIALIZED_NAME_ORDERS);
        openapiFields.add(SERIALIZED_NAME_FAILED_ORDERS);
        openapiFields.add(SERIALIZED_NAME_SKIPPED_ORDERS);
        openapiRequiredFields = new HashSet();
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PortfolioRun.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PortfolioRun.class));
            return new TypeAdapter<PortfolioRun>(){

                public void write(JsonWriter out, PortfolioRun value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PortfolioRun read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    PortfolioRun.validateJsonElement(jsonElement);
                    return (PortfolioRun)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

