/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.broker.JSON;
import net.jacobpeterson.alpaca.openapi.broker.model.AssetClass;
import net.jacobpeterson.alpaca.openapi.broker.model.USDPosition;

public class Position {
    public static final String SERIALIZED_NAME_ASSET_ID = "asset_id";
    @SerializedName(value="asset_id")
    private UUID assetId;
    public static final String SERIALIZED_NAME_SYMBOL = "symbol";
    @SerializedName(value="symbol")
    private String symbol;
    public static final String SERIALIZED_NAME_EXCHANGE = "exchange";
    @SerializedName(value="exchange")
    private String exchange;
    public static final String SERIALIZED_NAME_ASSET_CLASS = "asset_class";
    @SerializedName(value="asset_class")
    private AssetClass assetClass;
    public static final String SERIALIZED_NAME_ASSET_MARGINABLE = "asset_marginable";
    @SerializedName(value="asset_marginable")
    private Boolean assetMarginable;
    public static final String SERIALIZED_NAME_AVG_ENTRY_PRICE = "avg_entry_price";
    @SerializedName(value="avg_entry_price")
    private String avgEntryPrice;
    public static final String SERIALIZED_NAME_QTY = "qty";
    @SerializedName(value="qty")
    private String qty;
    public static final String SERIALIZED_NAME_SIDE = "side";
    @SerializedName(value="side")
    private SideEnum side;
    public static final String SERIALIZED_NAME_MARKET_VALUE = "market_value";
    @SerializedName(value="market_value")
    private BigDecimal marketValue;
    public static final String SERIALIZED_NAME_COST_BASIS = "cost_basis";
    @SerializedName(value="cost_basis")
    private BigDecimal costBasis;
    public static final String SERIALIZED_NAME_UNREALIZED_PL = "unrealized_pl";
    @SerializedName(value="unrealized_pl")
    private BigDecimal unrealizedPl;
    public static final String SERIALIZED_NAME_UNREALIZED_PLPC = "unrealized_plpc";
    @SerializedName(value="unrealized_plpc")
    private BigDecimal unrealizedPlpc;
    public static final String SERIALIZED_NAME_UNREALIZED_INTRADAY_PL = "unrealized_intraday_pl";
    @SerializedName(value="unrealized_intraday_pl")
    private BigDecimal unrealizedIntradayPl;
    public static final String SERIALIZED_NAME_UNREALIZED_INTRADAY_PLPC = "unrealized_intraday_plpc";
    @SerializedName(value="unrealized_intraday_plpc")
    private BigDecimal unrealizedIntradayPlpc;
    public static final String SERIALIZED_NAME_CURRENT_PRICE = "current_price";
    @SerializedName(value="current_price")
    private BigDecimal currentPrice;
    public static final String SERIALIZED_NAME_LASTDAY_PRICE = "lastday_price";
    @SerializedName(value="lastday_price")
    private BigDecimal lastdayPrice;
    public static final String SERIALIZED_NAME_CHANGE_TODAY = "change_today";
    @SerializedName(value="change_today")
    private BigDecimal changeToday;
    public static final String SERIALIZED_NAME_SWAP_RATE = "swap_rate";
    @SerializedName(value="swap_rate")
    private BigDecimal swapRate;
    public static final String SERIALIZED_NAME_AVG_ENTRY_SWAP_RATE = "avg_entry_swap_rate";
    @SerializedName(value="avg_entry_swap_rate")
    private BigDecimal avgEntrySwapRate;
    public static final String SERIALIZED_NAME_USD = "usd";
    @SerializedName(value="usd")
    private USDPosition usd;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public Position assetId(UUID assetId) {
        this.assetId = assetId;
        return this;
    }

    @Nonnull
    public UUID getAssetId() {
        return this.assetId;
    }

    public void setAssetId(UUID assetId) {
        this.assetId = assetId;
    }

    public Position symbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Nonnull
    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public Position exchange(String exchange) {
        this.exchange = exchange;
        return this;
    }

    @Nonnull
    public String getExchange() {
        return this.exchange;
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    public Position assetClass(AssetClass assetClass) {
        this.assetClass = assetClass;
        return this;
    }

    @Nonnull
    public AssetClass getAssetClass() {
        return this.assetClass;
    }

    public void setAssetClass(AssetClass assetClass) {
        this.assetClass = assetClass;
    }

    public Position assetMarginable(Boolean assetMarginable) {
        this.assetMarginable = assetMarginable;
        return this;
    }

    @Nullable
    public Boolean getAssetMarginable() {
        return this.assetMarginable;
    }

    public void setAssetMarginable(Boolean assetMarginable) {
        this.assetMarginable = assetMarginable;
    }

    public Position avgEntryPrice(String avgEntryPrice) {
        this.avgEntryPrice = avgEntryPrice;
        return this;
    }

    @Nonnull
    public String getAvgEntryPrice() {
        return this.avgEntryPrice;
    }

    public void setAvgEntryPrice(String avgEntryPrice) {
        this.avgEntryPrice = avgEntryPrice;
    }

    public Position qty(String qty) {
        this.qty = qty;
        return this;
    }

    @Nonnull
    public String getQty() {
        return this.qty;
    }

    public void setQty(String qty) {
        this.qty = qty;
    }

    public Position side(SideEnum side) {
        this.side = side;
        return this;
    }

    @Nonnull
    public SideEnum getSide() {
        return this.side;
    }

    public void setSide(SideEnum side) {
        this.side = side;
    }

    public Position marketValue(BigDecimal marketValue) {
        this.marketValue = marketValue;
        return this;
    }

    @Nonnull
    public BigDecimal getMarketValue() {
        return this.marketValue;
    }

    public void setMarketValue(BigDecimal marketValue) {
        this.marketValue = marketValue;
    }

    public Position costBasis(BigDecimal costBasis) {
        this.costBasis = costBasis;
        return this;
    }

    @Nonnull
    public BigDecimal getCostBasis() {
        return this.costBasis;
    }

    public void setCostBasis(BigDecimal costBasis) {
        this.costBasis = costBasis;
    }

    public Position unrealizedPl(BigDecimal unrealizedPl) {
        this.unrealizedPl = unrealizedPl;
        return this;
    }

    @Nonnull
    public BigDecimal getUnrealizedPl() {
        return this.unrealizedPl;
    }

    public void setUnrealizedPl(BigDecimal unrealizedPl) {
        this.unrealizedPl = unrealizedPl;
    }

    public Position unrealizedPlpc(BigDecimal unrealizedPlpc) {
        this.unrealizedPlpc = unrealizedPlpc;
        return this;
    }

    @Nonnull
    public BigDecimal getUnrealizedPlpc() {
        return this.unrealizedPlpc;
    }

    public void setUnrealizedPlpc(BigDecimal unrealizedPlpc) {
        this.unrealizedPlpc = unrealizedPlpc;
    }

    public Position unrealizedIntradayPl(BigDecimal unrealizedIntradayPl) {
        this.unrealizedIntradayPl = unrealizedIntradayPl;
        return this;
    }

    @Nonnull
    public BigDecimal getUnrealizedIntradayPl() {
        return this.unrealizedIntradayPl;
    }

    public void setUnrealizedIntradayPl(BigDecimal unrealizedIntradayPl) {
        this.unrealizedIntradayPl = unrealizedIntradayPl;
    }

    public Position unrealizedIntradayPlpc(BigDecimal unrealizedIntradayPlpc) {
        this.unrealizedIntradayPlpc = unrealizedIntradayPlpc;
        return this;
    }

    @Nonnull
    public BigDecimal getUnrealizedIntradayPlpc() {
        return this.unrealizedIntradayPlpc;
    }

    public void setUnrealizedIntradayPlpc(BigDecimal unrealizedIntradayPlpc) {
        this.unrealizedIntradayPlpc = unrealizedIntradayPlpc;
    }

    public Position currentPrice(BigDecimal currentPrice) {
        this.currentPrice = currentPrice;
        return this;
    }

    @Nonnull
    public BigDecimal getCurrentPrice() {
        return this.currentPrice;
    }

    public void setCurrentPrice(BigDecimal currentPrice) {
        this.currentPrice = currentPrice;
    }

    public Position lastdayPrice(BigDecimal lastdayPrice) {
        this.lastdayPrice = lastdayPrice;
        return this;
    }

    @Nonnull
    public BigDecimal getLastdayPrice() {
        return this.lastdayPrice;
    }

    public void setLastdayPrice(BigDecimal lastdayPrice) {
        this.lastdayPrice = lastdayPrice;
    }

    public Position changeToday(BigDecimal changeToday) {
        this.changeToday = changeToday;
        return this;
    }

    @Nonnull
    public BigDecimal getChangeToday() {
        return this.changeToday;
    }

    public void setChangeToday(BigDecimal changeToday) {
        this.changeToday = changeToday;
    }

    public Position swapRate(BigDecimal swapRate) {
        this.swapRate = swapRate;
        return this;
    }

    @Nullable
    public BigDecimal getSwapRate() {
        return this.swapRate;
    }

    public void setSwapRate(BigDecimal swapRate) {
        this.swapRate = swapRate;
    }

    public Position avgEntrySwapRate(BigDecimal avgEntrySwapRate) {
        this.avgEntrySwapRate = avgEntrySwapRate;
        return this;
    }

    @Nullable
    public BigDecimal getAvgEntrySwapRate() {
        return this.avgEntrySwapRate;
    }

    public void setAvgEntrySwapRate(BigDecimal avgEntrySwapRate) {
        this.avgEntrySwapRate = avgEntrySwapRate;
    }

    public Position usd(USDPosition usd) {
        this.usd = usd;
        return this;
    }

    @Nullable
    public USDPosition getUsd() {
        return this.usd;
    }

    public void setUsd(USDPosition usd) {
        this.usd = usd;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Position position = (Position)o;
        return Objects.equals(this.assetId, position.assetId) && Objects.equals(this.symbol, position.symbol) && Objects.equals(this.exchange, position.exchange) && Objects.equals((Object)this.assetClass, (Object)position.assetClass) && Objects.equals(this.assetMarginable, position.assetMarginable) && Objects.equals(this.avgEntryPrice, position.avgEntryPrice) && Objects.equals(this.qty, position.qty) && Objects.equals((Object)this.side, (Object)position.side) && Objects.equals(this.marketValue, position.marketValue) && Objects.equals(this.costBasis, position.costBasis) && Objects.equals(this.unrealizedPl, position.unrealizedPl) && Objects.equals(this.unrealizedPlpc, position.unrealizedPlpc) && Objects.equals(this.unrealizedIntradayPl, position.unrealizedIntradayPl) && Objects.equals(this.unrealizedIntradayPlpc, position.unrealizedIntradayPlpc) && Objects.equals(this.currentPrice, position.currentPrice) && Objects.equals(this.lastdayPrice, position.lastdayPrice) && Objects.equals(this.changeToday, position.changeToday) && Objects.equals(this.swapRate, position.swapRate) && Objects.equals(this.avgEntrySwapRate, position.avgEntrySwapRate) && Objects.equals(this.usd, position.usd);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.assetId, this.symbol, this.exchange, this.assetClass, this.assetMarginable, this.avgEntryPrice, this.qty, this.side, this.marketValue, this.costBasis, this.unrealizedPl, this.unrealizedPlpc, this.unrealizedIntradayPl, this.unrealizedIntradayPlpc, this.currentPrice, this.lastdayPrice, this.changeToday, this.swapRate, this.avgEntrySwapRate, this.usd});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Position {\n");
        sb.append("    assetId: ").append(this.toIndentedString(this.assetId)).append("\n");
        sb.append("    symbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("    exchange: ").append(this.toIndentedString(this.exchange)).append("\n");
        sb.append("    assetClass: ").append(this.toIndentedString((Object)this.assetClass)).append("\n");
        sb.append("    assetMarginable: ").append(this.toIndentedString(this.assetMarginable)).append("\n");
        sb.append("    avgEntryPrice: ").append(this.toIndentedString(this.avgEntryPrice)).append("\n");
        sb.append("    qty: ").append(this.toIndentedString(this.qty)).append("\n");
        sb.append("    side: ").append(this.toIndentedString((Object)this.side)).append("\n");
        sb.append("    marketValue: ").append(this.toIndentedString(this.marketValue)).append("\n");
        sb.append("    costBasis: ").append(this.toIndentedString(this.costBasis)).append("\n");
        sb.append("    unrealizedPl: ").append(this.toIndentedString(this.unrealizedPl)).append("\n");
        sb.append("    unrealizedPlpc: ").append(this.toIndentedString(this.unrealizedPlpc)).append("\n");
        sb.append("    unrealizedIntradayPl: ").append(this.toIndentedString(this.unrealizedIntradayPl)).append("\n");
        sb.append("    unrealizedIntradayPlpc: ").append(this.toIndentedString(this.unrealizedIntradayPlpc)).append("\n");
        sb.append("    currentPrice: ").append(this.toIndentedString(this.currentPrice)).append("\n");
        sb.append("    lastdayPrice: ").append(this.toIndentedString(this.lastdayPrice)).append("\n");
        sb.append("    changeToday: ").append(this.toIndentedString(this.changeToday)).append("\n");
        sb.append("    swapRate: ").append(this.toIndentedString(this.swapRate)).append("\n");
        sb.append("    avgEntrySwapRate: ").append(this.toIndentedString(this.avgEntrySwapRate)).append("\n");
        sb.append("    usd: ").append(this.toIndentedString(this.usd)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Position is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Position` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ASSET_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `asset_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ASSET_ID).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_SYMBOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SYMBOL).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_EXCHANGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `exchange` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXCHANGE).toString()));
        }
        AssetClass.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ASSET_CLASS));
        if (!jsonObj.get(SERIALIZED_NAME_AVG_ENTRY_PRICE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `avg_entry_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AVG_ENTRY_PRICE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_QTY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_QTY).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_SIDE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `side` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SIDE).toString()));
        }
        SideEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SIDE));
        if (!jsonObj.get(SERIALIZED_NAME_MARKET_VALUE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `market_value` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MARKET_VALUE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_COST_BASIS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cost_basis` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COST_BASIS).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_UNREALIZED_PL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `unrealized_pl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UNREALIZED_PL).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_UNREALIZED_PLPC).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `unrealized_plpc` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UNREALIZED_PLPC).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_UNREALIZED_INTRADAY_PL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `unrealized_intraday_pl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UNREALIZED_INTRADAY_PL).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_UNREALIZED_INTRADAY_PLPC).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `unrealized_intraday_plpc` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UNREALIZED_INTRADAY_PLPC).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_CURRENT_PRICE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `current_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENT_PRICE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_LASTDAY_PRICE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `lastday_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LASTDAY_PRICE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_CHANGE_TODAY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `change_today` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CHANGE_TODAY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SWAP_RATE) != null && !jsonObj.get(SERIALIZED_NAME_SWAP_RATE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SWAP_RATE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `swap_rate` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SWAP_RATE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AVG_ENTRY_SWAP_RATE) != null && !jsonObj.get(SERIALIZED_NAME_AVG_ENTRY_SWAP_RATE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_AVG_ENTRY_SWAP_RATE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `avg_entry_swap_rate` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AVG_ENTRY_SWAP_RATE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USD) != null && !jsonObj.get(SERIALIZED_NAME_USD).isJsonNull()) {
            USDPosition.validateJsonElement(jsonObj.get(SERIALIZED_NAME_USD));
        }
    }

    public static Position fromJson(String jsonString) throws IOException {
        return (Position)JSON.getGson().fromJson(jsonString, Position.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ASSET_ID);
        openapiFields.add(SERIALIZED_NAME_SYMBOL);
        openapiFields.add(SERIALIZED_NAME_EXCHANGE);
        openapiFields.add(SERIALIZED_NAME_ASSET_CLASS);
        openapiFields.add(SERIALIZED_NAME_ASSET_MARGINABLE);
        openapiFields.add(SERIALIZED_NAME_AVG_ENTRY_PRICE);
        openapiFields.add(SERIALIZED_NAME_QTY);
        openapiFields.add(SERIALIZED_NAME_SIDE);
        openapiFields.add(SERIALIZED_NAME_MARKET_VALUE);
        openapiFields.add(SERIALIZED_NAME_COST_BASIS);
        openapiFields.add(SERIALIZED_NAME_UNREALIZED_PL);
        openapiFields.add(SERIALIZED_NAME_UNREALIZED_PLPC);
        openapiFields.add(SERIALIZED_NAME_UNREALIZED_INTRADAY_PL);
        openapiFields.add(SERIALIZED_NAME_UNREALIZED_INTRADAY_PLPC);
        openapiFields.add(SERIALIZED_NAME_CURRENT_PRICE);
        openapiFields.add(SERIALIZED_NAME_LASTDAY_PRICE);
        openapiFields.add(SERIALIZED_NAME_CHANGE_TODAY);
        openapiFields.add(SERIALIZED_NAME_SWAP_RATE);
        openapiFields.add(SERIALIZED_NAME_AVG_ENTRY_SWAP_RATE);
        openapiFields.add(SERIALIZED_NAME_USD);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ASSET_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_SYMBOL);
        openapiRequiredFields.add(SERIALIZED_NAME_EXCHANGE);
        openapiRequiredFields.add(SERIALIZED_NAME_ASSET_CLASS);
        openapiRequiredFields.add(SERIALIZED_NAME_AVG_ENTRY_PRICE);
        openapiRequiredFields.add(SERIALIZED_NAME_QTY);
        openapiRequiredFields.add(SERIALIZED_NAME_SIDE);
        openapiRequiredFields.add(SERIALIZED_NAME_MARKET_VALUE);
        openapiRequiredFields.add(SERIALIZED_NAME_COST_BASIS);
        openapiRequiredFields.add(SERIALIZED_NAME_UNREALIZED_PL);
        openapiRequiredFields.add(SERIALIZED_NAME_UNREALIZED_PLPC);
        openapiRequiredFields.add(SERIALIZED_NAME_UNREALIZED_INTRADAY_PL);
        openapiRequiredFields.add(SERIALIZED_NAME_UNREALIZED_INTRADAY_PLPC);
        openapiRequiredFields.add(SERIALIZED_NAME_CURRENT_PRICE);
        openapiRequiredFields.add(SERIALIZED_NAME_LASTDAY_PRICE);
        openapiRequiredFields.add(SERIALIZED_NAME_CHANGE_TODAY);
        validate = false;
        isValid = jsonElement -> true;
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SideEnum {
        LONG("long"),
        SHORT("short");

        private String value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private SideEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SideEnum fromValue(String value) {
            for (SideEnum b : SideEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            String value = jsonElement.getAsString();
            SideEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<SideEnum> {
            public void write(JsonWriter jsonWriter, SideEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SideEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SideEnum.fromValue(value);
            }
        }
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Position.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Position.class));
            return new TypeAdapter<Position>(){

                public void write(JsonWriter out, Position value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Position read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Position.validateJsonElement(jsonElement);
                    return (Position)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

