/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.function.Predicate;

@JsonAdapter(value=Adapter.class)
public enum TaxIdType {
    USA_SSN("USA_SSN"),
    ARG_AG_CUIT("ARG_AG_CUIT"),
    AUS_TFN("AUS_TFN"),
    AUS_ABN("AUS_ABN"),
    BOL_NIT("BOL_NIT"),
    BRA_CPF("BRA_CPF"),
    CHL_RUT("CHL_RUT"),
    COL_NIT("COL_NIT"),
    CRI_NITE("CRI_NITE"),
    DEU_TAX_ID("DEU_TAX_ID"),
    DOM_RNC("DOM_RNC"),
    ECU_RUC("ECU_RUC"),
    FRA_SPI("FRA_SPI"),
    GBR_UTR("GBR_UTR"),
    GBR_NINO("GBR_NINO"),
    GTM_NIT("GTM_NIT"),
    HND_RTN("HND_RTN"),
    HUN_TIN("HUN_TIN"),
    IDN_KTP("IDN_KTP"),
    IND_PAN("IND_PAN"),
    ISR_TAX_ID("ISR_TAX_ID"),
    ITA_TAX_ID("ITA_TAX_ID"),
    JPN_TAX_ID("JPN_TAX_ID"),
    MEX_RFC("MEX_RFC"),
    NIC_RUC("NIC_RUC"),
    NLD_TIN("NLD_TIN"),
    PAN_RUC("PAN_RUC"),
    PER_RUC("PER_RUC"),
    PRY_RUC("PRY_RUC"),
    SGP_NRIC("SGP_NRIC"),
    SGP_FIN("SGP_FIN"),
    SGP_ASGD("SGP_ASGD"),
    SGP_ITR("SGP_ITR"),
    SLV_NIT("SLV_NIT"),
    SWE_TAX_ID("SWE_TAX_ID"),
    URY_RUT("URY_RUT"),
    VEN_RIF("VEN_RIF"),
    NATIONAL_ID("NATIONAL_ID"),
    PASSPORT("PASSPORT"),
    PERMANENT_RESIDENT("PERMANENT_RESIDENT"),
    DRIVER_LICENSE("DRIVER_LICENSE"),
    OTHER_GOV_ID("OTHER_GOV_ID"),
    NOT_SPECIFIED("NOT_SPECIFIED");

    private String value;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    private TaxIdType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TaxIdType fromValue(String value) {
        for (TaxIdType b : TaxIdType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        return null;
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        String value = jsonElement.getAsString();
        TaxIdType.fromValue(value);
    }

    static {
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class Adapter
    extends TypeAdapter<TaxIdType> {
        public void write(JsonWriter jsonWriter, TaxIdType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public TaxIdType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return TaxIdType.fromValue(value);
        }
    }
}

