/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.broker.JSON;
import net.jacobpeterson.alpaca.openapi.broker.model.AccountStatus;

public class TradeAccount {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private UUID id;
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
    @SerializedName(value="account_number")
    private String accountNumber;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private AccountStatus status;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_BUYING_POWER = "buying_power";
    @SerializedName(value="buying_power")
    private BigDecimal buyingPower;
    public static final String SERIALIZED_NAME_REGT_BUYING_POWER = "regt_buying_power";
    @SerializedName(value="regt_buying_power")
    private BigDecimal regtBuyingPower;
    public static final String SERIALIZED_NAME_DAYTRADING_BUYING_POWER = "daytrading_buying_power";
    @SerializedName(value="daytrading_buying_power")
    private BigDecimal daytradingBuyingPower;
    public static final String SERIALIZED_NAME_OPTIONS_BUYING_POWER = "options_buying_power";
    @SerializedName(value="options_buying_power")
    private BigDecimal optionsBuyingPower;
    public static final String SERIALIZED_NAME_CASH = "cash";
    @SerializedName(value="cash")
    private BigDecimal cash;
    public static final String SERIALIZED_NAME_CASH_WITHDRAWABLE = "cash_withdrawable";
    @SerializedName(value="cash_withdrawable")
    private BigDecimal cashWithdrawable;
    public static final String SERIALIZED_NAME_CASH_TRANSFERABLE = "cash_transferable";
    @SerializedName(value="cash_transferable")
    private String cashTransferable;
    public static final String SERIALIZED_NAME_PENDING_TRANSFER_OUT = "pending_transfer_out";
    @SerializedName(value="pending_transfer_out")
    private String pendingTransferOut;
    public static final String SERIALIZED_NAME_PORTFOLIO_VALUE = "portfolio_value";
    @SerializedName(value="portfolio_value")
    private BigDecimal portfolioValue;
    public static final String SERIALIZED_NAME_PATTERN_DAY_TRADER = "pattern_day_trader";
    @SerializedName(value="pattern_day_trader")
    private Boolean patternDayTrader;
    public static final String SERIALIZED_NAME_TRADING_BLOCKED = "trading_blocked";
    @SerializedName(value="trading_blocked")
    private Boolean tradingBlocked;
    public static final String SERIALIZED_NAME_TRANSFERS_BLOCKED = "transfers_blocked";
    @SerializedName(value="transfers_blocked")
    private Boolean transfersBlocked;
    public static final String SERIALIZED_NAME_ACCOUNT_BLOCKED = "account_blocked";
    @SerializedName(value="account_blocked")
    private Boolean accountBlocked;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private String createdAt;
    public static final String SERIALIZED_NAME_TRADE_SUSPENDED_BY_USER = "trade_suspended_by_user";
    @SerializedName(value="trade_suspended_by_user")
    private Boolean tradeSuspendedByUser;
    public static final String SERIALIZED_NAME_MULTIPLIER = "multiplier";
    @SerializedName(value="multiplier")
    private BigDecimal multiplier;
    public static final String SERIALIZED_NAME_SHORTING_ENABLED = "shorting_enabled";
    @SerializedName(value="shorting_enabled")
    private Boolean shortingEnabled;
    public static final String SERIALIZED_NAME_EQUITY = "equity";
    @SerializedName(value="equity")
    private BigDecimal equity;
    public static final String SERIALIZED_NAME_LAST_EQUITY = "last_equity";
    @SerializedName(value="last_equity")
    private BigDecimal lastEquity;
    public static final String SERIALIZED_NAME_LONG_MARKET_VALUE = "long_market_value";
    @SerializedName(value="long_market_value")
    private BigDecimal longMarketValue;
    public static final String SERIALIZED_NAME_SHORT_MARKET_VALUE = "short_market_value";
    @SerializedName(value="short_market_value")
    private BigDecimal shortMarketValue;
    public static final String SERIALIZED_NAME_INITIAL_MARGIN = "initial_margin";
    @SerializedName(value="initial_margin")
    private BigDecimal initialMargin;
    public static final String SERIALIZED_NAME_MAINTENANCE_MARGIN = "maintenance_margin";
    @SerializedName(value="maintenance_margin")
    private BigDecimal maintenanceMargin;
    public static final String SERIALIZED_NAME_LAST_MAINTENANCE_MARGIN = "last_maintenance_margin";
    @SerializedName(value="last_maintenance_margin")
    private BigDecimal lastMaintenanceMargin;
    public static final String SERIALIZED_NAME_SMA = "sma";
    @SerializedName(value="sma")
    private BigDecimal sma;
    public static final String SERIALIZED_NAME_DAYTRADE_COUNT = "daytrade_count";
    @SerializedName(value="daytrade_count")
    private Integer daytradeCount;
    public static final String SERIALIZED_NAME_PREVIOUS_CLOSE = "previous_close";
    @SerializedName(value="previous_close")
    private String previousClose;
    public static final String SERIALIZED_NAME_LAST_LONG_MARKET_VALUE = "last_long_market_value";
    @SerializedName(value="last_long_market_value")
    private String lastLongMarketValue;
    public static final String SERIALIZED_NAME_LAST_SHORT_MARKET_VALUE = "last_short_market_value";
    @SerializedName(value="last_short_market_value")
    private String lastShortMarketValue;
    public static final String SERIALIZED_NAME_LAST_CASH = "last_cash";
    @SerializedName(value="last_cash")
    private String lastCash;
    public static final String SERIALIZED_NAME_LAST_INITIAL_MARGIN = "last_initial_margin";
    @SerializedName(value="last_initial_margin")
    private String lastInitialMargin;
    public static final String SERIALIZED_NAME_LAST_REGT_BUYING_POWER = "last_regt_buying_power";
    @SerializedName(value="last_regt_buying_power")
    private String lastRegtBuyingPower;
    public static final String SERIALIZED_NAME_LAST_DAYTRADING_BUYING_POWER = "last_daytrading_buying_power";
    @SerializedName(value="last_daytrading_buying_power")
    private String lastDaytradingBuyingPower;
    public static final String SERIALIZED_NAME_LAST_OPTIONS_BUYING_POWER = "last_options_buying_power";
    @SerializedName(value="last_options_buying_power")
    private String lastOptionsBuyingPower;
    public static final String SERIALIZED_NAME_LAST_BUYING_POWER = "last_buying_power";
    @SerializedName(value="last_buying_power")
    private String lastBuyingPower;
    public static final String SERIALIZED_NAME_LAST_DAYTRADE_COUNT = "last_daytrade_count";
    @SerializedName(value="last_daytrade_count")
    private Integer lastDaytradeCount;
    public static final String SERIALIZED_NAME_CLEARING_BROKER = "clearing_broker";
    @SerializedName(value="clearing_broker")
    private String clearingBroker;
    public static final String SERIALIZED_NAME_OPTIONS_APPROVED_LEVEL = "options_approved_level";
    @SerializedName(value="options_approved_level")
    private OptionsApprovedLevelEnum optionsApprovedLevel;
    public static final String SERIALIZED_NAME_OPTIONS_TRADING_LEVEL = "options_trading_level";
    @SerializedName(value="options_trading_level")
    private OptionsTradingLevelEnum optionsTradingLevel;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public TradeAccount id(UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public TradeAccount accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nullable
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public TradeAccount status(AccountStatus status) {
        this.status = status;
        return this;
    }

    @Nonnull
    public AccountStatus getStatus() {
        return this.status;
    }

    public void setStatus(AccountStatus status) {
        this.status = status;
    }

    public TradeAccount currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nonnull
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public TradeAccount buyingPower(BigDecimal buyingPower) {
        this.buyingPower = buyingPower;
        return this;
    }

    @Nonnull
    public BigDecimal getBuyingPower() {
        return this.buyingPower;
    }

    public void setBuyingPower(BigDecimal buyingPower) {
        this.buyingPower = buyingPower;
    }

    public TradeAccount regtBuyingPower(BigDecimal regtBuyingPower) {
        this.regtBuyingPower = regtBuyingPower;
        return this;
    }

    @Nullable
    public BigDecimal getRegtBuyingPower() {
        return this.regtBuyingPower;
    }

    public void setRegtBuyingPower(BigDecimal regtBuyingPower) {
        this.regtBuyingPower = regtBuyingPower;
    }

    public TradeAccount daytradingBuyingPower(BigDecimal daytradingBuyingPower) {
        this.daytradingBuyingPower = daytradingBuyingPower;
        return this;
    }

    @Nullable
    public BigDecimal getDaytradingBuyingPower() {
        return this.daytradingBuyingPower;
    }

    public void setDaytradingBuyingPower(BigDecimal daytradingBuyingPower) {
        this.daytradingBuyingPower = daytradingBuyingPower;
    }

    public TradeAccount optionsBuyingPower(BigDecimal optionsBuyingPower) {
        this.optionsBuyingPower = optionsBuyingPower;
        return this;
    }

    @Nullable
    public BigDecimal getOptionsBuyingPower() {
        return this.optionsBuyingPower;
    }

    public void setOptionsBuyingPower(BigDecimal optionsBuyingPower) {
        this.optionsBuyingPower = optionsBuyingPower;
    }

    public TradeAccount cash(BigDecimal cash) {
        this.cash = cash;
        return this;
    }

    @Nonnull
    public BigDecimal getCash() {
        return this.cash;
    }

    public void setCash(BigDecimal cash) {
        this.cash = cash;
    }

    public TradeAccount cashWithdrawable(BigDecimal cashWithdrawable) {
        this.cashWithdrawable = cashWithdrawable;
        return this;
    }

    @Nullable
    public BigDecimal getCashWithdrawable() {
        return this.cashWithdrawable;
    }

    public void setCashWithdrawable(BigDecimal cashWithdrawable) {
        this.cashWithdrawable = cashWithdrawable;
    }

    public TradeAccount cashTransferable(String cashTransferable) {
        this.cashTransferable = cashTransferable;
        return this;
    }

    @Nullable
    public String getCashTransferable() {
        return this.cashTransferable;
    }

    public void setCashTransferable(String cashTransferable) {
        this.cashTransferable = cashTransferable;
    }

    public TradeAccount pendingTransferOut(String pendingTransferOut) {
        this.pendingTransferOut = pendingTransferOut;
        return this;
    }

    @Nullable
    public String getPendingTransferOut() {
        return this.pendingTransferOut;
    }

    public void setPendingTransferOut(String pendingTransferOut) {
        this.pendingTransferOut = pendingTransferOut;
    }

    public TradeAccount portfolioValue(BigDecimal portfolioValue) {
        this.portfolioValue = portfolioValue;
        return this;
    }

    @Nullable
    public BigDecimal getPortfolioValue() {
        return this.portfolioValue;
    }

    public void setPortfolioValue(BigDecimal portfolioValue) {
        this.portfolioValue = portfolioValue;
    }

    public TradeAccount patternDayTrader(Boolean patternDayTrader) {
        this.patternDayTrader = patternDayTrader;
        return this;
    }

    @Nullable
    public Boolean getPatternDayTrader() {
        return this.patternDayTrader;
    }

    public void setPatternDayTrader(Boolean patternDayTrader) {
        this.patternDayTrader = patternDayTrader;
    }

    public TradeAccount tradingBlocked(Boolean tradingBlocked) {
        this.tradingBlocked = tradingBlocked;
        return this;
    }

    @Nullable
    public Boolean getTradingBlocked() {
        return this.tradingBlocked;
    }

    public void setTradingBlocked(Boolean tradingBlocked) {
        this.tradingBlocked = tradingBlocked;
    }

    public TradeAccount transfersBlocked(Boolean transfersBlocked) {
        this.transfersBlocked = transfersBlocked;
        return this;
    }

    @Nullable
    public Boolean getTransfersBlocked() {
        return this.transfersBlocked;
    }

    public void setTransfersBlocked(Boolean transfersBlocked) {
        this.transfersBlocked = transfersBlocked;
    }

    public TradeAccount accountBlocked(Boolean accountBlocked) {
        this.accountBlocked = accountBlocked;
        return this;
    }

    @Nullable
    public Boolean getAccountBlocked() {
        return this.accountBlocked;
    }

    public void setAccountBlocked(Boolean accountBlocked) {
        this.accountBlocked = accountBlocked;
    }

    public TradeAccount createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public TradeAccount tradeSuspendedByUser(Boolean tradeSuspendedByUser) {
        this.tradeSuspendedByUser = tradeSuspendedByUser;
        return this;
    }

    @Nullable
    public Boolean getTradeSuspendedByUser() {
        return this.tradeSuspendedByUser;
    }

    public void setTradeSuspendedByUser(Boolean tradeSuspendedByUser) {
        this.tradeSuspendedByUser = tradeSuspendedByUser;
    }

    public TradeAccount multiplier(BigDecimal multiplier) {
        this.multiplier = multiplier;
        return this;
    }

    @Nullable
    public BigDecimal getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(BigDecimal multiplier) {
        this.multiplier = multiplier;
    }

    public TradeAccount shortingEnabled(Boolean shortingEnabled) {
        this.shortingEnabled = shortingEnabled;
        return this;
    }

    @Nullable
    public Boolean getShortingEnabled() {
        return this.shortingEnabled;
    }

    public void setShortingEnabled(Boolean shortingEnabled) {
        this.shortingEnabled = shortingEnabled;
    }

    public TradeAccount equity(BigDecimal equity) {
        this.equity = equity;
        return this;
    }

    @Nonnull
    public BigDecimal getEquity() {
        return this.equity;
    }

    public void setEquity(BigDecimal equity) {
        this.equity = equity;
    }

    public TradeAccount lastEquity(BigDecimal lastEquity) {
        this.lastEquity = lastEquity;
        return this;
    }

    @Nonnull
    public BigDecimal getLastEquity() {
        return this.lastEquity;
    }

    public void setLastEquity(BigDecimal lastEquity) {
        this.lastEquity = lastEquity;
    }

    public TradeAccount longMarketValue(BigDecimal longMarketValue) {
        this.longMarketValue = longMarketValue;
        return this;
    }

    @Nullable
    public BigDecimal getLongMarketValue() {
        return this.longMarketValue;
    }

    public void setLongMarketValue(BigDecimal longMarketValue) {
        this.longMarketValue = longMarketValue;
    }

    public TradeAccount shortMarketValue(BigDecimal shortMarketValue) {
        this.shortMarketValue = shortMarketValue;
        return this;
    }

    @Nullable
    public BigDecimal getShortMarketValue() {
        return this.shortMarketValue;
    }

    public void setShortMarketValue(BigDecimal shortMarketValue) {
        this.shortMarketValue = shortMarketValue;
    }

    public TradeAccount initialMargin(BigDecimal initialMargin) {
        this.initialMargin = initialMargin;
        return this;
    }

    @Nullable
    public BigDecimal getInitialMargin() {
        return this.initialMargin;
    }

    public void setInitialMargin(BigDecimal initialMargin) {
        this.initialMargin = initialMargin;
    }

    public TradeAccount maintenanceMargin(BigDecimal maintenanceMargin) {
        this.maintenanceMargin = maintenanceMargin;
        return this;
    }

    @Nullable
    public BigDecimal getMaintenanceMargin() {
        return this.maintenanceMargin;
    }

    public void setMaintenanceMargin(BigDecimal maintenanceMargin) {
        this.maintenanceMargin = maintenanceMargin;
    }

    public TradeAccount lastMaintenanceMargin(BigDecimal lastMaintenanceMargin) {
        this.lastMaintenanceMargin = lastMaintenanceMargin;
        return this;
    }

    @Nullable
    public BigDecimal getLastMaintenanceMargin() {
        return this.lastMaintenanceMargin;
    }

    public void setLastMaintenanceMargin(BigDecimal lastMaintenanceMargin) {
        this.lastMaintenanceMargin = lastMaintenanceMargin;
    }

    public TradeAccount sma(BigDecimal sma) {
        this.sma = sma;
        return this;
    }

    @Nullable
    public BigDecimal getSma() {
        return this.sma;
    }

    public void setSma(BigDecimal sma) {
        this.sma = sma;
    }

    public TradeAccount daytradeCount(Integer daytradeCount) {
        this.daytradeCount = daytradeCount;
        return this;
    }

    @Nullable
    public Integer getDaytradeCount() {
        return this.daytradeCount;
    }

    public void setDaytradeCount(Integer daytradeCount) {
        this.daytradeCount = daytradeCount;
    }

    public TradeAccount previousClose(String previousClose) {
        this.previousClose = previousClose;
        return this;
    }

    @Nullable
    public String getPreviousClose() {
        return this.previousClose;
    }

    public void setPreviousClose(String previousClose) {
        this.previousClose = previousClose;
    }

    public TradeAccount lastLongMarketValue(String lastLongMarketValue) {
        this.lastLongMarketValue = lastLongMarketValue;
        return this;
    }

    @Nullable
    public String getLastLongMarketValue() {
        return this.lastLongMarketValue;
    }

    public void setLastLongMarketValue(String lastLongMarketValue) {
        this.lastLongMarketValue = lastLongMarketValue;
    }

    public TradeAccount lastShortMarketValue(String lastShortMarketValue) {
        this.lastShortMarketValue = lastShortMarketValue;
        return this;
    }

    @Nullable
    public String getLastShortMarketValue() {
        return this.lastShortMarketValue;
    }

    public void setLastShortMarketValue(String lastShortMarketValue) {
        this.lastShortMarketValue = lastShortMarketValue;
    }

    public TradeAccount lastCash(String lastCash) {
        this.lastCash = lastCash;
        return this;
    }

    @Nullable
    public String getLastCash() {
        return this.lastCash;
    }

    public void setLastCash(String lastCash) {
        this.lastCash = lastCash;
    }

    public TradeAccount lastInitialMargin(String lastInitialMargin) {
        this.lastInitialMargin = lastInitialMargin;
        return this;
    }

    @Nullable
    public String getLastInitialMargin() {
        return this.lastInitialMargin;
    }

    public void setLastInitialMargin(String lastInitialMargin) {
        this.lastInitialMargin = lastInitialMargin;
    }

    public TradeAccount lastRegtBuyingPower(String lastRegtBuyingPower) {
        this.lastRegtBuyingPower = lastRegtBuyingPower;
        return this;
    }

    @Nullable
    public String getLastRegtBuyingPower() {
        return this.lastRegtBuyingPower;
    }

    public void setLastRegtBuyingPower(String lastRegtBuyingPower) {
        this.lastRegtBuyingPower = lastRegtBuyingPower;
    }

    public TradeAccount lastDaytradingBuyingPower(String lastDaytradingBuyingPower) {
        this.lastDaytradingBuyingPower = lastDaytradingBuyingPower;
        return this;
    }

    @Nullable
    public String getLastDaytradingBuyingPower() {
        return this.lastDaytradingBuyingPower;
    }

    public void setLastDaytradingBuyingPower(String lastDaytradingBuyingPower) {
        this.lastDaytradingBuyingPower = lastDaytradingBuyingPower;
    }

    public TradeAccount lastOptionsBuyingPower(String lastOptionsBuyingPower) {
        this.lastOptionsBuyingPower = lastOptionsBuyingPower;
        return this;
    }

    @Nullable
    public String getLastOptionsBuyingPower() {
        return this.lastOptionsBuyingPower;
    }

    public void setLastOptionsBuyingPower(String lastOptionsBuyingPower) {
        this.lastOptionsBuyingPower = lastOptionsBuyingPower;
    }

    public TradeAccount lastBuyingPower(String lastBuyingPower) {
        this.lastBuyingPower = lastBuyingPower;
        return this;
    }

    @Nullable
    public String getLastBuyingPower() {
        return this.lastBuyingPower;
    }

    public void setLastBuyingPower(String lastBuyingPower) {
        this.lastBuyingPower = lastBuyingPower;
    }

    public TradeAccount lastDaytradeCount(Integer lastDaytradeCount) {
        this.lastDaytradeCount = lastDaytradeCount;
        return this;
    }

    @Nullable
    public Integer getLastDaytradeCount() {
        return this.lastDaytradeCount;
    }

    public void setLastDaytradeCount(Integer lastDaytradeCount) {
        this.lastDaytradeCount = lastDaytradeCount;
    }

    public TradeAccount clearingBroker(String clearingBroker) {
        this.clearingBroker = clearingBroker;
        return this;
    }

    @Nullable
    public String getClearingBroker() {
        return this.clearingBroker;
    }

    public void setClearingBroker(String clearingBroker) {
        this.clearingBroker = clearingBroker;
    }

    public TradeAccount optionsApprovedLevel(OptionsApprovedLevelEnum optionsApprovedLevel) {
        this.optionsApprovedLevel = optionsApprovedLevel;
        return this;
    }

    @Nullable
    public OptionsApprovedLevelEnum getOptionsApprovedLevel() {
        return this.optionsApprovedLevel;
    }

    public void setOptionsApprovedLevel(OptionsApprovedLevelEnum optionsApprovedLevel) {
        this.optionsApprovedLevel = optionsApprovedLevel;
    }

    public TradeAccount optionsTradingLevel(OptionsTradingLevelEnum optionsTradingLevel) {
        this.optionsTradingLevel = optionsTradingLevel;
        return this;
    }

    @Nullable
    public OptionsTradingLevelEnum getOptionsTradingLevel() {
        return this.optionsTradingLevel;
    }

    public void setOptionsTradingLevel(OptionsTradingLevelEnum optionsTradingLevel) {
        this.optionsTradingLevel = optionsTradingLevel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TradeAccount tradeAccount = (TradeAccount)o;
        return Objects.equals(this.id, tradeAccount.id) && Objects.equals(this.accountNumber, tradeAccount.accountNumber) && Objects.equals((Object)this.status, (Object)tradeAccount.status) && Objects.equals(this.currency, tradeAccount.currency) && Objects.equals(this.buyingPower, tradeAccount.buyingPower) && Objects.equals(this.regtBuyingPower, tradeAccount.regtBuyingPower) && Objects.equals(this.daytradingBuyingPower, tradeAccount.daytradingBuyingPower) && Objects.equals(this.optionsBuyingPower, tradeAccount.optionsBuyingPower) && Objects.equals(this.cash, tradeAccount.cash) && Objects.equals(this.cashWithdrawable, tradeAccount.cashWithdrawable) && Objects.equals(this.cashTransferable, tradeAccount.cashTransferable) && Objects.equals(this.pendingTransferOut, tradeAccount.pendingTransferOut) && Objects.equals(this.portfolioValue, tradeAccount.portfolioValue) && Objects.equals(this.patternDayTrader, tradeAccount.patternDayTrader) && Objects.equals(this.tradingBlocked, tradeAccount.tradingBlocked) && Objects.equals(this.transfersBlocked, tradeAccount.transfersBlocked) && Objects.equals(this.accountBlocked, tradeAccount.accountBlocked) && Objects.equals(this.createdAt, tradeAccount.createdAt) && Objects.equals(this.tradeSuspendedByUser, tradeAccount.tradeSuspendedByUser) && Objects.equals(this.multiplier, tradeAccount.multiplier) && Objects.equals(this.shortingEnabled, tradeAccount.shortingEnabled) && Objects.equals(this.equity, tradeAccount.equity) && Objects.equals(this.lastEquity, tradeAccount.lastEquity) && Objects.equals(this.longMarketValue, tradeAccount.longMarketValue) && Objects.equals(this.shortMarketValue, tradeAccount.shortMarketValue) && Objects.equals(this.initialMargin, tradeAccount.initialMargin) && Objects.equals(this.maintenanceMargin, tradeAccount.maintenanceMargin) && Objects.equals(this.lastMaintenanceMargin, tradeAccount.lastMaintenanceMargin) && Objects.equals(this.sma, tradeAccount.sma) && Objects.equals(this.daytradeCount, tradeAccount.daytradeCount) && Objects.equals(this.previousClose, tradeAccount.previousClose) && Objects.equals(this.lastLongMarketValue, tradeAccount.lastLongMarketValue) && Objects.equals(this.lastShortMarketValue, tradeAccount.lastShortMarketValue) && Objects.equals(this.lastCash, tradeAccount.lastCash) && Objects.equals(this.lastInitialMargin, tradeAccount.lastInitialMargin) && Objects.equals(this.lastRegtBuyingPower, tradeAccount.lastRegtBuyingPower) && Objects.equals(this.lastDaytradingBuyingPower, tradeAccount.lastDaytradingBuyingPower) && Objects.equals(this.lastOptionsBuyingPower, tradeAccount.lastOptionsBuyingPower) && Objects.equals(this.lastBuyingPower, tradeAccount.lastBuyingPower) && Objects.equals(this.lastDaytradeCount, tradeAccount.lastDaytradeCount) && Objects.equals(this.clearingBroker, tradeAccount.clearingBroker) && Objects.equals((Object)this.optionsApprovedLevel, (Object)tradeAccount.optionsApprovedLevel) && Objects.equals((Object)this.optionsTradingLevel, (Object)tradeAccount.optionsTradingLevel);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.accountNumber, this.status, this.currency, this.buyingPower, this.regtBuyingPower, this.daytradingBuyingPower, this.optionsBuyingPower, this.cash, this.cashWithdrawable, this.cashTransferable, this.pendingTransferOut, this.portfolioValue, this.patternDayTrader, this.tradingBlocked, this.transfersBlocked, this.accountBlocked, this.createdAt, this.tradeSuspendedByUser, this.multiplier, this.shortingEnabled, this.equity, this.lastEquity, this.longMarketValue, this.shortMarketValue, this.initialMargin, this.maintenanceMargin, this.lastMaintenanceMargin, this.sma, this.daytradeCount, this.previousClose, this.lastLongMarketValue, this.lastShortMarketValue, this.lastCash, this.lastInitialMargin, this.lastRegtBuyingPower, this.lastDaytradingBuyingPower, this.lastOptionsBuyingPower, this.lastBuyingPower, this.lastDaytradeCount, this.clearingBroker, this.optionsApprovedLevel, this.optionsTradingLevel});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TradeAccount {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    buyingPower: ").append(this.toIndentedString(this.buyingPower)).append("\n");
        sb.append("    regtBuyingPower: ").append(this.toIndentedString(this.regtBuyingPower)).append("\n");
        sb.append("    daytradingBuyingPower: ").append(this.toIndentedString(this.daytradingBuyingPower)).append("\n");
        sb.append("    optionsBuyingPower: ").append(this.toIndentedString(this.optionsBuyingPower)).append("\n");
        sb.append("    cash: ").append(this.toIndentedString(this.cash)).append("\n");
        sb.append("    cashWithdrawable: ").append(this.toIndentedString(this.cashWithdrawable)).append("\n");
        sb.append("    cashTransferable: ").append(this.toIndentedString(this.cashTransferable)).append("\n");
        sb.append("    pendingTransferOut: ").append(this.toIndentedString(this.pendingTransferOut)).append("\n");
        sb.append("    portfolioValue: ").append(this.toIndentedString(this.portfolioValue)).append("\n");
        sb.append("    patternDayTrader: ").append(this.toIndentedString(this.patternDayTrader)).append("\n");
        sb.append("    tradingBlocked: ").append(this.toIndentedString(this.tradingBlocked)).append("\n");
        sb.append("    transfersBlocked: ").append(this.toIndentedString(this.transfersBlocked)).append("\n");
        sb.append("    accountBlocked: ").append(this.toIndentedString(this.accountBlocked)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    tradeSuspendedByUser: ").append(this.toIndentedString(this.tradeSuspendedByUser)).append("\n");
        sb.append("    multiplier: ").append(this.toIndentedString(this.multiplier)).append("\n");
        sb.append("    shortingEnabled: ").append(this.toIndentedString(this.shortingEnabled)).append("\n");
        sb.append("    equity: ").append(this.toIndentedString(this.equity)).append("\n");
        sb.append("    lastEquity: ").append(this.toIndentedString(this.lastEquity)).append("\n");
        sb.append("    longMarketValue: ").append(this.toIndentedString(this.longMarketValue)).append("\n");
        sb.append("    shortMarketValue: ").append(this.toIndentedString(this.shortMarketValue)).append("\n");
        sb.append("    initialMargin: ").append(this.toIndentedString(this.initialMargin)).append("\n");
        sb.append("    maintenanceMargin: ").append(this.toIndentedString(this.maintenanceMargin)).append("\n");
        sb.append("    lastMaintenanceMargin: ").append(this.toIndentedString(this.lastMaintenanceMargin)).append("\n");
        sb.append("    sma: ").append(this.toIndentedString(this.sma)).append("\n");
        sb.append("    daytradeCount: ").append(this.toIndentedString(this.daytradeCount)).append("\n");
        sb.append("    previousClose: ").append(this.toIndentedString(this.previousClose)).append("\n");
        sb.append("    lastLongMarketValue: ").append(this.toIndentedString(this.lastLongMarketValue)).append("\n");
        sb.append("    lastShortMarketValue: ").append(this.toIndentedString(this.lastShortMarketValue)).append("\n");
        sb.append("    lastCash: ").append(this.toIndentedString(this.lastCash)).append("\n");
        sb.append("    lastInitialMargin: ").append(this.toIndentedString(this.lastInitialMargin)).append("\n");
        sb.append("    lastRegtBuyingPower: ").append(this.toIndentedString(this.lastRegtBuyingPower)).append("\n");
        sb.append("    lastDaytradingBuyingPower: ").append(this.toIndentedString(this.lastDaytradingBuyingPower)).append("\n");
        sb.append("    lastOptionsBuyingPower: ").append(this.toIndentedString(this.lastOptionsBuyingPower)).append("\n");
        sb.append("    lastBuyingPower: ").append(this.toIndentedString(this.lastBuyingPower)).append("\n");
        sb.append("    lastDaytradeCount: ").append(this.toIndentedString(this.lastDaytradeCount)).append("\n");
        sb.append("    clearingBroker: ").append(this.toIndentedString(this.clearingBroker)).append("\n");
        sb.append("    optionsApprovedLevel: ").append(this.toIndentedString((Object)this.optionsApprovedLevel)).append("\n");
        sb.append("    optionsTradingLevel: ").append(this.toIndentedString((Object)this.optionsTradingLevel)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in TradeAccount is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TradeAccount` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `account_number` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER).toString()));
        }
        AccountStatus.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATUS));
        if (!jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENCY).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_BUYING_POWER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `buying_power` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BUYING_POWER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REGT_BUYING_POWER) != null && !jsonObj.get(SERIALIZED_NAME_REGT_BUYING_POWER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REGT_BUYING_POWER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `regt_buying_power` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REGT_BUYING_POWER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DAYTRADING_BUYING_POWER) != null && !jsonObj.get(SERIALIZED_NAME_DAYTRADING_BUYING_POWER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DAYTRADING_BUYING_POWER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `daytrading_buying_power` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DAYTRADING_BUYING_POWER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OPTIONS_BUYING_POWER) != null && !jsonObj.get(SERIALIZED_NAME_OPTIONS_BUYING_POWER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_OPTIONS_BUYING_POWER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `options_buying_power` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OPTIONS_BUYING_POWER).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_CASH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cash` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CASH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CASH_WITHDRAWABLE) != null && !jsonObj.get(SERIALIZED_NAME_CASH_WITHDRAWABLE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CASH_WITHDRAWABLE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cash_withdrawable` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CASH_WITHDRAWABLE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CASH_TRANSFERABLE) != null && !jsonObj.get(SERIALIZED_NAME_CASH_TRANSFERABLE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CASH_TRANSFERABLE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cash_transferable` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CASH_TRANSFERABLE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PENDING_TRANSFER_OUT) != null && !jsonObj.get(SERIALIZED_NAME_PENDING_TRANSFER_OUT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PENDING_TRANSFER_OUT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `pending_transfer_out` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PENDING_TRANSFER_OUT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PORTFOLIO_VALUE) != null && !jsonObj.get(SERIALIZED_NAME_PORTFOLIO_VALUE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PORTFOLIO_VALUE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `portfolio_value` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PORTFOLIO_VALUE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_CREATED_AT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `created_at` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CREATED_AT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MULTIPLIER) != null && !jsonObj.get(SERIALIZED_NAME_MULTIPLIER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MULTIPLIER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `multiplier` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MULTIPLIER).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_EQUITY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `equity` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EQUITY).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_LAST_EQUITY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `last_equity` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LAST_EQUITY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LONG_MARKET_VALUE) != null && !jsonObj.get(SERIALIZED_NAME_LONG_MARKET_VALUE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LONG_MARKET_VALUE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `long_market_value` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LONG_MARKET_VALUE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHORT_MARKET_VALUE) != null && !jsonObj.get(SERIALIZED_NAME_SHORT_MARKET_VALUE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SHORT_MARKET_VALUE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `short_market_value` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHORT_MARKET_VALUE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INITIAL_MARGIN) != null && !jsonObj.get(SERIALIZED_NAME_INITIAL_MARGIN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INITIAL_MARGIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `initial_margin` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INITIAL_MARGIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MAINTENANCE_MARGIN) != null && !jsonObj.get(SERIALIZED_NAME_MAINTENANCE_MARGIN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MAINTENANCE_MARGIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `maintenance_margin` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MAINTENANCE_MARGIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LAST_MAINTENANCE_MARGIN) != null && !jsonObj.get(SERIALIZED_NAME_LAST_MAINTENANCE_MARGIN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LAST_MAINTENANCE_MARGIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `last_maintenance_margin` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LAST_MAINTENANCE_MARGIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SMA) != null && !jsonObj.get(SERIALIZED_NAME_SMA).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SMA).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sma` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SMA).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PREVIOUS_CLOSE) != null && !jsonObj.get(SERIALIZED_NAME_PREVIOUS_CLOSE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PREVIOUS_CLOSE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `previous_close` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PREVIOUS_CLOSE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LAST_LONG_MARKET_VALUE) != null && !jsonObj.get(SERIALIZED_NAME_LAST_LONG_MARKET_VALUE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LAST_LONG_MARKET_VALUE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `last_long_market_value` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LAST_LONG_MARKET_VALUE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LAST_SHORT_MARKET_VALUE) != null && !jsonObj.get(SERIALIZED_NAME_LAST_SHORT_MARKET_VALUE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LAST_SHORT_MARKET_VALUE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `last_short_market_value` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LAST_SHORT_MARKET_VALUE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LAST_CASH) != null && !jsonObj.get(SERIALIZED_NAME_LAST_CASH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LAST_CASH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `last_cash` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LAST_CASH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LAST_INITIAL_MARGIN) != null && !jsonObj.get(SERIALIZED_NAME_LAST_INITIAL_MARGIN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LAST_INITIAL_MARGIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `last_initial_margin` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LAST_INITIAL_MARGIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LAST_REGT_BUYING_POWER) != null && !jsonObj.get(SERIALIZED_NAME_LAST_REGT_BUYING_POWER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LAST_REGT_BUYING_POWER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `last_regt_buying_power` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LAST_REGT_BUYING_POWER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LAST_DAYTRADING_BUYING_POWER) != null && !jsonObj.get(SERIALIZED_NAME_LAST_DAYTRADING_BUYING_POWER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LAST_DAYTRADING_BUYING_POWER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `last_daytrading_buying_power` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LAST_DAYTRADING_BUYING_POWER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LAST_OPTIONS_BUYING_POWER) != null && !jsonObj.get(SERIALIZED_NAME_LAST_OPTIONS_BUYING_POWER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LAST_OPTIONS_BUYING_POWER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `last_options_buying_power` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LAST_OPTIONS_BUYING_POWER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LAST_BUYING_POWER) != null && !jsonObj.get(SERIALIZED_NAME_LAST_BUYING_POWER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LAST_BUYING_POWER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `last_buying_power` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LAST_BUYING_POWER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CLEARING_BROKER) != null && !jsonObj.get(SERIALIZED_NAME_CLEARING_BROKER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CLEARING_BROKER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `clearing_broker` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CLEARING_BROKER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OPTIONS_APPROVED_LEVEL) != null && !jsonObj.get(SERIALIZED_NAME_OPTIONS_APPROVED_LEVEL).isJsonNull()) {
            OptionsApprovedLevelEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_OPTIONS_APPROVED_LEVEL));
        }
        if (jsonObj.get(SERIALIZED_NAME_OPTIONS_TRADING_LEVEL) != null && !jsonObj.get(SERIALIZED_NAME_OPTIONS_TRADING_LEVEL).isJsonNull()) {
            OptionsTradingLevelEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_OPTIONS_TRADING_LEVEL));
        }
    }

    public static TradeAccount fromJson(String jsonString) throws IOException {
        return (TradeAccount)JSON.getGson().fromJson(jsonString, TradeAccount.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_NUMBER);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_CURRENCY);
        openapiFields.add(SERIALIZED_NAME_BUYING_POWER);
        openapiFields.add(SERIALIZED_NAME_REGT_BUYING_POWER);
        openapiFields.add(SERIALIZED_NAME_DAYTRADING_BUYING_POWER);
        openapiFields.add(SERIALIZED_NAME_OPTIONS_BUYING_POWER);
        openapiFields.add(SERIALIZED_NAME_CASH);
        openapiFields.add(SERIALIZED_NAME_CASH_WITHDRAWABLE);
        openapiFields.add(SERIALIZED_NAME_CASH_TRANSFERABLE);
        openapiFields.add(SERIALIZED_NAME_PENDING_TRANSFER_OUT);
        openapiFields.add(SERIALIZED_NAME_PORTFOLIO_VALUE);
        openapiFields.add(SERIALIZED_NAME_PATTERN_DAY_TRADER);
        openapiFields.add(SERIALIZED_NAME_TRADING_BLOCKED);
        openapiFields.add(SERIALIZED_NAME_TRANSFERS_BLOCKED);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_BLOCKED);
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiFields.add(SERIALIZED_NAME_TRADE_SUSPENDED_BY_USER);
        openapiFields.add(SERIALIZED_NAME_MULTIPLIER);
        openapiFields.add(SERIALIZED_NAME_SHORTING_ENABLED);
        openapiFields.add(SERIALIZED_NAME_EQUITY);
        openapiFields.add(SERIALIZED_NAME_LAST_EQUITY);
        openapiFields.add(SERIALIZED_NAME_LONG_MARKET_VALUE);
        openapiFields.add(SERIALIZED_NAME_SHORT_MARKET_VALUE);
        openapiFields.add(SERIALIZED_NAME_INITIAL_MARGIN);
        openapiFields.add(SERIALIZED_NAME_MAINTENANCE_MARGIN);
        openapiFields.add(SERIALIZED_NAME_LAST_MAINTENANCE_MARGIN);
        openapiFields.add(SERIALIZED_NAME_SMA);
        openapiFields.add(SERIALIZED_NAME_DAYTRADE_COUNT);
        openapiFields.add(SERIALIZED_NAME_PREVIOUS_CLOSE);
        openapiFields.add(SERIALIZED_NAME_LAST_LONG_MARKET_VALUE);
        openapiFields.add(SERIALIZED_NAME_LAST_SHORT_MARKET_VALUE);
        openapiFields.add(SERIALIZED_NAME_LAST_CASH);
        openapiFields.add(SERIALIZED_NAME_LAST_INITIAL_MARGIN);
        openapiFields.add(SERIALIZED_NAME_LAST_REGT_BUYING_POWER);
        openapiFields.add(SERIALIZED_NAME_LAST_DAYTRADING_BUYING_POWER);
        openapiFields.add(SERIALIZED_NAME_LAST_OPTIONS_BUYING_POWER);
        openapiFields.add(SERIALIZED_NAME_LAST_BUYING_POWER);
        openapiFields.add(SERIALIZED_NAME_LAST_DAYTRADE_COUNT);
        openapiFields.add(SERIALIZED_NAME_CLEARING_BROKER);
        openapiFields.add(SERIALIZED_NAME_OPTIONS_APPROVED_LEVEL);
        openapiFields.add(SERIALIZED_NAME_OPTIONS_TRADING_LEVEL);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_ACCOUNT_NUMBER);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields.add(SERIALIZED_NAME_CURRENCY);
        openapiRequiredFields.add(SERIALIZED_NAME_BUYING_POWER);
        openapiRequiredFields.add(SERIALIZED_NAME_CASH);
        openapiRequiredFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiRequiredFields.add(SERIALIZED_NAME_EQUITY);
        openapiRequiredFields.add(SERIALIZED_NAME_LAST_EQUITY);
        validate = false;
        isValid = jsonElement -> true;
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OptionsApprovedLevelEnum {
        NUMBER_0(0),
        NUMBER_1(1),
        NUMBER_2(2);

        private Integer value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private OptionsApprovedLevelEnum(Integer value) {
            this.value = value;
        }

        public Integer getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OptionsApprovedLevelEnum fromValue(Integer value) {
            for (OptionsApprovedLevelEnum b : OptionsApprovedLevelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            Integer value = jsonElement.getAsInt();
            OptionsApprovedLevelEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<OptionsApprovedLevelEnum> {
            public void write(JsonWriter jsonWriter, OptionsApprovedLevelEnum enumeration) throws IOException {
                jsonWriter.value((Number)enumeration.getValue());
            }

            public OptionsApprovedLevelEnum read(JsonReader jsonReader) throws IOException {
                Integer value = jsonReader.nextInt();
                return OptionsApprovedLevelEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OptionsTradingLevelEnum {
        NUMBER_0(0),
        NUMBER_1(1),
        NUMBER_2(2);

        private Integer value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private OptionsTradingLevelEnum(Integer value) {
            this.value = value;
        }

        public Integer getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OptionsTradingLevelEnum fromValue(Integer value) {
            for (OptionsTradingLevelEnum b : OptionsTradingLevelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            Integer value = jsonElement.getAsInt();
            OptionsTradingLevelEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<OptionsTradingLevelEnum> {
            public void write(JsonWriter jsonWriter, OptionsTradingLevelEnum enumeration) throws IOException {
                jsonWriter.value((Number)enumeration.getValue());
            }

            public OptionsTradingLevelEnum read(JsonReader jsonReader) throws IOException {
                Integer value = jsonReader.nextInt();
                return OptionsTradingLevelEnum.fromValue(value);
            }
        }
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TradeAccount.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TradeAccount.class));
            return new TypeAdapter<TradeAccount>(){

                public void write(JsonWriter out, TradeAccount value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TradeAccount read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    TradeAccount.validateJsonElement(jsonElement);
                    return (TradeAccount)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

