/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.function.Predicate;

@JsonAdapter(value=Adapter.class)
public enum TradeUpdateEventType {
    NEW("new"),
    FILL("fill"),
    PARTIAL_FILL("partial_fill"),
    CANCELED("canceled"),
    EXPIRED("expired"),
    DONE_FOR_DAY("done_for_day"),
    REPLACED("replaced"),
    REJECTED("rejected"),
    PENDING_NEW("pending_new"),
    STOPPED("stopped"),
    PENDING_CANCEL("pending_cancel"),
    PENDING_REPLACE("pending_replace"),
    CALCULATED("calculated"),
    SUSPENDED("suspended"),
    ORDER_REPLACE_REJECTED("order_replace_rejected"),
    ORDER_CANCEL_REJECTED("order_cancel_rejected");

    private String value;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    private TradeUpdateEventType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TradeUpdateEventType fromValue(String value) {
        for (TradeUpdateEventType b : TradeUpdateEventType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        return null;
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        String value = jsonElement.getAsString();
        TradeUpdateEventType.fromValue(value);
    }

    static {
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class Adapter
    extends TypeAdapter<TradeUpdateEventType> {
        public void write(JsonWriter jsonWriter, TradeUpdateEventType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public TradeUpdateEventType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return TradeUpdateEventType.fromValue(value);
        }
    }
}

