/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.broker.JSON;
import net.jacobpeterson.alpaca.openapi.broker.model.TransferDirection;
import net.jacobpeterson.alpaca.openapi.broker.model.TransferStatus;
import net.jacobpeterson.alpaca.openapi.broker.model.TransferType;
import org.openapitools.jackson.nullable.JsonNullable;

public class Transfer {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private UUID id;
    public static final String SERIALIZED_NAME_RELATIONSHIP_ID = "relationship_id";
    @SerializedName(value="relationship_id")
    private UUID relationshipId;
    public static final String SERIALIZED_NAME_BANK_ID = "bank_id";
    @SerializedName(value="bank_id")
    private UUID bankId;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private UUID accountId;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TransferType type;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private TransferStatus status;
    public static final String SERIALIZED_NAME_REASON = "reason";
    @SerializedName(value="reason")
    private String reason;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigDecimal amount;
    public static final String SERIALIZED_NAME_DIRECTION = "direction";
    @SerializedName(value="direction")
    private TransferDirection direction;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updated_at";
    @SerializedName(value="updated_at")
    private OffsetDateTime updatedAt;
    public static final String SERIALIZED_NAME_EXPIRES_AT = "expires_at";
    @SerializedName(value="expires_at")
    private OffsetDateTime expiresAt;
    public static final String SERIALIZED_NAME_ADDITIONAL_INFORMATION = "additional_information";
    @SerializedName(value="additional_information")
    private String additionalInformation;
    public static final String SERIALIZED_NAME_HOLD_UNTIL = "hold_until";
    @SerializedName(value="hold_until")
    private OffsetDateTime holdUntil;
    public static final String SERIALIZED_NAME_INSTANT_AMOUNT = "instant_amount";
    @SerializedName(value="instant_amount")
    private String instantAmount;
    public static final String SERIALIZED_NAME_REQUESTED_AMOUNT = "requested_amount";
    @SerializedName(value="requested_amount")
    private BigDecimal requestedAmount;
    public static final String SERIALIZED_NAME_FEE = "fee";
    @SerializedName(value="fee")
    private BigDecimal fee;
    public static final String SERIALIZED_NAME_FEE_PAYMENT_METHOD = "fee_payment_method";
    @SerializedName(value="fee_payment_method")
    private String feePaymentMethod;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public Transfer id(UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public Transfer relationshipId(UUID relationshipId) {
        this.relationshipId = relationshipId;
        return this;
    }

    @Nullable
    public UUID getRelationshipId() {
        return this.relationshipId;
    }

    public void setRelationshipId(UUID relationshipId) {
        this.relationshipId = relationshipId;
    }

    public Transfer bankId(UUID bankId) {
        this.bankId = bankId;
        return this;
    }

    @Nullable
    public UUID getBankId() {
        return this.bankId;
    }

    public void setBankId(UUID bankId) {
        this.bankId = bankId;
    }

    public Transfer accountId(UUID accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nonnull
    public UUID getAccountId() {
        return this.accountId;
    }

    public void setAccountId(UUID accountId) {
        this.accountId = accountId;
    }

    public Transfer type(TransferType type) {
        this.type = type;
        return this;
    }

    @Nonnull
    public TransferType getType() {
        return this.type;
    }

    public void setType(TransferType type) {
        this.type = type;
    }

    public Transfer status(TransferStatus status) {
        this.status = status;
        return this;
    }

    @Nonnull
    public TransferStatus getStatus() {
        return this.status;
    }

    public void setStatus(TransferStatus status) {
        this.status = status;
    }

    public Transfer reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Transfer amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Transfer direction(TransferDirection direction) {
        this.direction = direction;
        return this;
    }

    @Nonnull
    public TransferDirection getDirection() {
        return this.direction;
    }

    public void setDirection(TransferDirection direction) {
        this.direction = direction;
    }

    public Transfer createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Transfer updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Transfer expiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Nullable
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public Transfer additionalInformation(String additionalInformation) {
        this.additionalInformation = additionalInformation;
        return this;
    }

    @Nullable
    public String getAdditionalInformation() {
        return this.additionalInformation;
    }

    public void setAdditionalInformation(String additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    public Transfer holdUntil(OffsetDateTime holdUntil) {
        this.holdUntil = holdUntil;
        return this;
    }

    @Nullable
    public OffsetDateTime getHoldUntil() {
        return this.holdUntil;
    }

    public void setHoldUntil(OffsetDateTime holdUntil) {
        this.holdUntil = holdUntil;
    }

    public Transfer instantAmount(String instantAmount) {
        this.instantAmount = instantAmount;
        return this;
    }

    @Nullable
    public String getInstantAmount() {
        return this.instantAmount;
    }

    public void setInstantAmount(String instantAmount) {
        this.instantAmount = instantAmount;
    }

    public Transfer requestedAmount(BigDecimal requestedAmount) {
        this.requestedAmount = requestedAmount;
        return this;
    }

    @Nullable
    public BigDecimal getRequestedAmount() {
        return this.requestedAmount;
    }

    public void setRequestedAmount(BigDecimal requestedAmount) {
        this.requestedAmount = requestedAmount;
    }

    public Transfer fee(BigDecimal fee) {
        this.fee = fee;
        return this;
    }

    @Nullable
    public BigDecimal getFee() {
        return this.fee;
    }

    public void setFee(BigDecimal fee) {
        this.fee = fee;
    }

    public Transfer feePaymentMethod(String feePaymentMethod) {
        this.feePaymentMethod = feePaymentMethod;
        return this;
    }

    @Nullable
    public String getFeePaymentMethod() {
        return this.feePaymentMethod;
    }

    public void setFeePaymentMethod(String feePaymentMethod) {
        this.feePaymentMethod = feePaymentMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transfer transfer = (Transfer)o;
        return Objects.equals(this.id, transfer.id) && Objects.equals(this.relationshipId, transfer.relationshipId) && Objects.equals(this.bankId, transfer.bankId) && Objects.equals(this.accountId, transfer.accountId) && Objects.equals((Object)this.type, (Object)transfer.type) && Objects.equals((Object)this.status, (Object)transfer.status) && Objects.equals(this.reason, transfer.reason) && Objects.equals(this.amount, transfer.amount) && Objects.equals((Object)this.direction, (Object)transfer.direction) && Objects.equals(this.createdAt, transfer.createdAt) && Objects.equals(this.updatedAt, transfer.updatedAt) && Objects.equals(this.expiresAt, transfer.expiresAt) && Objects.equals(this.additionalInformation, transfer.additionalInformation) && Objects.equals(this.holdUntil, transfer.holdUntil) && Objects.equals(this.instantAmount, transfer.instantAmount) && Objects.equals(this.requestedAmount, transfer.requestedAmount) && Objects.equals(this.fee, transfer.fee) && Objects.equals(this.feePaymentMethod, transfer.feePaymentMethod);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.relationshipId, this.bankId, this.accountId, this.type, this.status, this.reason, this.amount, this.direction, this.createdAt, this.updatedAt, this.expiresAt, this.additionalInformation, this.holdUntil, this.instantAmount, this.requestedAmount, this.fee, this.feePaymentMethod});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Transfer {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    relationshipId: ").append(this.toIndentedString(this.relationshipId)).append("\n");
        sb.append("    bankId: ").append(this.toIndentedString(this.bankId)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    additionalInformation: ").append(this.toIndentedString(this.additionalInformation)).append("\n");
        sb.append("    holdUntil: ").append(this.toIndentedString(this.holdUntil)).append("\n");
        sb.append("    instantAmount: ").append(this.toIndentedString(this.instantAmount)).append("\n");
        sb.append("    requestedAmount: ").append(this.toIndentedString(this.requestedAmount)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    feePaymentMethod: ").append(this.toIndentedString(this.feePaymentMethod)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Transfer is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Transfer` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RELATIONSHIP_ID) != null && !jsonObj.get(SERIALIZED_NAME_RELATIONSHIP_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RELATIONSHIP_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `relationship_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RELATIONSHIP_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BANK_ID) != null && !jsonObj.get(SERIALIZED_NAME_BANK_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_BANK_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `bank_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BANK_ID).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `account_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID).toString()));
        }
        TransferType.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TYPE));
        TransferStatus.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATUS));
        if (jsonObj.get(SERIALIZED_NAME_REASON) != null && !jsonObj.get(SERIALIZED_NAME_REASON).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REASON).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reason` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REASON).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_AMOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AMOUNT).toString()));
        }
        TransferDirection.validateJsonElement(jsonObj.get(SERIALIZED_NAME_DIRECTION));
        if (jsonObj.get(SERIALIZED_NAME_ADDITIONAL_INFORMATION) != null && !jsonObj.get(SERIALIZED_NAME_ADDITIONAL_INFORMATION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ADDITIONAL_INFORMATION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `additional_information` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ADDITIONAL_INFORMATION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INSTANT_AMOUNT) != null && !jsonObj.get(SERIALIZED_NAME_INSTANT_AMOUNT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INSTANT_AMOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `instant_amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INSTANT_AMOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REQUESTED_AMOUNT) != null && !jsonObj.get(SERIALIZED_NAME_REQUESTED_AMOUNT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REQUESTED_AMOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `requested_amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REQUESTED_AMOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FEE) != null && !jsonObj.get(SERIALIZED_NAME_FEE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_FEE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `fee` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FEE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FEE_PAYMENT_METHOD) != null && !jsonObj.get(SERIALIZED_NAME_FEE_PAYMENT_METHOD).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_FEE_PAYMENT_METHOD).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `fee_payment_method` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FEE_PAYMENT_METHOD).toString()));
        }
    }

    public static Transfer fromJson(String jsonString) throws IOException {
        return (Transfer)JSON.getGson().fromJson(jsonString, Transfer.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_RELATIONSHIP_ID);
        openapiFields.add(SERIALIZED_NAME_BANK_ID);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_ID);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_REASON);
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_DIRECTION);
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiFields.add(SERIALIZED_NAME_UPDATED_AT);
        openapiFields.add(SERIALIZED_NAME_EXPIRES_AT);
        openapiFields.add(SERIALIZED_NAME_ADDITIONAL_INFORMATION);
        openapiFields.add(SERIALIZED_NAME_HOLD_UNTIL);
        openapiFields.add(SERIALIZED_NAME_INSTANT_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_REQUESTED_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_FEE);
        openapiFields.add(SERIALIZED_NAME_FEE_PAYMENT_METHOD);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_ACCOUNT_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields.add(SERIALIZED_NAME_AMOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_DIRECTION);
        openapiRequiredFields.add(SERIALIZED_NAME_CREATED_AT);
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Transfer.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Transfer.class));
            return new TypeAdapter<Transfer>(){

                public void write(JsonWriter out, Transfer value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Transfer read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Transfer.validateJsonElement(jsonElement);
                    return (Transfer)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

