/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.broker.JSON;

public class TransferData {
    public static final String SERIALIZED_NAME_TRANSFER_TYPE = "transfer_type";
    @SerializedName(value="transfer_type")
    protected TransferTypeEnum transferType;
    public static final String SERIALIZED_NAME_TIMING = "timing";
    @SerializedName(value="timing")
    private TimingEnum timing;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigDecimal amount;
    public static final String SERIALIZED_NAME_DIRECTION = "direction";
    @SerializedName(value="direction")
    private DirectionEnum direction;
    public static final String SERIALIZED_NAME_RELATIONSHIP_ID = "relationship_id";
    @SerializedName(value="relationship_id")
    private UUID relationshipId;
    public static final String SERIALIZED_NAME_ADDITIONAL_INFORMATION = "additional_information";
    @SerializedName(value="additional_information")
    private String additionalInformation;
    public static final String SERIALIZED_NAME_BANK_ID = "bank_id";
    @SerializedName(value="bank_id")
    private UUID bankId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public TransferData transferType(TransferTypeEnum transferType) {
        this.transferType = transferType;
        return this;
    }

    @Nonnull
    public TransferTypeEnum getTransferType() {
        return this.transferType;
    }

    public void setTransferType(TransferTypeEnum transferType) {
        this.transferType = transferType;
    }

    public TransferData timing(TimingEnum timing) {
        this.timing = timing;
        return this;
    }

    @Nullable
    public TimingEnum getTiming() {
        return this.timing;
    }

    public void setTiming(TimingEnum timing) {
        this.timing = timing;
    }

    public TransferData amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public TransferData direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @Nonnull
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public TransferData relationshipId(UUID relationshipId) {
        this.relationshipId = relationshipId;
        return this;
    }

    @Nonnull
    public UUID getRelationshipId() {
        return this.relationshipId;
    }

    public void setRelationshipId(UUID relationshipId) {
        this.relationshipId = relationshipId;
    }

    public TransferData additionalInformation(String additionalInformation) {
        this.additionalInformation = additionalInformation;
        return this;
    }

    @Nullable
    public String getAdditionalInformation() {
        return this.additionalInformation;
    }

    public void setAdditionalInformation(String additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    public TransferData bankId(UUID bankId) {
        this.bankId = bankId;
        return this;
    }

    @Nonnull
    public UUID getBankId() {
        return this.bankId;
    }

    public void setBankId(UUID bankId) {
        this.bankId = bankId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferData transferData = (TransferData)o;
        return Objects.equals((Object)this.transferType, (Object)transferData.transferType) && Objects.equals((Object)this.timing, (Object)transferData.timing) && Objects.equals(this.amount, transferData.amount) && Objects.equals((Object)this.direction, (Object)transferData.direction) && Objects.equals(this.relationshipId, transferData.relationshipId) && Objects.equals(this.additionalInformation, transferData.additionalInformation) && Objects.equals(this.bankId, transferData.bankId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.transferType, this.timing, this.amount, this.direction, this.relationshipId, this.additionalInformation, this.bankId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferData {\n");
        sb.append("    transferType: ").append(this.toIndentedString((Object)this.transferType)).append("\n");
        sb.append("    timing: ").append(this.toIndentedString((Object)this.timing)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    relationshipId: ").append(this.toIndentedString(this.relationshipId)).append("\n");
        sb.append("    additionalInformation: ").append(this.toIndentedString(this.additionalInformation)).append("\n");
        sb.append("    bankId: ").append(this.toIndentedString(this.bankId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in TransferData is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TransferData` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
    }

    public static TransferData fromJson(String jsonString) throws IOException {
        return (TransferData)JSON.getGson().fromJson(jsonString, TransferData.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_TRANSFER_TYPE);
        openapiFields.add(SERIALIZED_NAME_TIMING);
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_DIRECTION);
        openapiFields.add(SERIALIZED_NAME_RELATIONSHIP_ID);
        openapiFields.add(SERIALIZED_NAME_ADDITIONAL_INFORMATION);
        openapiFields.add(SERIALIZED_NAME_BANK_ID);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TRANSFER_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_AMOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_DIRECTION);
        openapiRequiredFields.add(SERIALIZED_NAME_RELATIONSHIP_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_BANK_ID);
        validate = false;
        isValid = jsonElement -> true;
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TransferTypeEnum {
        ACH("ach"),
        WIRE("wire");

        private String value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private TransferTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TransferTypeEnum fromValue(String value) {
            for (TransferTypeEnum b : TransferTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            String value = jsonElement.getAsString();
            TransferTypeEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<TransferTypeEnum> {
            public void write(JsonWriter jsonWriter, TransferTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TransferTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TransferTypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TimingEnum {
        IMMEDIATE("immediate");

        private String value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private TimingEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TimingEnum fromValue(String value) {
            for (TimingEnum b : TimingEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            String value = jsonElement.getAsString();
            TimingEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<TimingEnum> {
            public void write(JsonWriter jsonWriter, TimingEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TimingEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TimingEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DirectionEnum {
        INCOMING("INCOMING"),
        OUTGOING("OUTGOING");

        private String value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private DirectionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DirectionEnum fromValue(String value) {
            for (DirectionEnum b : DirectionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            String value = jsonElement.getAsString();
            DirectionEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<DirectionEnum> {
            public void write(JsonWriter jsonWriter, DirectionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DirectionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DirectionEnum.fromValue(value);
            }
        }
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TransferData.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TransferData.class));
            return new TypeAdapter<TransferData>(){

                public void write(JsonWriter out, TransferData value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TransferData read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    TransferData.validateJsonElement(jsonElement);
                    return (TransferData)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

