/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.function.Predicate;

@JsonAdapter(value=Adapter.class)
public enum TransferDirection {
    INCOMING("INCOMING"),
    OUTGOING("OUTGOING");

    private String value;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    private TransferDirection(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TransferDirection fromValue(String value) {
        for (TransferDirection b : TransferDirection.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        return null;
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        String value = jsonElement.getAsString();
        TransferDirection.fromValue(value);
    }

    static {
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class Adapter
    extends TypeAdapter<TransferDirection> {
        public void write(JsonWriter jsonWriter, TransferDirection enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public TransferDirection read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return TransferDirection.fromValue(value);
        }
    }
}

