/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.function.Predicate;

@JsonAdapter(value=Adapter.class)
public enum TransferStatus {
    QUEUED("QUEUED"),
    APPROVAL_PENDING("APPROVAL_PENDING"),
    PENDING("PENDING"),
    SENT_TO_CLEARING("SENT_TO_CLEARING"),
    REJECTED("REJECTED"),
    CANCELED("CANCELED"),
    APPROVED("APPROVED"),
    COMPLETE("COMPLETE"),
    RETURNED("RETURNED");

    private String value;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    private TransferStatus(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TransferStatus fromValue(String value) {
        for (TransferStatus b : TransferStatus.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        return null;
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        String value = jsonElement.getAsString();
        TransferStatus.fromValue(value);
    }

    static {
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class Adapter
    extends TypeAdapter<TransferStatus> {
        public void write(JsonWriter jsonWriter, TransferStatus enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public TransferStatus read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return TransferStatus.fromValue(value);
        }
    }
}

