/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.jacobpeterson.alpaca.openapi.broker.JSON;
import net.jacobpeterson.alpaca.openapi.broker.model.TransferStatus;

public class TransferStatusEvent {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private UUID accountId;
    public static final String SERIALIZED_NAME_AT = "at";
    @SerializedName(value="at")
    private OffsetDateTime at;
    public static final String SERIALIZED_NAME_EVENT_ID = "event_id";
    @SerializedName(value="event_id")
    private Integer eventId;
    public static final String SERIALIZED_NAME_EVENT_ULID = "event_ulid";
    @SerializedName(value="event_ulid")
    private String eventUlid;
    public static final String SERIALIZED_NAME_STATUS_FROM = "status_from";
    @SerializedName(value="status_from")
    private TransferStatus statusFrom;
    public static final String SERIALIZED_NAME_STATUS_TO = "status_to";
    @SerializedName(value="status_to")
    private TransferStatus statusTo;
    public static final String SERIALIZED_NAME_TRANSFER_ID = "transfer_id";
    @SerializedName(value="transfer_id")
    private UUID transferId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public TransferStatusEvent accountId(UUID accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nonnull
    public UUID getAccountId() {
        return this.accountId;
    }

    public void setAccountId(UUID accountId) {
        this.accountId = accountId;
    }

    public TransferStatusEvent at(OffsetDateTime at) {
        this.at = at;
        return this;
    }

    @Nonnull
    public OffsetDateTime getAt() {
        return this.at;
    }

    public void setAt(OffsetDateTime at) {
        this.at = at;
    }

    public TransferStatusEvent eventId(Integer eventId) {
        this.eventId = eventId;
        return this;
    }

    @Nonnull
    public Integer getEventId() {
        return this.eventId;
    }

    public void setEventId(Integer eventId) {
        this.eventId = eventId;
    }

    public TransferStatusEvent eventUlid(String eventUlid) {
        this.eventUlid = eventUlid;
        return this;
    }

    @Nonnull
    public String getEventUlid() {
        return this.eventUlid;
    }

    public void setEventUlid(String eventUlid) {
        this.eventUlid = eventUlid;
    }

    public TransferStatusEvent statusFrom(TransferStatus statusFrom) {
        this.statusFrom = statusFrom;
        return this;
    }

    @Nonnull
    public TransferStatus getStatusFrom() {
        return this.statusFrom;
    }

    public void setStatusFrom(TransferStatus statusFrom) {
        this.statusFrom = statusFrom;
    }

    public TransferStatusEvent statusTo(TransferStatus statusTo) {
        this.statusTo = statusTo;
        return this;
    }

    @Nonnull
    public TransferStatus getStatusTo() {
        return this.statusTo;
    }

    public void setStatusTo(TransferStatus statusTo) {
        this.statusTo = statusTo;
    }

    public TransferStatusEvent transferId(UUID transferId) {
        this.transferId = transferId;
        return this;
    }

    @Nonnull
    public UUID getTransferId() {
        return this.transferId;
    }

    public void setTransferId(UUID transferId) {
        this.transferId = transferId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferStatusEvent transferStatusEvent = (TransferStatusEvent)o;
        return Objects.equals(this.accountId, transferStatusEvent.accountId) && Objects.equals(this.at, transferStatusEvent.at) && Objects.equals(this.eventId, transferStatusEvent.eventId) && Objects.equals(this.eventUlid, transferStatusEvent.eventUlid) && Objects.equals((Object)this.statusFrom, (Object)transferStatusEvent.statusFrom) && Objects.equals((Object)this.statusTo, (Object)transferStatusEvent.statusTo) && Objects.equals(this.transferId, transferStatusEvent.transferId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.at, this.eventId, this.eventUlid, this.statusFrom, this.statusTo, this.transferId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferStatusEvent {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    at: ").append(this.toIndentedString(this.at)).append("\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    eventUlid: ").append(this.toIndentedString(this.eventUlid)).append("\n");
        sb.append("    statusFrom: ").append(this.toIndentedString((Object)this.statusFrom)).append("\n");
        sb.append("    statusTo: ").append(this.toIndentedString((Object)this.statusTo)).append("\n");
        sb.append("    transferId: ").append(this.toIndentedString(this.transferId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in TransferStatusEvent is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TransferStatusEvent` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `account_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_EVENT_ULID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `event_ulid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EVENT_ULID).toString()));
        }
        TransferStatus.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATUS_FROM));
        TransferStatus.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATUS_TO));
        if (!jsonObj.get(SERIALIZED_NAME_TRANSFER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `transfer_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANSFER_ID).toString()));
        }
    }

    public static TransferStatusEvent fromJson(String jsonString) throws IOException {
        return (TransferStatusEvent)JSON.getGson().fromJson(jsonString, TransferStatusEvent.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_ID);
        openapiFields.add(SERIALIZED_NAME_AT);
        openapiFields.add(SERIALIZED_NAME_EVENT_ID);
        openapiFields.add(SERIALIZED_NAME_EVENT_ULID);
        openapiFields.add(SERIALIZED_NAME_STATUS_FROM);
        openapiFields.add(SERIALIZED_NAME_STATUS_TO);
        openapiFields.add(SERIALIZED_NAME_TRANSFER_ID);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ACCOUNT_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_AT);
        openapiRequiredFields.add(SERIALIZED_NAME_EVENT_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_EVENT_ULID);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS_FROM);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS_TO);
        openapiRequiredFields.add(SERIALIZED_NAME_TRANSFER_ID);
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TransferStatusEvent.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TransferStatusEvent.class));
            return new TypeAdapter<TransferStatusEvent>(){

                public void write(JsonWriter out, TransferStatusEvent value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TransferStatusEvent read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    TransferStatusEvent.validateJsonElement(jsonElement);
                    return (TransferStatusEvent)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

