/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.function.Predicate;

@JsonAdapter(value=Adapter.class)
public enum TransferType {
    ACH("ach"),
    INSTANT_ACH("instant_ach"),
    WIRE("wire");

    private String value;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    private TransferType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TransferType fromValue(String value) {
        for (TransferType b : TransferType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        return null;
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        String value = jsonElement.getAsString();
        TransferType.fromValue(value);
    }

    static {
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class Adapter
    extends TypeAdapter<TransferType> {
        public void write(JsonWriter jsonWriter, TransferType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public TransferType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return TransferType.fromValue(value);
        }
    }
}

