/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.marketdata;

import com.fasterxml.jackson.databind.util.StdDateFormat;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.gsonfire.GsonFireBuilder;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CACashDividend;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CACashMerger;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CACorporateActions;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CACorporateActionsResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CAForwardSplit;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CANameChange;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CARedemption;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CAReverseSplit;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CASpinOff;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CAStockAndCashMerger;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CAStockDividend;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CAStockMerger;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CAUnitSplit;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CAWorthlessRemoval;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoBar;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoBarsResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoLatestBarsResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoLatestOrderbooksResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoLatestQuotesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoLatestTradesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoOrderbook;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoOrderbookEntry;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoQuote;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoQuotesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoSnapshot;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoSnapshotsResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoTrade;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoTradesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.ForexLatestRatesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.ForexRate;
import net.jacobpeterson.alpaca.openapi.marketdata.model.ForexRatesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.News;
import net.jacobpeterson.alpaca.openapi.marketdata.model.NewsImage;
import net.jacobpeterson.alpaca.openapi.marketdata.model.NewsResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.OptionBar;
import net.jacobpeterson.alpaca.openapi.marketdata.model.OptionBarsResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.OptionLatestQuotesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.OptionLatestTradesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.OptionQuote;
import net.jacobpeterson.alpaca.openapi.marketdata.model.OptionSnapshot;
import net.jacobpeterson.alpaca.openapi.marketdata.model.OptionSnapshotsResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.OptionTrade;
import net.jacobpeterson.alpaca.openapi.marketdata.model.OptionTradesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.ScreenerMostActive;
import net.jacobpeterson.alpaca.openapi.marketdata.model.ScreenerMostActivesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.ScreenerMover;
import net.jacobpeterson.alpaca.openapi.marketdata.model.ScreenerMoversResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockAuction;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockAuctionsResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockAuctionsRespSingle;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockBar;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockBarsResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockBarsRespSingle;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockDailyAuctions;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockLatestBarsResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockLatestBarsRespSingle;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockLatestQuotesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockLatestQuotesRespSingle;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockLatestTradesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockLatestTradesRespSingle;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockQuote;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockQuotesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockQuotesRespSingle;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockSnapshot;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockSnapshotsRespSingle;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockTrade;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockTradesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockTradesRespSingle;
import okio.ByteString;

public class JSON {
    private static Gson gson;
    private static boolean isLenientOnJson;
    private static DateTypeAdapter dateTypeAdapter;
    private static SqlDateTypeAdapter sqlDateTypeAdapter;
    private static OffsetDateTimeTypeAdapter offsetDateTimeTypeAdapter;
    private static LocalDateTypeAdapter localDateTypeAdapter;
    private static ByteArrayAdapter byteArrayAdapter;
    private static final StdDateFormat sdf;
    private static final DateTimeFormatter dtf;

    public static GsonBuilder createGson() {
        GsonFireBuilder fireBuilder = new GsonFireBuilder();
        GsonBuilder builder = fireBuilder.createGsonBuilder();
        return builder;
    }

    private static String getDiscriminatorValue(JsonElement readElement, String discriminatorField) {
        JsonElement element = readElement.getAsJsonObject().get(discriminatorField);
        if (null == element) {
            throw new IllegalArgumentException("missing discriminator field: <" + discriminatorField + ">");
        }
        return element.getAsString();
    }

    private static Class getClassByDiscriminator(Map classByDiscriminatorValue, String discriminatorValue) {
        Class clazz = (Class)classByDiscriminatorValue.get(discriminatorValue);
        if (null == clazz) {
            throw new IllegalArgumentException("cannot determine model class of name: <" + discriminatorValue + ">");
        }
        return clazz;
    }

    public static Gson getGson() {
        return gson;
    }

    public static void setGson(Gson gson) {
        JSON.gson = gson;
    }

    public static void setLenientOnJson(boolean lenientOnJson) {
        isLenientOnJson = lenientOnJson;
    }

    public static String serialize(Object obj) {
        return gson.toJson(obj);
    }

    public static <T> T deserialize(String body, Type returnType) {
        try {
            if (isLenientOnJson) {
                JsonReader jsonReader = new JsonReader((Reader)new StringReader(body));
                jsonReader.setLenient(true);
                return (T)gson.fromJson(jsonReader, returnType);
            }
            return (T)gson.fromJson(body, returnType);
        }
        catch (JsonParseException e) {
            if (returnType.equals(String.class)) {
                return (T)body;
            }
            throw e;
        }
    }

    public static void setOffsetDateTimeFormat(DateTimeFormatter dateFormat) {
        offsetDateTimeTypeAdapter.setFormat(dateFormat);
    }

    public static void setLocalDateFormat(DateTimeFormatter dateFormat) {
        localDateTypeAdapter.setFormat(dateFormat);
    }

    public static void setDateFormat(DateFormat dateFormat) {
        dateTypeAdapter.setFormat(dateFormat);
    }

    public static void setSqlDateFormat(DateFormat dateFormat) {
        sqlDateTypeAdapter.setFormat(dateFormat);
    }

    static {
        isLenientOnJson = false;
        dateTypeAdapter = new DateTypeAdapter();
        sqlDateTypeAdapter = new SqlDateTypeAdapter();
        offsetDateTimeTypeAdapter = new OffsetDateTimeTypeAdapter();
        localDateTypeAdapter = new LocalDateTypeAdapter();
        byteArrayAdapter = new ByteArrayAdapter();
        sdf = new StdDateFormat().withTimeZone(TimeZone.getTimeZone(ZoneId.systemDefault())).withColonInTimeZone(true);
        dtf = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
        GsonBuilder gsonBuilder = JSON.createGson();
        gsonBuilder.registerTypeAdapter(Date.class, (Object)dateTypeAdapter);
        gsonBuilder.registerTypeAdapter(java.sql.Date.class, (Object)sqlDateTypeAdapter);
        gsonBuilder.registerTypeAdapter(OffsetDateTime.class, (Object)offsetDateTimeTypeAdapter);
        gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)localDateTypeAdapter);
        gsonBuilder.registerTypeAdapter(byte[].class, (Object)byteArrayAdapter);
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CACashDividend.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CACashMerger.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CACorporateActions.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CACorporateActionsResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CAForwardSplit.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CANameChange.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CARedemption.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CAReverseSplit.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CASpinOff.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CAStockAndCashMerger.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CAStockDividend.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CAStockMerger.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CAUnitSplit.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CAWorthlessRemoval.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CryptoBar.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CryptoBarsResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CryptoLatestBarsResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CryptoLatestOrderbooksResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CryptoLatestQuotesResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CryptoLatestTradesResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CryptoOrderbook.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CryptoOrderbookEntry.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CryptoQuote.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CryptoQuotesResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CryptoSnapshot.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CryptoSnapshotsResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CryptoTrade.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CryptoTradesResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ForexLatestRatesResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ForexRate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ForexRatesResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new News.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new NewsImage.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new NewsResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new OptionBar.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new OptionBarsResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new OptionLatestQuotesResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new OptionLatestTradesResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new OptionQuote.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new OptionSnapshot.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new OptionSnapshotsResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new OptionTrade.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new OptionTradesResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ScreenerMostActive.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ScreenerMostActivesResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ScreenerMover.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ScreenerMoversResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new StockAuction.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new StockAuctionsResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new StockAuctionsRespSingle.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new StockBar.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new StockBarsResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new StockBarsRespSingle.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new StockDailyAuctions.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new StockLatestBarsResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new StockLatestBarsRespSingle.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new StockLatestQuotesResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new StockLatestQuotesRespSingle.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new StockLatestTradesResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new StockLatestTradesRespSingle.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new StockQuote.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new StockQuotesResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new StockQuotesRespSingle.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new StockSnapshot.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new StockSnapshotsRespSingle.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new StockTrade.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new StockTradesResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new StockTradesRespSingle.CustomTypeAdapterFactory());
        gson = gsonBuilder.create();
    }

    public static class OffsetDateTimeTypeAdapter
    extends TypeAdapter<OffsetDateTime> {
        private DateTimeFormatter formatter;

        public OffsetDateTimeTypeAdapter() {
            this(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }

        public OffsetDateTimeTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        public void write(JsonWriter out, OffsetDateTime date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(this.formatter.format(date));
            }
        }

        public OffsetDateTime read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            Object date = in.nextString();
            if (((String)date).endsWith("+0000")) {
                date = ((String)date).substring(0, ((String)date).length() - 5) + "Z";
            } else if (!((String)date).contains("T")) {
                return LocalDate.parse((CharSequence)date, DateTimeFormatter.ISO_LOCAL_DATE).atTime(LocalTime.MIN.atOffset(ZoneOffset.UTC));
            }
            return OffsetDateTime.parse((CharSequence)date, this.formatter);
        }
    }

    public static class LocalDateTypeAdapter
    extends TypeAdapter<LocalDate> {
        private DateTimeFormatter formatter;

        public LocalDateTypeAdapter() {
            this(DateTimeFormatter.ISO_LOCAL_DATE);
        }

        public LocalDateTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        public void write(JsonWriter out, LocalDate date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(this.formatter.format(date));
            }
        }

        public LocalDate read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String date = in.nextString();
            return LocalDate.parse(date, this.formatter);
        }
    }

    public static class DateTypeAdapter
    extends TypeAdapter<Date> {
        private DateFormat dateFormat;

        public DateTypeAdapter() {
        }

        public DateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void write(JsonWriter out, Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value = this.dateFormat != null ? this.dateFormat.format(date) : date.toInstant().atOffset(ZoneOffset.UTC).format(dtf);
                out.value(value);
            }
        }

        public Date read(JsonReader in) throws IOException {
            try {
                switch (in.peek()) {
                    case NULL: {
                        in.nextNull();
                        return null;
                    }
                }
                String date = in.nextString();
                try {
                    if (this.dateFormat != null) {
                        return this.dateFormat.parse(date);
                    }
                    return sdf.parse(date);
                }
                catch (ParseException e) {
                    throw new JsonParseException((Throwable)e);
                }
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }

    public static class SqlDateTypeAdapter
    extends TypeAdapter<java.sql.Date> {
        private DateFormat dateFormat;

        public SqlDateTypeAdapter() {
        }

        public SqlDateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void write(JsonWriter out, java.sql.Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value = this.dateFormat != null ? this.dateFormat.format(date) : date.toString();
                out.value(value);
            }
        }

        public java.sql.Date read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String date = in.nextString();
            try {
                if (this.dateFormat != null) {
                    return new java.sql.Date(this.dateFormat.parse(date).getTime());
                }
                return new java.sql.Date(sdf.parse(date).getTime());
            }
            catch (ParseException e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }

    public static class ByteArrayAdapter
    extends TypeAdapter<byte[]> {
        public void write(JsonWriter out, byte[] value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value(ByteString.of((byte[])value).base64());
            }
        }

        public byte[] read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String bytesAsBase64 = in.nextString();
            ByteString byteString = ByteString.decodeBase64((String)bytesAsBase64);
            return byteString.toByteArray();
        }
    }
}

