/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.marketdata.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiCallback;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiClient;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiException;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiResponse;
import net.jacobpeterson.alpaca.openapi.marketdata.Configuration;
import net.jacobpeterson.alpaca.openapi.marketdata.Pair;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoBarsResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoLatestBarsResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoLatestOrderbooksResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoLatestQuotesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoLatestTradesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoLoc;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoQuotesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoSnapshotsResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoTradesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.Sort;
import okhttp3.Call;

public class CryptoApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public CryptoApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CryptoApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    protected Call cryptoBarsCall(CryptoLoc loc, String symbols, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1beta3/crypto/{loc}/bars".replace("{loc}", this.localVarApiClient.escapeString(loc.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (symbols != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbols", symbols));
        }
        if (timeframe != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeframe", timeframe));
        }
        if (start != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start", start));
        }
        if (end != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end", end));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (pageToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_token", pageToken));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", (Object)sort));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cryptoBarsValidateBeforeCall(CryptoLoc loc, String symbols, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort, ApiCallback _callback) throws ApiException {
        if (loc == null) {
            throw new ApiException("Missing the required parameter 'loc' when calling cryptoBars(Async)");
        }
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling cryptoBars(Async)");
        }
        if (timeframe == null) {
            throw new ApiException("Missing the required parameter 'timeframe' when calling cryptoBars(Async)");
        }
        return this.cryptoBarsCall(loc, symbols, timeframe, start, end, limit, pageToken, sort, _callback);
    }

    public CryptoBarsResp cryptoBars(CryptoLoc loc, String symbols, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort) throws ApiException {
        ApiResponse<CryptoBarsResp> localVarResp = this.cryptoBarsWithHttpInfo(loc, symbols, timeframe, start, end, limit, pageToken, sort);
        return localVarResp.getData();
    }

    protected ApiResponse<CryptoBarsResp> cryptoBarsWithHttpInfo(CryptoLoc loc, String symbols, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort) throws ApiException {
        Call localVarCall = this.cryptoBarsValidateBeforeCall(loc, symbols, timeframe, start, end, limit, pageToken, sort, null);
        Type localVarReturnType = new TypeToken<CryptoBarsResp>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call cryptoBarsAsync(CryptoLoc loc, String symbols, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort, ApiCallback<CryptoBarsResp> _callback) throws ApiException {
        Call localVarCall = this.cryptoBarsValidateBeforeCall(loc, symbols, timeframe, start, end, limit, pageToken, sort, _callback);
        Type localVarReturnType = new TypeToken<CryptoBarsResp>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call cryptoLatestBarsCall(CryptoLoc loc, String symbols, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1beta3/crypto/{loc}/latest/bars".replace("{loc}", this.localVarApiClient.escapeString(loc.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (symbols != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbols", symbols));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cryptoLatestBarsValidateBeforeCall(CryptoLoc loc, String symbols, ApiCallback _callback) throws ApiException {
        if (loc == null) {
            throw new ApiException("Missing the required parameter 'loc' when calling cryptoLatestBars(Async)");
        }
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling cryptoLatestBars(Async)");
        }
        return this.cryptoLatestBarsCall(loc, symbols, _callback);
    }

    public CryptoLatestBarsResp cryptoLatestBars(CryptoLoc loc, String symbols) throws ApiException {
        ApiResponse<CryptoLatestBarsResp> localVarResp = this.cryptoLatestBarsWithHttpInfo(loc, symbols);
        return localVarResp.getData();
    }

    protected ApiResponse<CryptoLatestBarsResp> cryptoLatestBarsWithHttpInfo(CryptoLoc loc, String symbols) throws ApiException {
        Call localVarCall = this.cryptoLatestBarsValidateBeforeCall(loc, symbols, null);
        Type localVarReturnType = new TypeToken<CryptoLatestBarsResp>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call cryptoLatestBarsAsync(CryptoLoc loc, String symbols, ApiCallback<CryptoLatestBarsResp> _callback) throws ApiException {
        Call localVarCall = this.cryptoLatestBarsValidateBeforeCall(loc, symbols, _callback);
        Type localVarReturnType = new TypeToken<CryptoLatestBarsResp>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call cryptoLatestOrderbooksCall(CryptoLoc loc, String symbols, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1beta3/crypto/{loc}/latest/orderbooks".replace("{loc}", this.localVarApiClient.escapeString(loc.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (symbols != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbols", symbols));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cryptoLatestOrderbooksValidateBeforeCall(CryptoLoc loc, String symbols, ApiCallback _callback) throws ApiException {
        if (loc == null) {
            throw new ApiException("Missing the required parameter 'loc' when calling cryptoLatestOrderbooks(Async)");
        }
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling cryptoLatestOrderbooks(Async)");
        }
        return this.cryptoLatestOrderbooksCall(loc, symbols, _callback);
    }

    public CryptoLatestOrderbooksResp cryptoLatestOrderbooks(CryptoLoc loc, String symbols) throws ApiException {
        ApiResponse<CryptoLatestOrderbooksResp> localVarResp = this.cryptoLatestOrderbooksWithHttpInfo(loc, symbols);
        return localVarResp.getData();
    }

    protected ApiResponse<CryptoLatestOrderbooksResp> cryptoLatestOrderbooksWithHttpInfo(CryptoLoc loc, String symbols) throws ApiException {
        Call localVarCall = this.cryptoLatestOrderbooksValidateBeforeCall(loc, symbols, null);
        Type localVarReturnType = new TypeToken<CryptoLatestOrderbooksResp>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call cryptoLatestOrderbooksAsync(CryptoLoc loc, String symbols, ApiCallback<CryptoLatestOrderbooksResp> _callback) throws ApiException {
        Call localVarCall = this.cryptoLatestOrderbooksValidateBeforeCall(loc, symbols, _callback);
        Type localVarReturnType = new TypeToken<CryptoLatestOrderbooksResp>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call cryptoLatestQuotesCall(CryptoLoc loc, String symbols, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1beta3/crypto/{loc}/latest/quotes".replace("{loc}", this.localVarApiClient.escapeString(loc.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (symbols != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbols", symbols));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cryptoLatestQuotesValidateBeforeCall(CryptoLoc loc, String symbols, ApiCallback _callback) throws ApiException {
        if (loc == null) {
            throw new ApiException("Missing the required parameter 'loc' when calling cryptoLatestQuotes(Async)");
        }
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling cryptoLatestQuotes(Async)");
        }
        return this.cryptoLatestQuotesCall(loc, symbols, _callback);
    }

    public CryptoLatestQuotesResp cryptoLatestQuotes(CryptoLoc loc, String symbols) throws ApiException {
        ApiResponse<CryptoLatestQuotesResp> localVarResp = this.cryptoLatestQuotesWithHttpInfo(loc, symbols);
        return localVarResp.getData();
    }

    protected ApiResponse<CryptoLatestQuotesResp> cryptoLatestQuotesWithHttpInfo(CryptoLoc loc, String symbols) throws ApiException {
        Call localVarCall = this.cryptoLatestQuotesValidateBeforeCall(loc, symbols, null);
        Type localVarReturnType = new TypeToken<CryptoLatestQuotesResp>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call cryptoLatestQuotesAsync(CryptoLoc loc, String symbols, ApiCallback<CryptoLatestQuotesResp> _callback) throws ApiException {
        Call localVarCall = this.cryptoLatestQuotesValidateBeforeCall(loc, symbols, _callback);
        Type localVarReturnType = new TypeToken<CryptoLatestQuotesResp>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call cryptoLatestTradesCall(CryptoLoc loc, String symbols, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1beta3/crypto/{loc}/latest/trades".replace("{loc}", this.localVarApiClient.escapeString(loc.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (symbols != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbols", symbols));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cryptoLatestTradesValidateBeforeCall(CryptoLoc loc, String symbols, ApiCallback _callback) throws ApiException {
        if (loc == null) {
            throw new ApiException("Missing the required parameter 'loc' when calling cryptoLatestTrades(Async)");
        }
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling cryptoLatestTrades(Async)");
        }
        return this.cryptoLatestTradesCall(loc, symbols, _callback);
    }

    public CryptoLatestTradesResp cryptoLatestTrades(CryptoLoc loc, String symbols) throws ApiException {
        ApiResponse<CryptoLatestTradesResp> localVarResp = this.cryptoLatestTradesWithHttpInfo(loc, symbols);
        return localVarResp.getData();
    }

    protected ApiResponse<CryptoLatestTradesResp> cryptoLatestTradesWithHttpInfo(CryptoLoc loc, String symbols) throws ApiException {
        Call localVarCall = this.cryptoLatestTradesValidateBeforeCall(loc, symbols, null);
        Type localVarReturnType = new TypeToken<CryptoLatestTradesResp>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call cryptoLatestTradesAsync(CryptoLoc loc, String symbols, ApiCallback<CryptoLatestTradesResp> _callback) throws ApiException {
        Call localVarCall = this.cryptoLatestTradesValidateBeforeCall(loc, symbols, _callback);
        Type localVarReturnType = new TypeToken<CryptoLatestTradesResp>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call cryptoQuotesCall(CryptoLoc loc, String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1beta3/crypto/{loc}/quotes".replace("{loc}", this.localVarApiClient.escapeString(loc.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (symbols != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbols", symbols));
        }
        if (start != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start", start));
        }
        if (end != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end", end));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (pageToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_token", pageToken));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", (Object)sort));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cryptoQuotesValidateBeforeCall(CryptoLoc loc, String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort, ApiCallback _callback) throws ApiException {
        if (loc == null) {
            throw new ApiException("Missing the required parameter 'loc' when calling cryptoQuotes(Async)");
        }
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling cryptoQuotes(Async)");
        }
        return this.cryptoQuotesCall(loc, symbols, start, end, limit, pageToken, sort, _callback);
    }

    public CryptoQuotesResp cryptoQuotes(CryptoLoc loc, String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort) throws ApiException {
        ApiResponse<CryptoQuotesResp> localVarResp = this.cryptoQuotesWithHttpInfo(loc, symbols, start, end, limit, pageToken, sort);
        return localVarResp.getData();
    }

    protected ApiResponse<CryptoQuotesResp> cryptoQuotesWithHttpInfo(CryptoLoc loc, String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort) throws ApiException {
        Call localVarCall = this.cryptoQuotesValidateBeforeCall(loc, symbols, start, end, limit, pageToken, sort, null);
        Type localVarReturnType = new TypeToken<CryptoQuotesResp>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call cryptoQuotesAsync(CryptoLoc loc, String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort, ApiCallback<CryptoQuotesResp> _callback) throws ApiException {
        Call localVarCall = this.cryptoQuotesValidateBeforeCall(loc, symbols, start, end, limit, pageToken, sort, _callback);
        Type localVarReturnType = new TypeToken<CryptoQuotesResp>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call cryptoSnapshotsCall(String symbols, CryptoLoc loc, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1beta3/crypto/{loc}/snapshots".replace("{loc}", this.localVarApiClient.escapeString(loc.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (symbols != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbols", symbols));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cryptoSnapshotsValidateBeforeCall(String symbols, CryptoLoc loc, ApiCallback _callback) throws ApiException {
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling cryptoSnapshots(Async)");
        }
        if (loc == null) {
            throw new ApiException("Missing the required parameter 'loc' when calling cryptoSnapshots(Async)");
        }
        return this.cryptoSnapshotsCall(symbols, loc, _callback);
    }

    public CryptoSnapshotsResp cryptoSnapshots(String symbols, CryptoLoc loc) throws ApiException {
        ApiResponse<CryptoSnapshotsResp> localVarResp = this.cryptoSnapshotsWithHttpInfo(symbols, loc);
        return localVarResp.getData();
    }

    protected ApiResponse<CryptoSnapshotsResp> cryptoSnapshotsWithHttpInfo(String symbols, CryptoLoc loc) throws ApiException {
        Call localVarCall = this.cryptoSnapshotsValidateBeforeCall(symbols, loc, null);
        Type localVarReturnType = new TypeToken<CryptoSnapshotsResp>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call cryptoSnapshotsAsync(String symbols, CryptoLoc loc, ApiCallback<CryptoSnapshotsResp> _callback) throws ApiException {
        Call localVarCall = this.cryptoSnapshotsValidateBeforeCall(symbols, loc, _callback);
        Type localVarReturnType = new TypeToken<CryptoSnapshotsResp>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call cryptoTradesCall(CryptoLoc loc, String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1beta3/crypto/{loc}/trades".replace("{loc}", this.localVarApiClient.escapeString(loc.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (symbols != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbols", symbols));
        }
        if (start != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start", start));
        }
        if (end != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end", end));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (pageToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_token", pageToken));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", (Object)sort));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cryptoTradesValidateBeforeCall(CryptoLoc loc, String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort, ApiCallback _callback) throws ApiException {
        if (loc == null) {
            throw new ApiException("Missing the required parameter 'loc' when calling cryptoTrades(Async)");
        }
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling cryptoTrades(Async)");
        }
        return this.cryptoTradesCall(loc, symbols, start, end, limit, pageToken, sort, _callback);
    }

    public CryptoTradesResp cryptoTrades(CryptoLoc loc, String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort) throws ApiException {
        ApiResponse<CryptoTradesResp> localVarResp = this.cryptoTradesWithHttpInfo(loc, symbols, start, end, limit, pageToken, sort);
        return localVarResp.getData();
    }

    protected ApiResponse<CryptoTradesResp> cryptoTradesWithHttpInfo(CryptoLoc loc, String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort) throws ApiException {
        Call localVarCall = this.cryptoTradesValidateBeforeCall(loc, symbols, start, end, limit, pageToken, sort, null);
        Type localVarReturnType = new TypeToken<CryptoTradesResp>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call cryptoTradesAsync(CryptoLoc loc, String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort, ApiCallback<CryptoTradesResp> _callback) throws ApiException {
        Call localVarCall = this.cryptoTradesValidateBeforeCall(loc, symbols, start, end, limit, pageToken, sort, _callback);
        Type localVarReturnType = new TypeToken<CryptoTradesResp>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

