/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.marketdata.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiCallback;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiClient;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiException;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiResponse;
import net.jacobpeterson.alpaca.openapi.marketdata.Configuration;
import net.jacobpeterson.alpaca.openapi.marketdata.Pair;
import net.jacobpeterson.alpaca.openapi.marketdata.model.ForexLatestRatesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.ForexRatesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.Sort;
import okhttp3.Call;

public class ForexApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ForexApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ForexApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    protected Call latestRatesCall(String currencyPairs, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1beta1/forex/latest/rates";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (currencyPairs != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pairs", currencyPairs));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "apiSecret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call latestRatesValidateBeforeCall(String currencyPairs, ApiCallback _callback) throws ApiException {
        if (currencyPairs == null) {
            throw new ApiException("Missing the required parameter 'currencyPairs' when calling latestRates(Async)");
        }
        return this.latestRatesCall(currencyPairs, _callback);
    }

    public ForexLatestRatesResp latestRates(String currencyPairs) throws ApiException {
        ApiResponse<ForexLatestRatesResp> localVarResp = this.latestRatesWithHttpInfo(currencyPairs);
        return localVarResp.getData();
    }

    protected ApiResponse<ForexLatestRatesResp> latestRatesWithHttpInfo(String currencyPairs) throws ApiException {
        Call localVarCall = this.latestRatesValidateBeforeCall(currencyPairs, null);
        Type localVarReturnType = new TypeToken<ForexLatestRatesResp>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call latestRatesAsync(String currencyPairs, ApiCallback<ForexLatestRatesResp> _callback) throws ApiException {
        Call localVarCall = this.latestRatesValidateBeforeCall(currencyPairs, _callback);
        Type localVarReturnType = new TypeToken<ForexLatestRatesResp>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call ratesCall(String currencyPairs, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, Sort sort, String pageToken, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1beta1/forex/rates";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (currencyPairs != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pairs", currencyPairs));
        }
        if (timeframe != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeframe", timeframe));
        }
        if (start != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start", start));
        }
        if (end != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end", end));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", (Object)sort));
        }
        if (pageToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_token", pageToken));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "apiSecret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call ratesValidateBeforeCall(String currencyPairs, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, Sort sort, String pageToken, ApiCallback _callback) throws ApiException {
        if (currencyPairs == null) {
            throw new ApiException("Missing the required parameter 'currencyPairs' when calling rates(Async)");
        }
        return this.ratesCall(currencyPairs, timeframe, start, end, limit, sort, pageToken, _callback);
    }

    public ForexRatesResp rates(String currencyPairs, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, Sort sort, String pageToken) throws ApiException {
        ApiResponse<ForexRatesResp> localVarResp = this.ratesWithHttpInfo(currencyPairs, timeframe, start, end, limit, sort, pageToken);
        return localVarResp.getData();
    }

    protected ApiResponse<ForexRatesResp> ratesWithHttpInfo(String currencyPairs, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, Sort sort, String pageToken) throws ApiException {
        Call localVarCall = this.ratesValidateBeforeCall(currencyPairs, timeframe, start, end, limit, sort, pageToken, null);
        Type localVarReturnType = new TypeToken<ForexRatesResp>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call ratesAsync(String currencyPairs, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, Sort sort, String pageToken, ApiCallback<ForexRatesResp> _callback) throws ApiException {
        Call localVarCall = this.ratesValidateBeforeCall(currencyPairs, timeframe, start, end, limit, sort, pageToken, _callback);
        Type localVarReturnType = new TypeToken<ForexRatesResp>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

