/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.marketdata.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiCallback;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiClient;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiException;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiResponse;
import net.jacobpeterson.alpaca.openapi.marketdata.Configuration;
import net.jacobpeterson.alpaca.openapi.marketdata.Pair;
import net.jacobpeterson.alpaca.openapi.marketdata.model.NewsResp;
import okhttp3.Call;

public class NewsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public NewsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public NewsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    protected Call newsCall(OffsetDateTime start, OffsetDateTime end, String sort, String symbols, Integer limit, Boolean includeContent, Boolean excludeContentless, String pageToken, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1beta1/news";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (start != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start", start));
        }
        if (end != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end", end));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (symbols != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbols", symbols));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (includeContent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("include_content", includeContent));
        }
        if (excludeContentless != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("exclude_contentless", excludeContentless));
        }
        if (pageToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_token", pageToken));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "apiSecret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call newsValidateBeforeCall(OffsetDateTime start, OffsetDateTime end, String sort, String symbols, Integer limit, Boolean includeContent, Boolean excludeContentless, String pageToken, ApiCallback _callback) throws ApiException {
        return this.newsCall(start, end, sort, symbols, limit, includeContent, excludeContentless, pageToken, _callback);
    }

    public NewsResp news(OffsetDateTime start, OffsetDateTime end, String sort, String symbols, Integer limit, Boolean includeContent, Boolean excludeContentless, String pageToken) throws ApiException {
        ApiResponse<NewsResp> localVarResp = this.newsWithHttpInfo(start, end, sort, symbols, limit, includeContent, excludeContentless, pageToken);
        return localVarResp.getData();
    }

    protected ApiResponse<NewsResp> newsWithHttpInfo(OffsetDateTime start, OffsetDateTime end, String sort, String symbols, Integer limit, Boolean includeContent, Boolean excludeContentless, String pageToken) throws ApiException {
        Call localVarCall = this.newsValidateBeforeCall(start, end, sort, symbols, limit, includeContent, excludeContentless, pageToken, null);
        Type localVarReturnType = new TypeToken<NewsResp>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call newsAsync(OffsetDateTime start, OffsetDateTime end, String sort, String symbols, Integer limit, Boolean includeContent, Boolean excludeContentless, String pageToken, ApiCallback<NewsResp> _callback) throws ApiException {
        Call localVarCall = this.newsValidateBeforeCall(start, end, sort, symbols, limit, includeContent, excludeContentless, pageToken, _callback);
        Type localVarReturnType = new TypeToken<NewsResp>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

