/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.marketdata.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiCallback;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiClient;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiException;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiResponse;
import net.jacobpeterson.alpaca.openapi.marketdata.Configuration;
import net.jacobpeterson.alpaca.openapi.marketdata.Pair;
import net.jacobpeterson.alpaca.openapi.marketdata.model.OptionBarsResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.OptionFeed;
import net.jacobpeterson.alpaca.openapi.marketdata.model.OptionLatestQuotesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.OptionLatestTradesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.OptionSnapshotsResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.OptionTradesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.Sort;
import okhttp3.Call;

public class OptionApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public OptionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OptionApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    protected Call optionBarsCall(String symbols, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1beta1/options/bars";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (symbols != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbols", symbols));
        }
        if (timeframe != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeframe", timeframe));
        }
        if (start != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start", start));
        }
        if (end != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end", end));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (pageToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_token", pageToken));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", (Object)sort));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "apiSecret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call optionBarsValidateBeforeCall(String symbols, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort, ApiCallback _callback) throws ApiException {
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling optionBars(Async)");
        }
        if (timeframe == null) {
            throw new ApiException("Missing the required parameter 'timeframe' when calling optionBars(Async)");
        }
        return this.optionBarsCall(symbols, timeframe, start, end, limit, pageToken, sort, _callback);
    }

    public OptionBarsResp optionBars(String symbols, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort) throws ApiException {
        ApiResponse<OptionBarsResp> localVarResp = this.optionBarsWithHttpInfo(symbols, timeframe, start, end, limit, pageToken, sort);
        return localVarResp.getData();
    }

    protected ApiResponse<OptionBarsResp> optionBarsWithHttpInfo(String symbols, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort) throws ApiException {
        Call localVarCall = this.optionBarsValidateBeforeCall(symbols, timeframe, start, end, limit, pageToken, sort, null);
        Type localVarReturnType = new TypeToken<OptionBarsResp>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call optionBarsAsync(String symbols, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort, ApiCallback<OptionBarsResp> _callback) throws ApiException {
        Call localVarCall = this.optionBarsValidateBeforeCall(symbols, timeframe, start, end, limit, pageToken, sort, _callback);
        Type localVarReturnType = new TypeToken<OptionBarsResp>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call optionChainCall(String underlyingSymbol, OptionFeed feed, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1beta1/options/snapshots/{underlying_symbol}".replace("{underlying_symbol}", this.localVarApiClient.escapeString(underlyingSymbol.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (feed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("feed", (Object)feed));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "apiSecret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call optionChainValidateBeforeCall(String underlyingSymbol, OptionFeed feed, ApiCallback _callback) throws ApiException {
        if (underlyingSymbol == null) {
            throw new ApiException("Missing the required parameter 'underlyingSymbol' when calling optionChain(Async)");
        }
        return this.optionChainCall(underlyingSymbol, feed, _callback);
    }

    public OptionSnapshotsResp optionChain(String underlyingSymbol, OptionFeed feed) throws ApiException {
        ApiResponse<OptionSnapshotsResp> localVarResp = this.optionChainWithHttpInfo(underlyingSymbol, feed);
        return localVarResp.getData();
    }

    protected ApiResponse<OptionSnapshotsResp> optionChainWithHttpInfo(String underlyingSymbol, OptionFeed feed) throws ApiException {
        Call localVarCall = this.optionChainValidateBeforeCall(underlyingSymbol, feed, null);
        Type localVarReturnType = new TypeToken<OptionSnapshotsResp>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call optionChainAsync(String underlyingSymbol, OptionFeed feed, ApiCallback<OptionSnapshotsResp> _callback) throws ApiException {
        Call localVarCall = this.optionChainValidateBeforeCall(underlyingSymbol, feed, _callback);
        Type localVarReturnType = new TypeToken<OptionSnapshotsResp>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call optionLatestQuotesCall(String symbols, OptionFeed feed, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1beta1/options/quotes/latest";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (symbols != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbols", symbols));
        }
        if (feed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("feed", (Object)feed));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "apiSecret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call optionLatestQuotesValidateBeforeCall(String symbols, OptionFeed feed, ApiCallback _callback) throws ApiException {
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling optionLatestQuotes(Async)");
        }
        return this.optionLatestQuotesCall(symbols, feed, _callback);
    }

    public OptionLatestQuotesResp optionLatestQuotes(String symbols, OptionFeed feed) throws ApiException {
        ApiResponse<OptionLatestQuotesResp> localVarResp = this.optionLatestQuotesWithHttpInfo(symbols, feed);
        return localVarResp.getData();
    }

    protected ApiResponse<OptionLatestQuotesResp> optionLatestQuotesWithHttpInfo(String symbols, OptionFeed feed) throws ApiException {
        Call localVarCall = this.optionLatestQuotesValidateBeforeCall(symbols, feed, null);
        Type localVarReturnType = new TypeToken<OptionLatestQuotesResp>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call optionLatestQuotesAsync(String symbols, OptionFeed feed, ApiCallback<OptionLatestQuotesResp> _callback) throws ApiException {
        Call localVarCall = this.optionLatestQuotesValidateBeforeCall(symbols, feed, _callback);
        Type localVarReturnType = new TypeToken<OptionLatestQuotesResp>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call optionLatestTradesCall(String symbols, OptionFeed feed, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1beta1/options/trades/latest";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (symbols != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbols", symbols));
        }
        if (feed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("feed", (Object)feed));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "apiSecret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call optionLatestTradesValidateBeforeCall(String symbols, OptionFeed feed, ApiCallback _callback) throws ApiException {
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling optionLatestTrades(Async)");
        }
        return this.optionLatestTradesCall(symbols, feed, _callback);
    }

    public OptionLatestTradesResp optionLatestTrades(String symbols, OptionFeed feed) throws ApiException {
        ApiResponse<OptionLatestTradesResp> localVarResp = this.optionLatestTradesWithHttpInfo(symbols, feed);
        return localVarResp.getData();
    }

    protected ApiResponse<OptionLatestTradesResp> optionLatestTradesWithHttpInfo(String symbols, OptionFeed feed) throws ApiException {
        Call localVarCall = this.optionLatestTradesValidateBeforeCall(symbols, feed, null);
        Type localVarReturnType = new TypeToken<OptionLatestTradesResp>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call optionLatestTradesAsync(String symbols, OptionFeed feed, ApiCallback<OptionLatestTradesResp> _callback) throws ApiException {
        Call localVarCall = this.optionLatestTradesValidateBeforeCall(symbols, feed, _callback);
        Type localVarReturnType = new TypeToken<OptionLatestTradesResp>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call optionMetaExchangesCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1beta1/options/meta/exchanges";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "apiSecret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call optionMetaExchangesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.optionMetaExchangesCall(_callback);
    }

    public Map<String, String> optionMetaExchanges() throws ApiException {
        ApiResponse<Map<String, String>> localVarResp = this.optionMetaExchangesWithHttpInfo();
        return localVarResp.getData();
    }

    protected ApiResponse<Map<String, String>> optionMetaExchangesWithHttpInfo() throws ApiException {
        Call localVarCall = this.optionMetaExchangesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<Map<String, String>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call optionMetaExchangesAsync(ApiCallback<Map<String, String>> _callback) throws ApiException {
        Call localVarCall = this.optionMetaExchangesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<Map<String, String>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call optionSnapshotsCall(String symbols, OptionFeed feed, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1beta1/options/snapshots";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (symbols != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbols", symbols));
        }
        if (feed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("feed", (Object)feed));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "apiSecret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call optionSnapshotsValidateBeforeCall(String symbols, OptionFeed feed, ApiCallback _callback) throws ApiException {
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling optionSnapshots(Async)");
        }
        return this.optionSnapshotsCall(symbols, feed, _callback);
    }

    public OptionSnapshotsResp optionSnapshots(String symbols, OptionFeed feed) throws ApiException {
        ApiResponse<OptionSnapshotsResp> localVarResp = this.optionSnapshotsWithHttpInfo(symbols, feed);
        return localVarResp.getData();
    }

    protected ApiResponse<OptionSnapshotsResp> optionSnapshotsWithHttpInfo(String symbols, OptionFeed feed) throws ApiException {
        Call localVarCall = this.optionSnapshotsValidateBeforeCall(symbols, feed, null);
        Type localVarReturnType = new TypeToken<OptionSnapshotsResp>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call optionSnapshotsAsync(String symbols, OptionFeed feed, ApiCallback<OptionSnapshotsResp> _callback) throws ApiException {
        Call localVarCall = this.optionSnapshotsValidateBeforeCall(symbols, feed, _callback);
        Type localVarReturnType = new TypeToken<OptionSnapshotsResp>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call optionTradesCall(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1beta1/options/trades";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (symbols != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbols", symbols));
        }
        if (start != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start", start));
        }
        if (end != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end", end));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (pageToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_token", pageToken));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", (Object)sort));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "apiSecret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call optionTradesValidateBeforeCall(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort, ApiCallback _callback) throws ApiException {
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling optionTrades(Async)");
        }
        return this.optionTradesCall(symbols, start, end, limit, pageToken, sort, _callback);
    }

    public OptionTradesResp optionTrades(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort) throws ApiException {
        ApiResponse<OptionTradesResp> localVarResp = this.optionTradesWithHttpInfo(symbols, start, end, limit, pageToken, sort);
        return localVarResp.getData();
    }

    protected ApiResponse<OptionTradesResp> optionTradesWithHttpInfo(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort) throws ApiException {
        Call localVarCall = this.optionTradesValidateBeforeCall(symbols, start, end, limit, pageToken, sort, null);
        Type localVarReturnType = new TypeToken<OptionTradesResp>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call optionTradesAsync(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort, ApiCallback<OptionTradesResp> _callback) throws ApiException {
        Call localVarCall = this.optionTradesValidateBeforeCall(symbols, start, end, limit, pageToken, sort, _callback);
        Type localVarReturnType = new TypeToken<OptionTradesResp>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

