/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.marketdata.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiCallback;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiClient;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiException;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiResponse;
import net.jacobpeterson.alpaca.openapi.marketdata.Configuration;
import net.jacobpeterson.alpaca.openapi.marketdata.Pair;
import net.jacobpeterson.alpaca.openapi.marketdata.model.Sort;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockAdjustment;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockAuctionsResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockAuctionsRespSingle;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockBarsResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockBarsRespSingle;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockFeed;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockLatestBarsResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockLatestBarsRespSingle;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockLatestQuotesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockLatestQuotesRespSingle;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockLatestTradesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockLatestTradesRespSingle;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockQuotesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockQuotesRespSingle;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockSnapshot;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockSnapshotsRespSingle;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockTradesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockTradesRespSingle;
import okhttp3.Call;

public class StockApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public StockApi() {
        this(Configuration.getDefaultApiClient());
    }

    public StockApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    protected Call stockAuctionSingleCall(String symbol, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/stocks/{symbol}/auctions".replace("{symbol}", this.localVarApiClient.escapeString(symbol.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (start != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start", start));
        }
        if (end != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end", end));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (asof != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("asof", asof));
        }
        if (feed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("feed", (Object)feed));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (pageToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_token", pageToken));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", (Object)sort));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "apiSecret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call stockAuctionSingleValidateBeforeCall(String symbol, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, ApiCallback _callback) throws ApiException {
        if (symbol == null) {
            throw new ApiException("Missing the required parameter 'symbol' when calling stockAuctionSingle(Async)");
        }
        return this.stockAuctionSingleCall(symbol, start, end, limit, asof, feed, currency, pageToken, sort, _callback);
    }

    public StockAuctionsRespSingle stockAuctionSingle(String symbol, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort) throws ApiException {
        ApiResponse<StockAuctionsRespSingle> localVarResp = this.stockAuctionSingleWithHttpInfo(symbol, start, end, limit, asof, feed, currency, pageToken, sort);
        return localVarResp.getData();
    }

    protected ApiResponse<StockAuctionsRespSingle> stockAuctionSingleWithHttpInfo(String symbol, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort) throws ApiException {
        Call localVarCall = this.stockAuctionSingleValidateBeforeCall(symbol, start, end, limit, asof, feed, currency, pageToken, sort, null);
        Type localVarReturnType = new TypeToken<StockAuctionsRespSingle>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call stockAuctionSingleAsync(String symbol, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, ApiCallback<StockAuctionsRespSingle> _callback) throws ApiException {
        Call localVarCall = this.stockAuctionSingleValidateBeforeCall(symbol, start, end, limit, asof, feed, currency, pageToken, sort, _callback);
        Type localVarReturnType = new TypeToken<StockAuctionsRespSingle>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call stockAuctionsCall(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/stocks/auctions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (symbols != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbols", symbols));
        }
        if (start != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start", start));
        }
        if (end != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end", end));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (asof != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("asof", asof));
        }
        if (feed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("feed", (Object)feed));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (pageToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_token", pageToken));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", (Object)sort));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "apiSecret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call stockAuctionsValidateBeforeCall(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, ApiCallback _callback) throws ApiException {
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling stockAuctions(Async)");
        }
        return this.stockAuctionsCall(symbols, start, end, limit, asof, feed, currency, pageToken, sort, _callback);
    }

    public StockAuctionsResp stockAuctions(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort) throws ApiException {
        ApiResponse<StockAuctionsResp> localVarResp = this.stockAuctionsWithHttpInfo(symbols, start, end, limit, asof, feed, currency, pageToken, sort);
        return localVarResp.getData();
    }

    protected ApiResponse<StockAuctionsResp> stockAuctionsWithHttpInfo(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort) throws ApiException {
        Call localVarCall = this.stockAuctionsValidateBeforeCall(symbols, start, end, limit, asof, feed, currency, pageToken, sort, null);
        Type localVarReturnType = new TypeToken<StockAuctionsResp>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call stockAuctionsAsync(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, ApiCallback<StockAuctionsResp> _callback) throws ApiException {
        Call localVarCall = this.stockAuctionsValidateBeforeCall(symbols, start, end, limit, asof, feed, currency, pageToken, sort, _callback);
        Type localVarReturnType = new TypeToken<StockAuctionsResp>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call stockBarSingleCall(String symbol, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, StockAdjustment adjustment, String asof, StockFeed feed, String currency, String pageToken, Sort sort, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/stocks/{symbol}/bars".replace("{symbol}", this.localVarApiClient.escapeString(symbol.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (timeframe != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeframe", timeframe));
        }
        if (start != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start", start));
        }
        if (end != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end", end));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (adjustment != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("adjustment", (Object)adjustment));
        }
        if (asof != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("asof", asof));
        }
        if (feed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("feed", (Object)feed));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (pageToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_token", pageToken));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", (Object)sort));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "apiSecret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call stockBarSingleValidateBeforeCall(String symbol, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, StockAdjustment adjustment, String asof, StockFeed feed, String currency, String pageToken, Sort sort, ApiCallback _callback) throws ApiException {
        if (symbol == null) {
            throw new ApiException("Missing the required parameter 'symbol' when calling stockBarSingle(Async)");
        }
        if (timeframe == null) {
            throw new ApiException("Missing the required parameter 'timeframe' when calling stockBarSingle(Async)");
        }
        return this.stockBarSingleCall(symbol, timeframe, start, end, limit, adjustment, asof, feed, currency, pageToken, sort, _callback);
    }

    public StockBarsRespSingle stockBarSingle(String symbol, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, StockAdjustment adjustment, String asof, StockFeed feed, String currency, String pageToken, Sort sort) throws ApiException {
        ApiResponse<StockBarsRespSingle> localVarResp = this.stockBarSingleWithHttpInfo(symbol, timeframe, start, end, limit, adjustment, asof, feed, currency, pageToken, sort);
        return localVarResp.getData();
    }

    protected ApiResponse<StockBarsRespSingle> stockBarSingleWithHttpInfo(String symbol, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, StockAdjustment adjustment, String asof, StockFeed feed, String currency, String pageToken, Sort sort) throws ApiException {
        Call localVarCall = this.stockBarSingleValidateBeforeCall(symbol, timeframe, start, end, limit, adjustment, asof, feed, currency, pageToken, sort, null);
        Type localVarReturnType = new TypeToken<StockBarsRespSingle>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call stockBarSingleAsync(String symbol, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, StockAdjustment adjustment, String asof, StockFeed feed, String currency, String pageToken, Sort sort, ApiCallback<StockBarsRespSingle> _callback) throws ApiException {
        Call localVarCall = this.stockBarSingleValidateBeforeCall(symbol, timeframe, start, end, limit, adjustment, asof, feed, currency, pageToken, sort, _callback);
        Type localVarReturnType = new TypeToken<StockBarsRespSingle>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call stockBarsCall(String symbols, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, StockAdjustment adjustment, String asof, StockFeed feed, String currency, String pageToken, Sort sort, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/stocks/bars";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (symbols != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbols", symbols));
        }
        if (timeframe != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeframe", timeframe));
        }
        if (start != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start", start));
        }
        if (end != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end", end));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (adjustment != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("adjustment", (Object)adjustment));
        }
        if (asof != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("asof", asof));
        }
        if (feed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("feed", (Object)feed));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (pageToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_token", pageToken));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", (Object)sort));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "apiSecret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call stockBarsValidateBeforeCall(String symbols, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, StockAdjustment adjustment, String asof, StockFeed feed, String currency, String pageToken, Sort sort, ApiCallback _callback) throws ApiException {
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling stockBars(Async)");
        }
        if (timeframe == null) {
            throw new ApiException("Missing the required parameter 'timeframe' when calling stockBars(Async)");
        }
        return this.stockBarsCall(symbols, timeframe, start, end, limit, adjustment, asof, feed, currency, pageToken, sort, _callback);
    }

    public StockBarsResp stockBars(String symbols, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, StockAdjustment adjustment, String asof, StockFeed feed, String currency, String pageToken, Sort sort) throws ApiException {
        ApiResponse<StockBarsResp> localVarResp = this.stockBarsWithHttpInfo(symbols, timeframe, start, end, limit, adjustment, asof, feed, currency, pageToken, sort);
        return localVarResp.getData();
    }

    protected ApiResponse<StockBarsResp> stockBarsWithHttpInfo(String symbols, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, StockAdjustment adjustment, String asof, StockFeed feed, String currency, String pageToken, Sort sort) throws ApiException {
        Call localVarCall = this.stockBarsValidateBeforeCall(symbols, timeframe, start, end, limit, adjustment, asof, feed, currency, pageToken, sort, null);
        Type localVarReturnType = new TypeToken<StockBarsResp>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call stockBarsAsync(String symbols, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, StockAdjustment adjustment, String asof, StockFeed feed, String currency, String pageToken, Sort sort, ApiCallback<StockBarsResp> _callback) throws ApiException {
        Call localVarCall = this.stockBarsValidateBeforeCall(symbols, timeframe, start, end, limit, adjustment, asof, feed, currency, pageToken, sort, _callback);
        Type localVarReturnType = new TypeToken<StockBarsResp>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call stockLatestBarSingleCall(String symbol, StockFeed feed, String currency, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/stocks/{symbol}/bars/latest".replace("{symbol}", this.localVarApiClient.escapeString(symbol.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (feed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("feed", (Object)feed));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "apiSecret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call stockLatestBarSingleValidateBeforeCall(String symbol, StockFeed feed, String currency, ApiCallback _callback) throws ApiException {
        if (symbol == null) {
            throw new ApiException("Missing the required parameter 'symbol' when calling stockLatestBarSingle(Async)");
        }
        return this.stockLatestBarSingleCall(symbol, feed, currency, _callback);
    }

    public StockLatestBarsRespSingle stockLatestBarSingle(String symbol, StockFeed feed, String currency) throws ApiException {
        ApiResponse<StockLatestBarsRespSingle> localVarResp = this.stockLatestBarSingleWithHttpInfo(symbol, feed, currency);
        return localVarResp.getData();
    }

    protected ApiResponse<StockLatestBarsRespSingle> stockLatestBarSingleWithHttpInfo(String symbol, StockFeed feed, String currency) throws ApiException {
        Call localVarCall = this.stockLatestBarSingleValidateBeforeCall(symbol, feed, currency, null);
        Type localVarReturnType = new TypeToken<StockLatestBarsRespSingle>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call stockLatestBarSingleAsync(String symbol, StockFeed feed, String currency, ApiCallback<StockLatestBarsRespSingle> _callback) throws ApiException {
        Call localVarCall = this.stockLatestBarSingleValidateBeforeCall(symbol, feed, currency, _callback);
        Type localVarReturnType = new TypeToken<StockLatestBarsRespSingle>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call stockLatestBarsCall(String symbols, StockFeed feed, String currency, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/stocks/bars/latest";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (symbols != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbols", symbols));
        }
        if (feed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("feed", (Object)feed));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "apiSecret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call stockLatestBarsValidateBeforeCall(String symbols, StockFeed feed, String currency, ApiCallback _callback) throws ApiException {
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling stockLatestBars(Async)");
        }
        return this.stockLatestBarsCall(symbols, feed, currency, _callback);
    }

    public StockLatestBarsResp stockLatestBars(String symbols, StockFeed feed, String currency) throws ApiException {
        ApiResponse<StockLatestBarsResp> localVarResp = this.stockLatestBarsWithHttpInfo(symbols, feed, currency);
        return localVarResp.getData();
    }

    protected ApiResponse<StockLatestBarsResp> stockLatestBarsWithHttpInfo(String symbols, StockFeed feed, String currency) throws ApiException {
        Call localVarCall = this.stockLatestBarsValidateBeforeCall(symbols, feed, currency, null);
        Type localVarReturnType = new TypeToken<StockLatestBarsResp>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call stockLatestBarsAsync(String symbols, StockFeed feed, String currency, ApiCallback<StockLatestBarsResp> _callback) throws ApiException {
        Call localVarCall = this.stockLatestBarsValidateBeforeCall(symbols, feed, currency, _callback);
        Type localVarReturnType = new TypeToken<StockLatestBarsResp>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call stockLatestQuoteSingleCall(String symbol, StockFeed feed, String currency, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/stocks/{symbol}/quotes/latest".replace("{symbol}", this.localVarApiClient.escapeString(symbol.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (feed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("feed", (Object)feed));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "apiSecret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call stockLatestQuoteSingleValidateBeforeCall(String symbol, StockFeed feed, String currency, ApiCallback _callback) throws ApiException {
        if (symbol == null) {
            throw new ApiException("Missing the required parameter 'symbol' when calling stockLatestQuoteSingle(Async)");
        }
        return this.stockLatestQuoteSingleCall(symbol, feed, currency, _callback);
    }

    public StockLatestQuotesRespSingle stockLatestQuoteSingle(String symbol, StockFeed feed, String currency) throws ApiException {
        ApiResponse<StockLatestQuotesRespSingle> localVarResp = this.stockLatestQuoteSingleWithHttpInfo(symbol, feed, currency);
        return localVarResp.getData();
    }

    protected ApiResponse<StockLatestQuotesRespSingle> stockLatestQuoteSingleWithHttpInfo(String symbol, StockFeed feed, String currency) throws ApiException {
        Call localVarCall = this.stockLatestQuoteSingleValidateBeforeCall(symbol, feed, currency, null);
        Type localVarReturnType = new TypeToken<StockLatestQuotesRespSingle>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call stockLatestQuoteSingleAsync(String symbol, StockFeed feed, String currency, ApiCallback<StockLatestQuotesRespSingle> _callback) throws ApiException {
        Call localVarCall = this.stockLatestQuoteSingleValidateBeforeCall(symbol, feed, currency, _callback);
        Type localVarReturnType = new TypeToken<StockLatestQuotesRespSingle>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call stockLatestQuotesCall(String symbols, StockFeed feed, String currency, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/stocks/quotes/latest";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (symbols != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbols", symbols));
        }
        if (feed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("feed", (Object)feed));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "apiSecret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call stockLatestQuotesValidateBeforeCall(String symbols, StockFeed feed, String currency, ApiCallback _callback) throws ApiException {
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling stockLatestQuotes(Async)");
        }
        return this.stockLatestQuotesCall(symbols, feed, currency, _callback);
    }

    public StockLatestQuotesResp stockLatestQuotes(String symbols, StockFeed feed, String currency) throws ApiException {
        ApiResponse<StockLatestQuotesResp> localVarResp = this.stockLatestQuotesWithHttpInfo(symbols, feed, currency);
        return localVarResp.getData();
    }

    protected ApiResponse<StockLatestQuotesResp> stockLatestQuotesWithHttpInfo(String symbols, StockFeed feed, String currency) throws ApiException {
        Call localVarCall = this.stockLatestQuotesValidateBeforeCall(symbols, feed, currency, null);
        Type localVarReturnType = new TypeToken<StockLatestQuotesResp>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call stockLatestQuotesAsync(String symbols, StockFeed feed, String currency, ApiCallback<StockLatestQuotesResp> _callback) throws ApiException {
        Call localVarCall = this.stockLatestQuotesValidateBeforeCall(symbols, feed, currency, _callback);
        Type localVarReturnType = new TypeToken<StockLatestQuotesResp>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call stockLatestTradeSingleCall(String symbol, StockFeed feed, String currency, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/stocks/{symbol}/trades/latest".replace("{symbol}", this.localVarApiClient.escapeString(symbol.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (feed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("feed", (Object)feed));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "apiSecret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call stockLatestTradeSingleValidateBeforeCall(String symbol, StockFeed feed, String currency, ApiCallback _callback) throws ApiException {
        if (symbol == null) {
            throw new ApiException("Missing the required parameter 'symbol' when calling stockLatestTradeSingle(Async)");
        }
        return this.stockLatestTradeSingleCall(symbol, feed, currency, _callback);
    }

    public StockLatestTradesRespSingle stockLatestTradeSingle(String symbol, StockFeed feed, String currency) throws ApiException {
        ApiResponse<StockLatestTradesRespSingle> localVarResp = this.stockLatestTradeSingleWithHttpInfo(symbol, feed, currency);
        return localVarResp.getData();
    }

    protected ApiResponse<StockLatestTradesRespSingle> stockLatestTradeSingleWithHttpInfo(String symbol, StockFeed feed, String currency) throws ApiException {
        Call localVarCall = this.stockLatestTradeSingleValidateBeforeCall(symbol, feed, currency, null);
        Type localVarReturnType = new TypeToken<StockLatestTradesRespSingle>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call stockLatestTradeSingleAsync(String symbol, StockFeed feed, String currency, ApiCallback<StockLatestTradesRespSingle> _callback) throws ApiException {
        Call localVarCall = this.stockLatestTradeSingleValidateBeforeCall(symbol, feed, currency, _callback);
        Type localVarReturnType = new TypeToken<StockLatestTradesRespSingle>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call stockLatestTradesCall(String symbols, StockFeed feed, String currency, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/stocks/trades/latest";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (symbols != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbols", symbols));
        }
        if (feed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("feed", (Object)feed));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "apiSecret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call stockLatestTradesValidateBeforeCall(String symbols, StockFeed feed, String currency, ApiCallback _callback) throws ApiException {
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling stockLatestTrades(Async)");
        }
        return this.stockLatestTradesCall(symbols, feed, currency, _callback);
    }

    public StockLatestTradesResp stockLatestTrades(String symbols, StockFeed feed, String currency) throws ApiException {
        ApiResponse<StockLatestTradesResp> localVarResp = this.stockLatestTradesWithHttpInfo(symbols, feed, currency);
        return localVarResp.getData();
    }

    protected ApiResponse<StockLatestTradesResp> stockLatestTradesWithHttpInfo(String symbols, StockFeed feed, String currency) throws ApiException {
        Call localVarCall = this.stockLatestTradesValidateBeforeCall(symbols, feed, currency, null);
        Type localVarReturnType = new TypeToken<StockLatestTradesResp>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call stockLatestTradesAsync(String symbols, StockFeed feed, String currency, ApiCallback<StockLatestTradesResp> _callback) throws ApiException {
        Call localVarCall = this.stockLatestTradesValidateBeforeCall(symbols, feed, currency, _callback);
        Type localVarReturnType = new TypeToken<StockLatestTradesResp>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call stockMetaConditionsCall(String ticktype, String tape, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/stocks/meta/conditions/{ticktype}".replace("{ticktype}", this.localVarApiClient.escapeString(ticktype.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (tape != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tape", tape));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "apiSecret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call stockMetaConditionsValidateBeforeCall(String ticktype, String tape, ApiCallback _callback) throws ApiException {
        if (ticktype == null) {
            throw new ApiException("Missing the required parameter 'ticktype' when calling stockMetaConditions(Async)");
        }
        if (tape == null) {
            throw new ApiException("Missing the required parameter 'tape' when calling stockMetaConditions(Async)");
        }
        return this.stockMetaConditionsCall(ticktype, tape, _callback);
    }

    public Map<String, String> stockMetaConditions(String ticktype, String tape) throws ApiException {
        ApiResponse<Map<String, String>> localVarResp = this.stockMetaConditionsWithHttpInfo(ticktype, tape);
        return localVarResp.getData();
    }

    protected ApiResponse<Map<String, String>> stockMetaConditionsWithHttpInfo(String ticktype, String tape) throws ApiException {
        Call localVarCall = this.stockMetaConditionsValidateBeforeCall(ticktype, tape, null);
        Type localVarReturnType = new TypeToken<Map<String, String>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call stockMetaConditionsAsync(String ticktype, String tape, ApiCallback<Map<String, String>> _callback) throws ApiException {
        Call localVarCall = this.stockMetaConditionsValidateBeforeCall(ticktype, tape, _callback);
        Type localVarReturnType = new TypeToken<Map<String, String>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call stockMetaExchangesCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/stocks/meta/exchanges";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "apiSecret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call stockMetaExchangesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.stockMetaExchangesCall(_callback);
    }

    public Map<String, String> stockMetaExchanges() throws ApiException {
        ApiResponse<Map<String, String>> localVarResp = this.stockMetaExchangesWithHttpInfo();
        return localVarResp.getData();
    }

    protected ApiResponse<Map<String, String>> stockMetaExchangesWithHttpInfo() throws ApiException {
        Call localVarCall = this.stockMetaExchangesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<Map<String, String>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call stockMetaExchangesAsync(ApiCallback<Map<String, String>> _callback) throws ApiException {
        Call localVarCall = this.stockMetaExchangesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<Map<String, String>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call stockQuoteSingleCall(String symbol, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/stocks/{symbol}/quotes".replace("{symbol}", this.localVarApiClient.escapeString(symbol.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (start != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start", start));
        }
        if (end != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end", end));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (asof != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("asof", asof));
        }
        if (feed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("feed", (Object)feed));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (pageToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_token", pageToken));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", (Object)sort));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "apiSecret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call stockQuoteSingleValidateBeforeCall(String symbol, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, ApiCallback _callback) throws ApiException {
        if (symbol == null) {
            throw new ApiException("Missing the required parameter 'symbol' when calling stockQuoteSingle(Async)");
        }
        return this.stockQuoteSingleCall(symbol, start, end, limit, asof, feed, currency, pageToken, sort, _callback);
    }

    public StockQuotesRespSingle stockQuoteSingle(String symbol, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort) throws ApiException {
        ApiResponse<StockQuotesRespSingle> localVarResp = this.stockQuoteSingleWithHttpInfo(symbol, start, end, limit, asof, feed, currency, pageToken, sort);
        return localVarResp.getData();
    }

    protected ApiResponse<StockQuotesRespSingle> stockQuoteSingleWithHttpInfo(String symbol, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort) throws ApiException {
        Call localVarCall = this.stockQuoteSingleValidateBeforeCall(symbol, start, end, limit, asof, feed, currency, pageToken, sort, null);
        Type localVarReturnType = new TypeToken<StockQuotesRespSingle>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call stockQuoteSingleAsync(String symbol, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, ApiCallback<StockQuotesRespSingle> _callback) throws ApiException {
        Call localVarCall = this.stockQuoteSingleValidateBeforeCall(symbol, start, end, limit, asof, feed, currency, pageToken, sort, _callback);
        Type localVarReturnType = new TypeToken<StockQuotesRespSingle>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call stockQuotesCall(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/stocks/quotes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (symbols != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbols", symbols));
        }
        if (start != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start", start));
        }
        if (end != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end", end));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (asof != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("asof", asof));
        }
        if (feed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("feed", (Object)feed));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (pageToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_token", pageToken));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", (Object)sort));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "apiSecret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call stockQuotesValidateBeforeCall(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, ApiCallback _callback) throws ApiException {
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling stockQuotes(Async)");
        }
        return this.stockQuotesCall(symbols, start, end, limit, asof, feed, currency, pageToken, sort, _callback);
    }

    public StockQuotesResp stockQuotes(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort) throws ApiException {
        ApiResponse<StockQuotesResp> localVarResp = this.stockQuotesWithHttpInfo(symbols, start, end, limit, asof, feed, currency, pageToken, sort);
        return localVarResp.getData();
    }

    protected ApiResponse<StockQuotesResp> stockQuotesWithHttpInfo(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort) throws ApiException {
        Call localVarCall = this.stockQuotesValidateBeforeCall(symbols, start, end, limit, asof, feed, currency, pageToken, sort, null);
        Type localVarReturnType = new TypeToken<StockQuotesResp>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call stockQuotesAsync(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, ApiCallback<StockQuotesResp> _callback) throws ApiException {
        Call localVarCall = this.stockQuotesValidateBeforeCall(symbols, start, end, limit, asof, feed, currency, pageToken, sort, _callback);
        Type localVarReturnType = new TypeToken<StockQuotesResp>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call stockSnapshotSingleCall(String symbol, StockFeed feed, String currency, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/stocks/{symbol}/snapshot".replace("{symbol}", this.localVarApiClient.escapeString(symbol.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (feed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("feed", (Object)feed));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "apiSecret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call stockSnapshotSingleValidateBeforeCall(String symbol, StockFeed feed, String currency, ApiCallback _callback) throws ApiException {
        if (symbol == null) {
            throw new ApiException("Missing the required parameter 'symbol' when calling stockSnapshotSingle(Async)");
        }
        return this.stockSnapshotSingleCall(symbol, feed, currency, _callback);
    }

    public StockSnapshotsRespSingle stockSnapshotSingle(String symbol, StockFeed feed, String currency) throws ApiException {
        ApiResponse<StockSnapshotsRespSingle> localVarResp = this.stockSnapshotSingleWithHttpInfo(symbol, feed, currency);
        return localVarResp.getData();
    }

    protected ApiResponse<StockSnapshotsRespSingle> stockSnapshotSingleWithHttpInfo(String symbol, StockFeed feed, String currency) throws ApiException {
        Call localVarCall = this.stockSnapshotSingleValidateBeforeCall(symbol, feed, currency, null);
        Type localVarReturnType = new TypeToken<StockSnapshotsRespSingle>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call stockSnapshotSingleAsync(String symbol, StockFeed feed, String currency, ApiCallback<StockSnapshotsRespSingle> _callback) throws ApiException {
        Call localVarCall = this.stockSnapshotSingleValidateBeforeCall(symbol, feed, currency, _callback);
        Type localVarReturnType = new TypeToken<StockSnapshotsRespSingle>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call stockSnapshotsCall(String symbols, StockFeed feed, String currency, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/stocks/snapshots";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (symbols != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbols", symbols));
        }
        if (feed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("feed", (Object)feed));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "apiSecret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call stockSnapshotsValidateBeforeCall(String symbols, StockFeed feed, String currency, ApiCallback _callback) throws ApiException {
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling stockSnapshots(Async)");
        }
        return this.stockSnapshotsCall(symbols, feed, currency, _callback);
    }

    public Map<String, StockSnapshot> stockSnapshots(String symbols, StockFeed feed, String currency) throws ApiException {
        ApiResponse<Map<String, StockSnapshot>> localVarResp = this.stockSnapshotsWithHttpInfo(symbols, feed, currency);
        return localVarResp.getData();
    }

    protected ApiResponse<Map<String, StockSnapshot>> stockSnapshotsWithHttpInfo(String symbols, StockFeed feed, String currency) throws ApiException {
        Call localVarCall = this.stockSnapshotsValidateBeforeCall(symbols, feed, currency, null);
        Type localVarReturnType = new TypeToken<Map<String, StockSnapshot>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call stockSnapshotsAsync(String symbols, StockFeed feed, String currency, ApiCallback<Map<String, StockSnapshot>> _callback) throws ApiException {
        Call localVarCall = this.stockSnapshotsValidateBeforeCall(symbols, feed, currency, _callback);
        Type localVarReturnType = new TypeToken<Map<String, StockSnapshot>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call stockTradeSingleCall(String symbol, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/stocks/{symbol}/trades".replace("{symbol}", this.localVarApiClient.escapeString(symbol.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (start != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start", start));
        }
        if (end != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end", end));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (asof != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("asof", asof));
        }
        if (feed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("feed", (Object)feed));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (pageToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_token", pageToken));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", (Object)sort));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "apiSecret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call stockTradeSingleValidateBeforeCall(String symbol, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, ApiCallback _callback) throws ApiException {
        if (symbol == null) {
            throw new ApiException("Missing the required parameter 'symbol' when calling stockTradeSingle(Async)");
        }
        return this.stockTradeSingleCall(symbol, start, end, limit, asof, feed, currency, pageToken, sort, _callback);
    }

    public StockTradesRespSingle stockTradeSingle(String symbol, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort) throws ApiException {
        ApiResponse<StockTradesRespSingle> localVarResp = this.stockTradeSingleWithHttpInfo(symbol, start, end, limit, asof, feed, currency, pageToken, sort);
        return localVarResp.getData();
    }

    protected ApiResponse<StockTradesRespSingle> stockTradeSingleWithHttpInfo(String symbol, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort) throws ApiException {
        Call localVarCall = this.stockTradeSingleValidateBeforeCall(symbol, start, end, limit, asof, feed, currency, pageToken, sort, null);
        Type localVarReturnType = new TypeToken<StockTradesRespSingle>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call stockTradeSingleAsync(String symbol, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, ApiCallback<StockTradesRespSingle> _callback) throws ApiException {
        Call localVarCall = this.stockTradeSingleValidateBeforeCall(symbol, start, end, limit, asof, feed, currency, pageToken, sort, _callback);
        Type localVarReturnType = new TypeToken<StockTradesRespSingle>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call stockTradesCall(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/stocks/trades";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (symbols != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbols", symbols));
        }
        if (start != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start", start));
        }
        if (end != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end", end));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (asof != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("asof", asof));
        }
        if (feed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("feed", (Object)feed));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (pageToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_token", pageToken));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", (Object)sort));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "apiSecret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call stockTradesValidateBeforeCall(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, ApiCallback _callback) throws ApiException {
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling stockTrades(Async)");
        }
        return this.stockTradesCall(symbols, start, end, limit, asof, feed, currency, pageToken, sort, _callback);
    }

    public StockTradesResp stockTrades(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort) throws ApiException {
        ApiResponse<StockTradesResp> localVarResp = this.stockTradesWithHttpInfo(symbols, start, end, limit, asof, feed, currency, pageToken, sort);
        return localVarResp.getData();
    }

    protected ApiResponse<StockTradesResp> stockTradesWithHttpInfo(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort) throws ApiException {
        Call localVarCall = this.stockTradesValidateBeforeCall(symbols, start, end, limit, asof, feed, currency, pageToken, sort, null);
        Type localVarReturnType = new TypeToken<StockTradesResp>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call stockTradesAsync(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, ApiCallback<StockTradesResp> _callback) throws ApiException {
        Call localVarCall = this.stockTradesValidateBeforeCall(symbols, start, end, limit, asof, feed, currency, pageToken, sort, _callback);
        Type localVarReturnType = new TypeToken<StockTradesResp>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

