/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.marketdata.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.marketdata.JSON;

public class CACashMerger {
    public static final String SERIALIZED_NAME_ACQUIRER_SYMBOL = "acquirer_symbol";
    @SerializedName(value="acquirer_symbol")
    private String acquirerSymbol;
    public static final String SERIALIZED_NAME_ACQUIREE_SYMBOL = "acquiree_symbol";
    @SerializedName(value="acquiree_symbol")
    private String acquireeSymbol;
    public static final String SERIALIZED_NAME_RATE = "rate";
    @SerializedName(value="rate")
    private Double rate;
    public static final String SERIALIZED_NAME_PROCESS_DATE = "process_date";
    @SerializedName(value="process_date")
    private LocalDate processDate;
    public static final String SERIALIZED_NAME_EFFECTIVE_DATE = "effective_date";
    @SerializedName(value="effective_date")
    private LocalDate effectiveDate;
    public static final String SERIALIZED_NAME_PAYABLE_DATE = "payable_date";
    @SerializedName(value="payable_date")
    private LocalDate payableDate;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public CACashMerger acquirerSymbol(String acquirerSymbol) {
        this.acquirerSymbol = acquirerSymbol;
        return this;
    }

    @Nullable
    public String getAcquirerSymbol() {
        return this.acquirerSymbol;
    }

    public void setAcquirerSymbol(String acquirerSymbol) {
        this.acquirerSymbol = acquirerSymbol;
    }

    public CACashMerger acquireeSymbol(String acquireeSymbol) {
        this.acquireeSymbol = acquireeSymbol;
        return this;
    }

    @Nonnull
    public String getAcquireeSymbol() {
        return this.acquireeSymbol;
    }

    public void setAcquireeSymbol(String acquireeSymbol) {
        this.acquireeSymbol = acquireeSymbol;
    }

    public CACashMerger rate(Double rate) {
        this.rate = rate;
        return this;
    }

    @Nonnull
    public Double getRate() {
        return this.rate;
    }

    public void setRate(Double rate) {
        this.rate = rate;
    }

    public CACashMerger processDate(LocalDate processDate) {
        this.processDate = processDate;
        return this;
    }

    @Nonnull
    public LocalDate getProcessDate() {
        return this.processDate;
    }

    public void setProcessDate(LocalDate processDate) {
        this.processDate = processDate;
    }

    public CACashMerger effectiveDate(LocalDate effectiveDate) {
        this.effectiveDate = effectiveDate;
        return this;
    }

    @Nonnull
    public LocalDate getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(LocalDate effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public CACashMerger payableDate(LocalDate payableDate) {
        this.payableDate = payableDate;
        return this;
    }

    @Nullable
    public LocalDate getPayableDate() {
        return this.payableDate;
    }

    public void setPayableDate(LocalDate payableDate) {
        this.payableDate = payableDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CACashMerger caCashMerger = (CACashMerger)o;
        return Objects.equals(this.acquirerSymbol, caCashMerger.acquirerSymbol) && Objects.equals(this.acquireeSymbol, caCashMerger.acquireeSymbol) && Objects.equals(this.rate, caCashMerger.rate) && Objects.equals(this.processDate, caCashMerger.processDate) && Objects.equals(this.effectiveDate, caCashMerger.effectiveDate) && Objects.equals(this.payableDate, caCashMerger.payableDate);
    }

    public int hashCode() {
        return Objects.hash(this.acquirerSymbol, this.acquireeSymbol, this.rate, this.processDate, this.effectiveDate, this.payableDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CACashMerger {\n");
        sb.append("    acquirerSymbol: ").append(this.toIndentedString(this.acquirerSymbol)).append("\n");
        sb.append("    acquireeSymbol: ").append(this.toIndentedString(this.acquireeSymbol)).append("\n");
        sb.append("    rate: ").append(this.toIndentedString(this.rate)).append("\n");
        sb.append("    processDate: ").append(this.toIndentedString(this.processDate)).append("\n");
        sb.append("    effectiveDate: ").append(this.toIndentedString(this.effectiveDate)).append("\n");
        sb.append("    payableDate: ").append(this.toIndentedString(this.payableDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in CACashMerger is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CACashMerger` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ACQUIRER_SYMBOL) != null && !jsonObj.get(SERIALIZED_NAME_ACQUIRER_SYMBOL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ACQUIRER_SYMBOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `acquirer_symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACQUIRER_SYMBOL).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_ACQUIREE_SYMBOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `acquiree_symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACQUIREE_SYMBOL).toString()));
        }
    }

    public static CACashMerger fromJson(String jsonString) throws IOException {
        return (CACashMerger)JSON.getGson().fromJson(jsonString, CACashMerger.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACQUIRER_SYMBOL);
        openapiFields.add(SERIALIZED_NAME_ACQUIREE_SYMBOL);
        openapiFields.add(SERIALIZED_NAME_RATE);
        openapiFields.add(SERIALIZED_NAME_PROCESS_DATE);
        openapiFields.add(SERIALIZED_NAME_EFFECTIVE_DATE);
        openapiFields.add(SERIALIZED_NAME_PAYABLE_DATE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ACQUIREE_SYMBOL);
        openapiRequiredFields.add(SERIALIZED_NAME_RATE);
        openapiRequiredFields.add(SERIALIZED_NAME_PROCESS_DATE);
        openapiRequiredFields.add(SERIALIZED_NAME_EFFECTIVE_DATE);
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CACashMerger.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CACashMerger.class));
            return new TypeAdapter<CACashMerger>(){

                public void write(JsonWriter out, CACashMerger value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CACashMerger read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    CACashMerger.validateJsonElement(jsonElement);
                    return (CACashMerger)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

