/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.marketdata.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.marketdata.JSON;

public class CAStockDividend {
    public static final String SERIALIZED_NAME_SYMBOL = "symbol";
    @SerializedName(value="symbol")
    private String symbol;
    public static final String SERIALIZED_NAME_RATE = "rate";
    @SerializedName(value="rate")
    private Double rate;
    public static final String SERIALIZED_NAME_PROCESS_DATE = "process_date";
    @SerializedName(value="process_date")
    private LocalDate processDate;
    public static final String SERIALIZED_NAME_EX_DATE = "ex_date";
    @SerializedName(value="ex_date")
    private LocalDate exDate;
    public static final String SERIALIZED_NAME_RECORD_DATE = "record_date";
    @SerializedName(value="record_date")
    private LocalDate recordDate;
    public static final String SERIALIZED_NAME_PAYABLE_DATE = "payable_date";
    @SerializedName(value="payable_date")
    private LocalDate payableDate;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public CAStockDividend symbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Nonnull
    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public CAStockDividend rate(Double rate) {
        this.rate = rate;
        return this;
    }

    @Nonnull
    public Double getRate() {
        return this.rate;
    }

    public void setRate(Double rate) {
        this.rate = rate;
    }

    public CAStockDividend processDate(LocalDate processDate) {
        this.processDate = processDate;
        return this;
    }

    @Nonnull
    public LocalDate getProcessDate() {
        return this.processDate;
    }

    public void setProcessDate(LocalDate processDate) {
        this.processDate = processDate;
    }

    public CAStockDividend exDate(LocalDate exDate) {
        this.exDate = exDate;
        return this;
    }

    @Nonnull
    public LocalDate getExDate() {
        return this.exDate;
    }

    public void setExDate(LocalDate exDate) {
        this.exDate = exDate;
    }

    public CAStockDividend recordDate(LocalDate recordDate) {
        this.recordDate = recordDate;
        return this;
    }

    @Nullable
    public LocalDate getRecordDate() {
        return this.recordDate;
    }

    public void setRecordDate(LocalDate recordDate) {
        this.recordDate = recordDate;
    }

    public CAStockDividend payableDate(LocalDate payableDate) {
        this.payableDate = payableDate;
        return this;
    }

    @Nullable
    public LocalDate getPayableDate() {
        return this.payableDate;
    }

    public void setPayableDate(LocalDate payableDate) {
        this.payableDate = payableDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CAStockDividend caStockDividend = (CAStockDividend)o;
        return Objects.equals(this.symbol, caStockDividend.symbol) && Objects.equals(this.rate, caStockDividend.rate) && Objects.equals(this.processDate, caStockDividend.processDate) && Objects.equals(this.exDate, caStockDividend.exDate) && Objects.equals(this.recordDate, caStockDividend.recordDate) && Objects.equals(this.payableDate, caStockDividend.payableDate);
    }

    public int hashCode() {
        return Objects.hash(this.symbol, this.rate, this.processDate, this.exDate, this.recordDate, this.payableDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CAStockDividend {\n");
        sb.append("    symbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("    rate: ").append(this.toIndentedString(this.rate)).append("\n");
        sb.append("    processDate: ").append(this.toIndentedString(this.processDate)).append("\n");
        sb.append("    exDate: ").append(this.toIndentedString(this.exDate)).append("\n");
        sb.append("    recordDate: ").append(this.toIndentedString(this.recordDate)).append("\n");
        sb.append("    payableDate: ").append(this.toIndentedString(this.payableDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in CAStockDividend is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CAStockDividend` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_SYMBOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SYMBOL).toString()));
        }
    }

    public static CAStockDividend fromJson(String jsonString) throws IOException {
        return (CAStockDividend)JSON.getGson().fromJson(jsonString, CAStockDividend.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_SYMBOL);
        openapiFields.add(SERIALIZED_NAME_RATE);
        openapiFields.add(SERIALIZED_NAME_PROCESS_DATE);
        openapiFields.add(SERIALIZED_NAME_EX_DATE);
        openapiFields.add(SERIALIZED_NAME_RECORD_DATE);
        openapiFields.add(SERIALIZED_NAME_PAYABLE_DATE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_SYMBOL);
        openapiRequiredFields.add(SERIALIZED_NAME_RATE);
        openapiRequiredFields.add(SERIALIZED_NAME_PROCESS_DATE);
        openapiRequiredFields.add(SERIALIZED_NAME_EX_DATE);
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CAStockDividend.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CAStockDividend.class));
            return new TypeAdapter<CAStockDividend>(){

                public void write(JsonWriter out, CAStockDividend value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CAStockDividend read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    CAStockDividend.validateJsonElement(jsonElement);
                    return (CAStockDividend)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

