/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.marketdata.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.jacobpeterson.alpaca.openapi.marketdata.JSON;

public class ForexRate {
    public static final String SERIALIZED_NAME_BP = "bp";
    @SerializedName(value="bp")
    private Double bp;
    public static final String SERIALIZED_NAME_MP = "mp";
    @SerializedName(value="mp")
    private Double mp;
    public static final String SERIALIZED_NAME_AP = "ap";
    @SerializedName(value="ap")
    private Double ap;
    public static final String SERIALIZED_NAME_T = "t";
    @SerializedName(value="t")
    private OffsetDateTime t;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public ForexRate bp(Double bp) {
        this.bp = bp;
        return this;
    }

    @Nonnull
    public Double getBp() {
        return this.bp;
    }

    public void setBp(Double bp) {
        this.bp = bp;
    }

    public ForexRate mp(Double mp) {
        this.mp = mp;
        return this;
    }

    @Nonnull
    public Double getMp() {
        return this.mp;
    }

    public void setMp(Double mp) {
        this.mp = mp;
    }

    public ForexRate ap(Double ap) {
        this.ap = ap;
        return this;
    }

    @Nonnull
    public Double getAp() {
        return this.ap;
    }

    public void setAp(Double ap) {
        this.ap = ap;
    }

    public ForexRate t(OffsetDateTime t) {
        this.t = t;
        return this;
    }

    @Nonnull
    public OffsetDateTime getT() {
        return this.t;
    }

    public void setT(OffsetDateTime t) {
        this.t = t;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForexRate forexRate = (ForexRate)o;
        return Objects.equals(this.bp, forexRate.bp) && Objects.equals(this.mp, forexRate.mp) && Objects.equals(this.ap, forexRate.ap) && Objects.equals(this.t, forexRate.t);
    }

    public int hashCode() {
        return Objects.hash(this.bp, this.mp, this.ap, this.t);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ForexRate {\n");
        sb.append("    bp: ").append(this.toIndentedString(this.bp)).append("\n");
        sb.append("    mp: ").append(this.toIndentedString(this.mp)).append("\n");
        sb.append("    ap: ").append(this.toIndentedString(this.ap)).append("\n");
        sb.append("    t: ").append(this.toIndentedString(this.t)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in ForexRate is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ForexRate` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
    }

    public static ForexRate fromJson(String jsonString) throws IOException {
        return (ForexRate)JSON.getGson().fromJson(jsonString, ForexRate.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BP);
        openapiFields.add(SERIALIZED_NAME_MP);
        openapiFields.add(SERIALIZED_NAME_AP);
        openapiFields.add(SERIALIZED_NAME_T);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_BP);
        openapiRequiredFields.add(SERIALIZED_NAME_MP);
        openapiRequiredFields.add(SERIALIZED_NAME_AP);
        openapiRequiredFields.add(SERIALIZED_NAME_T);
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ForexRate.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ForexRate.class));
            return new TypeAdapter<ForexRate>(){

                public void write(JsonWriter out, ForexRate value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ForexRate read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    ForexRate.validateJsonElement(jsonElement);
                    return (ForexRate)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

