/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.marketdata.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.marketdata.JSON;
import net.jacobpeterson.alpaca.openapi.marketdata.model.NewsImage;
import org.openapitools.jackson.nullable.JsonNullable;

public class News {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private Long id;
    public static final String SERIALIZED_NAME_HEADLINE = "headline";
    @SerializedName(value="headline")
    private String headline;
    public static final String SERIALIZED_NAME_AUTHOR = "author";
    @SerializedName(value="author")
    private String author;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updated_at";
    @SerializedName(value="updated_at")
    private OffsetDateTime updatedAt;
    public static final String SERIALIZED_NAME_SUMMARY = "summary";
    @SerializedName(value="summary")
    private String summary;
    public static final String SERIALIZED_NAME_CONTENT = "content";
    @SerializedName(value="content")
    private String content;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private URI url;
    public static final String SERIALIZED_NAME_IMAGES = "images";
    @SerializedName(value="images")
    private Set<NewsImage> images = new LinkedHashSet<NewsImage>();
    public static final String SERIALIZED_NAME_SYMBOLS = "symbols";
    @SerializedName(value="symbols")
    private List<String> symbols = new ArrayList<String>();
    public static final String SERIALIZED_NAME_SOURCE = "source";
    @SerializedName(value="source")
    private String source;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public News id(Long id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public News headline(String headline) {
        this.headline = headline;
        return this;
    }

    @Nonnull
    public String getHeadline() {
        return this.headline;
    }

    public void setHeadline(String headline) {
        this.headline = headline;
    }

    public News author(String author) {
        this.author = author;
        return this;
    }

    @Nonnull
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public News createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public News updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nonnull
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public News summary(String summary) {
        this.summary = summary;
        return this;
    }

    @Nonnull
    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public News content(String content) {
        this.content = content;
        return this;
    }

    @Nonnull
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public News url(URI url) {
        this.url = url;
        return this;
    }

    @Nullable
    public URI getUrl() {
        return this.url;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public News images(Set<NewsImage> images) {
        this.images = images;
        return this;
    }

    public News addImagesItem(NewsImage imagesItem) {
        if (this.images == null) {
            this.images = new LinkedHashSet<NewsImage>();
        }
        this.images.add(imagesItem);
        return this;
    }

    @Nonnull
    public Set<NewsImage> getImages() {
        return this.images;
    }

    public void setImages(Set<NewsImage> images) {
        this.images = images;
    }

    public News symbols(List<String> symbols) {
        this.symbols = symbols;
        return this;
    }

    public News addSymbolsItem(String symbolsItem) {
        if (this.symbols == null) {
            this.symbols = new ArrayList<String>();
        }
        this.symbols.add(symbolsItem);
        return this;
    }

    @Nonnull
    public List<String> getSymbols() {
        return this.symbols;
    }

    public void setSymbols(List<String> symbols) {
        this.symbols = symbols;
    }

    public News source(String source) {
        this.source = source;
        return this;
    }

    @Nonnull
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        News news = (News)o;
        return Objects.equals(this.id, news.id) && Objects.equals(this.headline, news.headline) && Objects.equals(this.author, news.author) && Objects.equals(this.createdAt, news.createdAt) && Objects.equals(this.updatedAt, news.updatedAt) && Objects.equals(this.summary, news.summary) && Objects.equals(this.content, news.content) && Objects.equals(this.url, news.url) && Objects.equals(this.images, news.images) && Objects.equals(this.symbols, news.symbols) && Objects.equals(this.source, news.source);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.headline, this.author, this.createdAt, this.updatedAt, this.summary, this.content, this.url, this.images, this.symbols, this.source);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class News {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    headline: ").append(this.toIndentedString(this.headline)).append("\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    summary: ").append(this.toIndentedString(this.summary)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    images: ").append(this.toIndentedString(this.images)).append("\n");
        sb.append("    symbols: ").append(this.toIndentedString(this.symbols)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in News is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `News` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_HEADLINE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `headline` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HEADLINE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_AUTHOR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `author` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AUTHOR).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_SUMMARY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `summary` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUMMARY).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_CONTENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `content` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTENT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_URL) != null && !jsonObj.get(SERIALIZED_NAME_URL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URL).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_IMAGES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `images` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGES).toString()));
        }
        JsonArray jsonArrayimages = jsonObj.getAsJsonArray(SERIALIZED_NAME_IMAGES);
        for (int i = 0; i < jsonArrayimages.size(); ++i) {
            NewsImage.validateJsonElement(jsonArrayimages.get(i));
        }
        if (jsonObj.get(SERIALIZED_NAME_SYMBOLS) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_SYMBOLS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `symbols` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SYMBOLS).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_SOURCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `source` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SOURCE).toString()));
        }
    }

    public static News fromJson(String jsonString) throws IOException {
        return (News)JSON.getGson().fromJson(jsonString, News.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_HEADLINE);
        openapiFields.add(SERIALIZED_NAME_AUTHOR);
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiFields.add(SERIALIZED_NAME_UPDATED_AT);
        openapiFields.add(SERIALIZED_NAME_SUMMARY);
        openapiFields.add(SERIALIZED_NAME_CONTENT);
        openapiFields.add(SERIALIZED_NAME_URL);
        openapiFields.add(SERIALIZED_NAME_IMAGES);
        openapiFields.add(SERIALIZED_NAME_SYMBOLS);
        openapiFields.add(SERIALIZED_NAME_SOURCE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_HEADLINE);
        openapiRequiredFields.add(SERIALIZED_NAME_AUTHOR);
        openapiRequiredFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiRequiredFields.add(SERIALIZED_NAME_UPDATED_AT);
        openapiRequiredFields.add(SERIALIZED_NAME_SUMMARY);
        openapiRequiredFields.add(SERIALIZED_NAME_CONTENT);
        openapiRequiredFields.add(SERIALIZED_NAME_IMAGES);
        openapiRequiredFields.add(SERIALIZED_NAME_SYMBOLS);
        openapiRequiredFields.add(SERIALIZED_NAME_SOURCE);
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!News.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(News.class));
            return new TypeAdapter<News>(){

                public void write(JsonWriter out, News value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public News read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    News.validateJsonElement(jsonElement);
                    return (News)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

