/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.marketdata.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.jacobpeterson.alpaca.openapi.marketdata.JSON;

public class NewsImage {
    public static final String SERIALIZED_NAME_SIZE = "size";
    @SerializedName(value="size")
    private SizeEnum size;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private URI url;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public NewsImage size(SizeEnum size) {
        this.size = size;
        return this;
    }

    @Nonnull
    public SizeEnum getSize() {
        return this.size;
    }

    public void setSize(SizeEnum size) {
        this.size = size;
    }

    public NewsImage url(URI url) {
        this.url = url;
        return this;
    }

    @Nonnull
    public URI getUrl() {
        return this.url;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewsImage newsImage = (NewsImage)o;
        return Objects.equals((Object)this.size, (Object)newsImage.size) && Objects.equals(this.url, newsImage.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.size, this.url});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NewsImage {\n");
        sb.append("    size: ").append(this.toIndentedString((Object)this.size)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in NewsImage is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `NewsImage` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_SIZE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `size` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SIZE).toString()));
        }
        SizeEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SIZE));
        if (!jsonObj.get(SERIALIZED_NAME_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URL).toString()));
        }
    }

    public static NewsImage fromJson(String jsonString) throws IOException {
        return (NewsImage)JSON.getGson().fromJson(jsonString, NewsImage.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_SIZE);
        openapiFields.add(SERIALIZED_NAME_URL);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_SIZE);
        openapiRequiredFields.add(SERIALIZED_NAME_URL);
        validate = false;
        isValid = jsonElement -> true;
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SizeEnum {
        THUMB("thumb"),
        SMALL("small"),
        LARGE("large");

        private String value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private SizeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SizeEnum fromValue(String value) {
            for (SizeEnum b : SizeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            String value = jsonElement.getAsString();
            SizeEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<SizeEnum> {
            public void write(JsonWriter jsonWriter, SizeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SizeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SizeEnum.fromValue(value);
            }
        }
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!NewsImage.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(NewsImage.class));
            return new TypeAdapter<NewsImage>(){

                public void write(JsonWriter out, NewsImage value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public NewsImage read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    NewsImage.validateJsonElement(jsonElement);
                    return (NewsImage)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

