/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.marketdata.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.marketdata.JSON;
import net.jacobpeterson.alpaca.openapi.marketdata.model.News;

public class NewsResp {
    public static final String SERIALIZED_NAME_NEWS = "news";
    @SerializedName(value="news")
    private List<News> news = new ArrayList<News>();
    public static final String SERIALIZED_NAME_NEXT_PAGE_TOKEN = "next_page_token";
    @SerializedName(value="next_page_token")
    private String nextPageToken;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public NewsResp news(List<News> news) {
        this.news = news;
        return this;
    }

    public NewsResp addNewsItem(News newsItem) {
        if (this.news == null) {
            this.news = new ArrayList<News>();
        }
        this.news.add(newsItem);
        return this;
    }

    @Nonnull
    public List<News> getNews() {
        return this.news;
    }

    public void setNews(List<News> news) {
        this.news = news;
    }

    public NewsResp nextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
        return this;
    }

    @Nullable
    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewsResp newsResp = (NewsResp)o;
        return Objects.equals(this.news, newsResp.news) && Objects.equals(this.nextPageToken, newsResp.nextPageToken);
    }

    public int hashCode() {
        return Objects.hash(this.news, this.nextPageToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NewsResp {\n");
        sb.append("    news: ").append(this.toIndentedString(this.news)).append("\n");
        sb.append("    nextPageToken: ").append(this.toIndentedString(this.nextPageToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in NewsResp is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `NewsResp` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_NEWS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `news` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NEWS).toString()));
        }
        JsonArray jsonArraynews = jsonObj.getAsJsonArray(SERIALIZED_NAME_NEWS);
        for (int i = 0; i < jsonArraynews.size(); ++i) {
            News.validateJsonElement(jsonArraynews.get(i));
        }
        if (jsonObj.get(SERIALIZED_NAME_NEXT_PAGE_TOKEN) != null && !jsonObj.get(SERIALIZED_NAME_NEXT_PAGE_TOKEN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NEXT_PAGE_TOKEN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `next_page_token` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NEXT_PAGE_TOKEN).toString()));
        }
    }

    public static NewsResp fromJson(String jsonString) throws IOException {
        return (NewsResp)JSON.getGson().fromJson(jsonString, NewsResp.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NEWS);
        openapiFields.add(SERIALIZED_NAME_NEXT_PAGE_TOKEN);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NEWS);
        openapiRequiredFields.add(SERIALIZED_NAME_NEXT_PAGE_TOKEN);
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!NewsResp.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(NewsResp.class));
            return new TypeAdapter<NewsResp>(){

                public void write(JsonWriter out, NewsResp value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public NewsResp read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    NewsResp.validateJsonElement(jsonElement);
                    return (NewsResp)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

