/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.marketdata.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.function.Predicate;

@JsonAdapter(value=Adapter.class)
public enum StockAdjustment {
    RAW("raw"),
    SPLIT("split"),
    DIVIDEND("dividend"),
    ALL("all");

    private String value;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    private StockAdjustment(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StockAdjustment fromValue(String value) {
        for (StockAdjustment b : StockAdjustment.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        return null;
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        String value = jsonElement.getAsString();
        StockAdjustment.fromValue(value);
    }

    static {
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class Adapter
    extends TypeAdapter<StockAdjustment> {
        public void write(JsonWriter jsonWriter, StockAdjustment enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public StockAdjustment read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return StockAdjustment.fromValue(value);
        }
    }
}

