/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.marketdata.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.marketdata.JSON;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockBar;

public class StockBarsResp {
    public static final String SERIALIZED_NAME_BARS = "bars";
    @SerializedName(value="bars")
    private Map<String, List<StockBar>> bars = new HashMap<String, List<StockBar>>();
    public static final String SERIALIZED_NAME_NEXT_PAGE_TOKEN = "next_page_token";
    @SerializedName(value="next_page_token")
    private String nextPageToken;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public StockBarsResp bars(Map<String, List<StockBar>> bars) {
        this.bars = bars;
        return this;
    }

    public StockBarsResp putBarsItem(String key, List<StockBar> barsItem) {
        if (this.bars == null) {
            this.bars = new HashMap<String, List<StockBar>>();
        }
        this.bars.put(key, barsItem);
        return this;
    }

    @Nonnull
    public Map<String, List<StockBar>> getBars() {
        return this.bars;
    }

    public void setBars(Map<String, List<StockBar>> bars) {
        this.bars = bars;
    }

    public StockBarsResp nextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
        return this;
    }

    @Nullable
    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public StockBarsResp currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StockBarsResp stockBarsResp = (StockBarsResp)o;
        return Objects.equals(this.bars, stockBarsResp.bars) && Objects.equals(this.nextPageToken, stockBarsResp.nextPageToken) && Objects.equals(this.currency, stockBarsResp.currency);
    }

    public int hashCode() {
        return Objects.hash(this.bars, this.nextPageToken, this.currency);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StockBarsResp {\n");
        sb.append("    bars: ").append(this.toIndentedString(this.bars)).append("\n");
        sb.append("    nextPageToken: ").append(this.toIndentedString(this.nextPageToken)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in StockBarsResp is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `StockBarsResp` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_NEXT_PAGE_TOKEN) != null && !jsonObj.get(SERIALIZED_NAME_NEXT_PAGE_TOKEN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NEXT_PAGE_TOKEN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `next_page_token` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NEXT_PAGE_TOKEN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CURRENCY) != null && !jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENCY).toString()));
        }
    }

    public static StockBarsResp fromJson(String jsonString) throws IOException {
        return (StockBarsResp)JSON.getGson().fromJson(jsonString, StockBarsResp.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BARS);
        openapiFields.add(SERIALIZED_NAME_NEXT_PAGE_TOKEN);
        openapiFields.add(SERIALIZED_NAME_CURRENCY);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_BARS);
        openapiRequiredFields.add(SERIALIZED_NAME_NEXT_PAGE_TOKEN);
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!StockBarsResp.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StockBarsResp.class));
            return new TypeAdapter<StockBarsResp>(){

                public void write(JsonWriter out, StockBarsResp value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public StockBarsResp read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    StockBarsResp.validateJsonElement(jsonElement);
                    return (StockBarsResp)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

