/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.marketdata.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.marketdata.JSON;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockBar;

public class StockBarsRespSingle {
    public static final String SERIALIZED_NAME_SYMBOL = "symbol";
    @SerializedName(value="symbol")
    private String symbol;
    public static final String SERIALIZED_NAME_BARS = "bars";
    @SerializedName(value="bars")
    private List<StockBar> bars = new ArrayList<StockBar>();
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_NEXT_PAGE_TOKEN = "next_page_token";
    @SerializedName(value="next_page_token")
    private String nextPageToken;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public StockBarsRespSingle symbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Nonnull
    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public StockBarsRespSingle bars(List<StockBar> bars) {
        this.bars = bars;
        return this;
    }

    public StockBarsRespSingle addBarsItem(StockBar barsItem) {
        if (this.bars == null) {
            this.bars = new ArrayList<StockBar>();
        }
        this.bars.add(barsItem);
        return this;
    }

    @Nonnull
    public List<StockBar> getBars() {
        return this.bars;
    }

    public void setBars(List<StockBar> bars) {
        this.bars = bars;
    }

    public StockBarsRespSingle currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public StockBarsRespSingle nextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
        return this;
    }

    @Nullable
    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StockBarsRespSingle stockBarsRespSingle = (StockBarsRespSingle)o;
        return Objects.equals(this.symbol, stockBarsRespSingle.symbol) && Objects.equals(this.bars, stockBarsRespSingle.bars) && Objects.equals(this.currency, stockBarsRespSingle.currency) && Objects.equals(this.nextPageToken, stockBarsRespSingle.nextPageToken);
    }

    public int hashCode() {
        return Objects.hash(this.symbol, this.bars, this.currency, this.nextPageToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StockBarsRespSingle {\n");
        sb.append("    symbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("    bars: ").append(this.toIndentedString(this.bars)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    nextPageToken: ").append(this.toIndentedString(this.nextPageToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in StockBarsRespSingle is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `StockBarsRespSingle` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_SYMBOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SYMBOL).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_BARS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `bars` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BARS).toString()));
        }
        JsonArray jsonArraybars = jsonObj.getAsJsonArray(SERIALIZED_NAME_BARS);
        for (int i = 0; i < jsonArraybars.size(); ++i) {
            StockBar.validateJsonElement(jsonArraybars.get(i));
        }
        if (jsonObj.get(SERIALIZED_NAME_CURRENCY) != null && !jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENCY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NEXT_PAGE_TOKEN) != null && !jsonObj.get(SERIALIZED_NAME_NEXT_PAGE_TOKEN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NEXT_PAGE_TOKEN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `next_page_token` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NEXT_PAGE_TOKEN).toString()));
        }
    }

    public static StockBarsRespSingle fromJson(String jsonString) throws IOException {
        return (StockBarsRespSingle)JSON.getGson().fromJson(jsonString, StockBarsRespSingle.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_SYMBOL);
        openapiFields.add(SERIALIZED_NAME_BARS);
        openapiFields.add(SERIALIZED_NAME_CURRENCY);
        openapiFields.add(SERIALIZED_NAME_NEXT_PAGE_TOKEN);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_SYMBOL);
        openapiRequiredFields.add(SERIALIZED_NAME_BARS);
        openapiRequiredFields.add(SERIALIZED_NAME_NEXT_PAGE_TOKEN);
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!StockBarsRespSingle.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StockBarsRespSingle.class));
            return new TypeAdapter<StockBarsRespSingle>(){

                public void write(JsonWriter out, StockBarsRespSingle value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public StockBarsRespSingle read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    StockBarsRespSingle.validateJsonElement(jsonElement);
                    return (StockBarsRespSingle)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

