/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.marketdata.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.function.Predicate;

@JsonAdapter(value=Adapter.class)
public enum StockFeed {
    IEX("iex"),
    OTC("otc"),
    SIP("sip");

    private String value;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    private StockFeed(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StockFeed fromValue(String value) {
        for (StockFeed b : StockFeed.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        return null;
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        String value = jsonElement.getAsString();
        StockFeed.fromValue(value);
    }

    static {
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class Adapter
    extends TypeAdapter<StockFeed> {
        public void write(JsonWriter jsonWriter, StockFeed enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public StockFeed read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return StockFeed.fromValue(value);
        }
    }
}

