/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.marketdata.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.marketdata.JSON;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockQuote;

public class StockLatestQuotesResp {
    public static final String SERIALIZED_NAME_QUOTES = "quotes";
    @SerializedName(value="quotes")
    private Map<String, StockQuote> quotes = new HashMap<String, StockQuote>();
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public StockLatestQuotesResp quotes(Map<String, StockQuote> quotes) {
        this.quotes = quotes;
        return this;
    }

    public StockLatestQuotesResp putQuotesItem(String key, StockQuote quotesItem) {
        if (this.quotes == null) {
            this.quotes = new HashMap<String, StockQuote>();
        }
        this.quotes.put(key, quotesItem);
        return this;
    }

    @Nonnull
    public Map<String, StockQuote> getQuotes() {
        return this.quotes;
    }

    public void setQuotes(Map<String, StockQuote> quotes) {
        this.quotes = quotes;
    }

    public StockLatestQuotesResp currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StockLatestQuotesResp stockLatestQuotesResp = (StockLatestQuotesResp)o;
        return Objects.equals(this.quotes, stockLatestQuotesResp.quotes) && Objects.equals(this.currency, stockLatestQuotesResp.currency);
    }

    public int hashCode() {
        return Objects.hash(this.quotes, this.currency);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StockLatestQuotesResp {\n");
        sb.append("    quotes: ").append(this.toIndentedString(this.quotes)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in StockLatestQuotesResp is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `StockLatestQuotesResp` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CURRENCY) != null && !jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENCY).toString()));
        }
    }

    public static StockLatestQuotesResp fromJson(String jsonString) throws IOException {
        return (StockLatestQuotesResp)JSON.getGson().fromJson(jsonString, StockLatestQuotesResp.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_QUOTES);
        openapiFields.add(SERIALIZED_NAME_CURRENCY);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_QUOTES);
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!StockLatestQuotesResp.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StockLatestQuotesResp.class));
            return new TypeAdapter<StockLatestQuotesResp>(){

                public void write(JsonWriter out, StockLatestQuotesResp value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public StockLatestQuotesResp read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    StockLatestQuotesResp.validateJsonElement(jsonElement);
                    return (StockLatestQuotesResp)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

