/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.marketdata.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.jacobpeterson.alpaca.openapi.marketdata.JSON;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockTape;

public class StockQuote {
    public static final String SERIALIZED_NAME_T = "t";
    @SerializedName(value="t")
    private OffsetDateTime t;
    public static final String SERIALIZED_NAME_BX = "bx";
    @SerializedName(value="bx")
    private String bx;
    public static final String SERIALIZED_NAME_BP = "bp";
    @SerializedName(value="bp")
    private Double bp;
    public static final String SERIALIZED_NAME_BS = "bs";
    @SerializedName(value="bs")
    private Integer bs;
    public static final String SERIALIZED_NAME_AX = "ax";
    @SerializedName(value="ax")
    private String ax;
    public static final String SERIALIZED_NAME_AP = "ap";
    @SerializedName(value="ap")
    private Double ap;
    public static final String SERIALIZED_NAME_AS = "as";
    @SerializedName(value="as")
    private Integer as;
    public static final String SERIALIZED_NAME_C = "c";
    @SerializedName(value="c")
    private List<String> c = new ArrayList<String>();
    public static final String SERIALIZED_NAME_Z = "z";
    @SerializedName(value="z")
    private StockTape z;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public StockQuote t(OffsetDateTime t) {
        this.t = t;
        return this;
    }

    @Nonnull
    public OffsetDateTime getT() {
        return this.t;
    }

    public void setT(OffsetDateTime t) {
        this.t = t;
    }

    public StockQuote bx(String bx) {
        this.bx = bx;
        return this;
    }

    @Nonnull
    public String getBx() {
        return this.bx;
    }

    public void setBx(String bx) {
        this.bx = bx;
    }

    public StockQuote bp(Double bp) {
        this.bp = bp;
        return this;
    }

    @Nonnull
    public Double getBp() {
        return this.bp;
    }

    public void setBp(Double bp) {
        this.bp = bp;
    }

    public StockQuote bs(Integer bs) {
        this.bs = bs;
        return this;
    }

    @Nonnull
    public Integer getBs() {
        return this.bs;
    }

    public void setBs(Integer bs) {
        this.bs = bs;
    }

    public StockQuote ax(String ax) {
        this.ax = ax;
        return this;
    }

    @Nonnull
    public String getAx() {
        return this.ax;
    }

    public void setAx(String ax) {
        this.ax = ax;
    }

    public StockQuote ap(Double ap) {
        this.ap = ap;
        return this;
    }

    @Nonnull
    public Double getAp() {
        return this.ap;
    }

    public void setAp(Double ap) {
        this.ap = ap;
    }

    public StockQuote as(Integer as) {
        this.as = as;
        return this;
    }

    @Nonnull
    public Integer getAs() {
        return this.as;
    }

    public void setAs(Integer as) {
        this.as = as;
    }

    public StockQuote c(List<String> c) {
        this.c = c;
        return this;
    }

    public StockQuote addCItem(String cItem) {
        if (this.c == null) {
            this.c = new ArrayList<String>();
        }
        this.c.add(cItem);
        return this;
    }

    @Nonnull
    public List<String> getC() {
        return this.c;
    }

    public void setC(List<String> c) {
        this.c = c;
    }

    public StockQuote z(StockTape z) {
        this.z = z;
        return this;
    }

    @Nonnull
    public StockTape getZ() {
        return this.z;
    }

    public void setZ(StockTape z) {
        this.z = z;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StockQuote stockQuote = (StockQuote)o;
        return Objects.equals(this.t, stockQuote.t) && Objects.equals(this.bx, stockQuote.bx) && Objects.equals(this.bp, stockQuote.bp) && Objects.equals(this.bs, stockQuote.bs) && Objects.equals(this.ax, stockQuote.ax) && Objects.equals(this.ap, stockQuote.ap) && Objects.equals(this.as, stockQuote.as) && Objects.equals(this.c, stockQuote.c) && Objects.equals((Object)this.z, (Object)stockQuote.z);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.t, this.bx, this.bp, this.bs, this.ax, this.ap, this.as, this.c, this.z});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StockQuote {\n");
        sb.append("    t: ").append(this.toIndentedString(this.t)).append("\n");
        sb.append("    bx: ").append(this.toIndentedString(this.bx)).append("\n");
        sb.append("    bp: ").append(this.toIndentedString(this.bp)).append("\n");
        sb.append("    bs: ").append(this.toIndentedString(this.bs)).append("\n");
        sb.append("    ax: ").append(this.toIndentedString(this.ax)).append("\n");
        sb.append("    ap: ").append(this.toIndentedString(this.ap)).append("\n");
        sb.append("    as: ").append(this.toIndentedString(this.as)).append("\n");
        sb.append("    c: ").append(this.toIndentedString(this.c)).append("\n");
        sb.append("    z: ").append(this.toIndentedString((Object)this.z)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in StockQuote is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `StockQuote` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_BX).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `bx` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BX).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_AX).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `ax` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AX).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_C) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_C).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `c` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_C).toString()));
        }
        StockTape.validateJsonElement(jsonObj.get(SERIALIZED_NAME_Z));
    }

    public static StockQuote fromJson(String jsonString) throws IOException {
        return (StockQuote)JSON.getGson().fromJson(jsonString, StockQuote.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_T);
        openapiFields.add(SERIALIZED_NAME_BX);
        openapiFields.add(SERIALIZED_NAME_BP);
        openapiFields.add(SERIALIZED_NAME_BS);
        openapiFields.add(SERIALIZED_NAME_AX);
        openapiFields.add(SERIALIZED_NAME_AP);
        openapiFields.add(SERIALIZED_NAME_AS);
        openapiFields.add(SERIALIZED_NAME_C);
        openapiFields.add(SERIALIZED_NAME_Z);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_T);
        openapiRequiredFields.add(SERIALIZED_NAME_BX);
        openapiRequiredFields.add(SERIALIZED_NAME_BP);
        openapiRequiredFields.add(SERIALIZED_NAME_BS);
        openapiRequiredFields.add(SERIALIZED_NAME_AX);
        openapiRequiredFields.add(SERIALIZED_NAME_AP);
        openapiRequiredFields.add(SERIALIZED_NAME_AS);
        openapiRequiredFields.add(SERIALIZED_NAME_C);
        openapiRequiredFields.add(SERIALIZED_NAME_Z);
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!StockQuote.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StockQuote.class));
            return new TypeAdapter<StockQuote>(){

                public void write(JsonWriter out, StockQuote value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public StockQuote read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    StockQuote.validateJsonElement(jsonElement);
                    return (StockQuote)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

