/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.marketdata.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.marketdata.JSON;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockQuote;

public class StockQuotesResp {
    public static final String SERIALIZED_NAME_QUOTES = "quotes";
    @SerializedName(value="quotes")
    private Map<String, List<StockQuote>> quotes = new HashMap<String, List<StockQuote>>();
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_NEXT_PAGE_TOKEN = "next_page_token";
    @SerializedName(value="next_page_token")
    private String nextPageToken;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public StockQuotesResp quotes(Map<String, List<StockQuote>> quotes) {
        this.quotes = quotes;
        return this;
    }

    public StockQuotesResp putQuotesItem(String key, List<StockQuote> quotesItem) {
        if (this.quotes == null) {
            this.quotes = new HashMap<String, List<StockQuote>>();
        }
        this.quotes.put(key, quotesItem);
        return this;
    }

    @Nonnull
    public Map<String, List<StockQuote>> getQuotes() {
        return this.quotes;
    }

    public void setQuotes(Map<String, List<StockQuote>> quotes) {
        this.quotes = quotes;
    }

    public StockQuotesResp currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public StockQuotesResp nextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
        return this;
    }

    @Nullable
    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StockQuotesResp stockQuotesResp = (StockQuotesResp)o;
        return Objects.equals(this.quotes, stockQuotesResp.quotes) && Objects.equals(this.currency, stockQuotesResp.currency) && Objects.equals(this.nextPageToken, stockQuotesResp.nextPageToken);
    }

    public int hashCode() {
        return Objects.hash(this.quotes, this.currency, this.nextPageToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StockQuotesResp {\n");
        sb.append("    quotes: ").append(this.toIndentedString(this.quotes)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    nextPageToken: ").append(this.toIndentedString(this.nextPageToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in StockQuotesResp is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `StockQuotesResp` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CURRENCY) != null && !jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENCY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NEXT_PAGE_TOKEN) != null && !jsonObj.get(SERIALIZED_NAME_NEXT_PAGE_TOKEN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NEXT_PAGE_TOKEN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `next_page_token` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NEXT_PAGE_TOKEN).toString()));
        }
    }

    public static StockQuotesResp fromJson(String jsonString) throws IOException {
        return (StockQuotesResp)JSON.getGson().fromJson(jsonString, StockQuotesResp.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_QUOTES);
        openapiFields.add(SERIALIZED_NAME_CURRENCY);
        openapiFields.add(SERIALIZED_NAME_NEXT_PAGE_TOKEN);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_QUOTES);
        openapiRequiredFields.add(SERIALIZED_NAME_NEXT_PAGE_TOKEN);
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!StockQuotesResp.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StockQuotesResp.class));
            return new TypeAdapter<StockQuotesResp>(){

                public void write(JsonWriter out, StockQuotesResp value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public StockQuotesResp read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    StockQuotesResp.validateJsonElement(jsonElement);
                    return (StockQuotesResp)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

