/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.marketdata.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.marketdata.JSON;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockQuote;

public class StockQuotesRespSingle {
    public static final String SERIALIZED_NAME_SYMBOL = "symbol";
    @SerializedName(value="symbol")
    private String symbol;
    public static final String SERIALIZED_NAME_QUOTES = "quotes";
    @SerializedName(value="quotes")
    private List<StockQuote> quotes = new ArrayList<StockQuote>();
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_NEXT_PAGE_TOKEN = "next_page_token";
    @SerializedName(value="next_page_token")
    private String nextPageToken;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public StockQuotesRespSingle symbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Nonnull
    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public StockQuotesRespSingle quotes(List<StockQuote> quotes) {
        this.quotes = quotes;
        return this;
    }

    public StockQuotesRespSingle addQuotesItem(StockQuote quotesItem) {
        if (this.quotes == null) {
            this.quotes = new ArrayList<StockQuote>();
        }
        this.quotes.add(quotesItem);
        return this;
    }

    @Nonnull
    public List<StockQuote> getQuotes() {
        return this.quotes;
    }

    public void setQuotes(List<StockQuote> quotes) {
        this.quotes = quotes;
    }

    public StockQuotesRespSingle currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public StockQuotesRespSingle nextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
        return this;
    }

    @Nullable
    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StockQuotesRespSingle stockQuotesRespSingle = (StockQuotesRespSingle)o;
        return Objects.equals(this.symbol, stockQuotesRespSingle.symbol) && Objects.equals(this.quotes, stockQuotesRespSingle.quotes) && Objects.equals(this.currency, stockQuotesRespSingle.currency) && Objects.equals(this.nextPageToken, stockQuotesRespSingle.nextPageToken);
    }

    public int hashCode() {
        return Objects.hash(this.symbol, this.quotes, this.currency, this.nextPageToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StockQuotesRespSingle {\n");
        sb.append("    symbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("    quotes: ").append(this.toIndentedString(this.quotes)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    nextPageToken: ").append(this.toIndentedString(this.nextPageToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in StockQuotesRespSingle is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `StockQuotesRespSingle` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_SYMBOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SYMBOL).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_QUOTES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `quotes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_QUOTES).toString()));
        }
        JsonArray jsonArrayquotes = jsonObj.getAsJsonArray(SERIALIZED_NAME_QUOTES);
        for (int i = 0; i < jsonArrayquotes.size(); ++i) {
            StockQuote.validateJsonElement(jsonArrayquotes.get(i));
        }
        if (jsonObj.get(SERIALIZED_NAME_CURRENCY) != null && !jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENCY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NEXT_PAGE_TOKEN) != null && !jsonObj.get(SERIALIZED_NAME_NEXT_PAGE_TOKEN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NEXT_PAGE_TOKEN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `next_page_token` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NEXT_PAGE_TOKEN).toString()));
        }
    }

    public static StockQuotesRespSingle fromJson(String jsonString) throws IOException {
        return (StockQuotesRespSingle)JSON.getGson().fromJson(jsonString, StockQuotesRespSingle.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_SYMBOL);
        openapiFields.add(SERIALIZED_NAME_QUOTES);
        openapiFields.add(SERIALIZED_NAME_CURRENCY);
        openapiFields.add(SERIALIZED_NAME_NEXT_PAGE_TOKEN);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_SYMBOL);
        openapiRequiredFields.add(SERIALIZED_NAME_QUOTES);
        openapiRequiredFields.add(SERIALIZED_NAME_NEXT_PAGE_TOKEN);
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!StockQuotesRespSingle.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StockQuotesRespSingle.class));
            return new TypeAdapter<StockQuotesRespSingle>(){

                public void write(JsonWriter out, StockQuotesRespSingle value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public StockQuotesRespSingle read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    StockQuotesRespSingle.validateJsonElement(jsonElement);
                    return (StockQuotesRespSingle)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

