/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.marketdata.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.marketdata.JSON;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockBar;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockQuote;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockTrade;

public class StockSnapshot {
    public static final String SERIALIZED_NAME_DAILY_BAR = "dailyBar";
    @SerializedName(value="dailyBar")
    private StockBar dailyBar;
    public static final String SERIALIZED_NAME_LATEST_QUOTE = "latestQuote";
    @SerializedName(value="latestQuote")
    private StockQuote latestQuote;
    public static final String SERIALIZED_NAME_LATEST_TRADE = "latestTrade";
    @SerializedName(value="latestTrade")
    private StockTrade latestTrade;
    public static final String SERIALIZED_NAME_MINUTE_BAR = "minuteBar";
    @SerializedName(value="minuteBar")
    private StockBar minuteBar;
    public static final String SERIALIZED_NAME_PREV_DAILY_BAR = "prevDailyBar";
    @SerializedName(value="prevDailyBar")
    private StockBar prevDailyBar;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public StockSnapshot dailyBar(StockBar dailyBar) {
        this.dailyBar = dailyBar;
        return this;
    }

    @Nullable
    public StockBar getDailyBar() {
        return this.dailyBar;
    }

    public void setDailyBar(StockBar dailyBar) {
        this.dailyBar = dailyBar;
    }

    public StockSnapshot latestQuote(StockQuote latestQuote) {
        this.latestQuote = latestQuote;
        return this;
    }

    @Nullable
    public StockQuote getLatestQuote() {
        return this.latestQuote;
    }

    public void setLatestQuote(StockQuote latestQuote) {
        this.latestQuote = latestQuote;
    }

    public StockSnapshot latestTrade(StockTrade latestTrade) {
        this.latestTrade = latestTrade;
        return this;
    }

    @Nullable
    public StockTrade getLatestTrade() {
        return this.latestTrade;
    }

    public void setLatestTrade(StockTrade latestTrade) {
        this.latestTrade = latestTrade;
    }

    public StockSnapshot minuteBar(StockBar minuteBar) {
        this.minuteBar = minuteBar;
        return this;
    }

    @Nullable
    public StockBar getMinuteBar() {
        return this.minuteBar;
    }

    public void setMinuteBar(StockBar minuteBar) {
        this.minuteBar = minuteBar;
    }

    public StockSnapshot prevDailyBar(StockBar prevDailyBar) {
        this.prevDailyBar = prevDailyBar;
        return this;
    }

    @Nullable
    public StockBar getPrevDailyBar() {
        return this.prevDailyBar;
    }

    public void setPrevDailyBar(StockBar prevDailyBar) {
        this.prevDailyBar = prevDailyBar;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StockSnapshot stockSnapshot = (StockSnapshot)o;
        return Objects.equals(this.dailyBar, stockSnapshot.dailyBar) && Objects.equals(this.latestQuote, stockSnapshot.latestQuote) && Objects.equals(this.latestTrade, stockSnapshot.latestTrade) && Objects.equals(this.minuteBar, stockSnapshot.minuteBar) && Objects.equals(this.prevDailyBar, stockSnapshot.prevDailyBar);
    }

    public int hashCode() {
        return Objects.hash(this.dailyBar, this.latestQuote, this.latestTrade, this.minuteBar, this.prevDailyBar);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StockSnapshot {\n");
        sb.append("    dailyBar: ").append(this.toIndentedString(this.dailyBar)).append("\n");
        sb.append("    latestQuote: ").append(this.toIndentedString(this.latestQuote)).append("\n");
        sb.append("    latestTrade: ").append(this.toIndentedString(this.latestTrade)).append("\n");
        sb.append("    minuteBar: ").append(this.toIndentedString(this.minuteBar)).append("\n");
        sb.append("    prevDailyBar: ").append(this.toIndentedString(this.prevDailyBar)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in StockSnapshot is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `StockSnapshot` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_DAILY_BAR) != null && !jsonObj.get(SERIALIZED_NAME_DAILY_BAR).isJsonNull()) {
            StockBar.validateJsonElement(jsonObj.get(SERIALIZED_NAME_DAILY_BAR));
        }
        if (jsonObj.get(SERIALIZED_NAME_LATEST_QUOTE) != null && !jsonObj.get(SERIALIZED_NAME_LATEST_QUOTE).isJsonNull()) {
            StockQuote.validateJsonElement(jsonObj.get(SERIALIZED_NAME_LATEST_QUOTE));
        }
        if (jsonObj.get(SERIALIZED_NAME_LATEST_TRADE) != null && !jsonObj.get(SERIALIZED_NAME_LATEST_TRADE).isJsonNull()) {
            StockTrade.validateJsonElement(jsonObj.get(SERIALIZED_NAME_LATEST_TRADE));
        }
        if (jsonObj.get(SERIALIZED_NAME_MINUTE_BAR) != null && !jsonObj.get(SERIALIZED_NAME_MINUTE_BAR).isJsonNull()) {
            StockBar.validateJsonElement(jsonObj.get(SERIALIZED_NAME_MINUTE_BAR));
        }
        if (jsonObj.get(SERIALIZED_NAME_PREV_DAILY_BAR) != null && !jsonObj.get(SERIALIZED_NAME_PREV_DAILY_BAR).isJsonNull()) {
            StockBar.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PREV_DAILY_BAR));
        }
    }

    public static StockSnapshot fromJson(String jsonString) throws IOException {
        return (StockSnapshot)JSON.getGson().fromJson(jsonString, StockSnapshot.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DAILY_BAR);
        openapiFields.add(SERIALIZED_NAME_LATEST_QUOTE);
        openapiFields.add(SERIALIZED_NAME_LATEST_TRADE);
        openapiFields.add(SERIALIZED_NAME_MINUTE_BAR);
        openapiFields.add(SERIALIZED_NAME_PREV_DAILY_BAR);
        openapiRequiredFields = new HashSet();
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!StockSnapshot.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StockSnapshot.class));
            return new TypeAdapter<StockSnapshot>(){

                public void write(JsonWriter out, StockSnapshot value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public StockSnapshot read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    StockSnapshot.validateJsonElement(jsonElement);
                    return (StockSnapshot)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

