/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.marketdata.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.function.Predicate;

@JsonAdapter(value=Adapter.class)
public enum StockTape {
    A("A"),
    B("B"),
    C("C"),
    O("O");

    private String value;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    private StockTape(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StockTape fromValue(String value) {
        for (StockTape b : StockTape.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        return null;
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        String value = jsonElement.getAsString();
        StockTape.fromValue(value);
    }

    static {
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class Adapter
    extends TypeAdapter<StockTape> {
        public void write(JsonWriter jsonWriter, StockTape enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public StockTape read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return StockTape.fromValue(value);
        }
    }
}

