/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.marketdata.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.jacobpeterson.alpaca.openapi.marketdata.JSON;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockTape;

public class StockTrade {
    public static final String SERIALIZED_NAME_T = "t";
    @SerializedName(value="t")
    private OffsetDateTime t;
    public static final String SERIALIZED_NAME_X = "x";
    @SerializedName(value="x")
    private String x;
    public static final String SERIALIZED_NAME_P = "p";
    @SerializedName(value="p")
    private Double p;
    public static final String SERIALIZED_NAME_S = "s";
    @SerializedName(value="s")
    private Integer s;
    public static final String SERIALIZED_NAME_I = "i";
    @SerializedName(value="i")
    private Integer i;
    public static final String SERIALIZED_NAME_C = "c";
    @SerializedName(value="c")
    private List<String> c = new ArrayList<String>();
    public static final String SERIALIZED_NAME_Z = "z";
    @SerializedName(value="z")
    private StockTape z;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public StockTrade t(OffsetDateTime t) {
        this.t = t;
        return this;
    }

    @Nonnull
    public OffsetDateTime getT() {
        return this.t;
    }

    public void setT(OffsetDateTime t) {
        this.t = t;
    }

    public StockTrade x(String x) {
        this.x = x;
        return this;
    }

    @Nonnull
    public String getX() {
        return this.x;
    }

    public void setX(String x) {
        this.x = x;
    }

    public StockTrade p(Double p) {
        this.p = p;
        return this;
    }

    @Nonnull
    public Double getP() {
        return this.p;
    }

    public void setP(Double p) {
        this.p = p;
    }

    public StockTrade s(Integer s) {
        this.s = s;
        return this;
    }

    @Nonnull
    public Integer getS() {
        return this.s;
    }

    public void setS(Integer s) {
        this.s = s;
    }

    public StockTrade i(Integer i) {
        this.i = i;
        return this;
    }

    @Nonnull
    public Integer getI() {
        return this.i;
    }

    public void setI(Integer i) {
        this.i = i;
    }

    public StockTrade c(List<String> c) {
        this.c = c;
        return this;
    }

    public StockTrade addCItem(String cItem) {
        if (this.c == null) {
            this.c = new ArrayList<String>();
        }
        this.c.add(cItem);
        return this;
    }

    @Nonnull
    public List<String> getC() {
        return this.c;
    }

    public void setC(List<String> c) {
        this.c = c;
    }

    public StockTrade z(StockTape z) {
        this.z = z;
        return this;
    }

    @Nonnull
    public StockTape getZ() {
        return this.z;
    }

    public void setZ(StockTape z) {
        this.z = z;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StockTrade stockTrade = (StockTrade)o;
        return Objects.equals(this.t, stockTrade.t) && Objects.equals(this.x, stockTrade.x) && Objects.equals(this.p, stockTrade.p) && Objects.equals(this.s, stockTrade.s) && Objects.equals(this.i, stockTrade.i) && Objects.equals(this.c, stockTrade.c) && Objects.equals((Object)this.z, (Object)stockTrade.z);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.t, this.x, this.p, this.s, this.i, this.c, this.z});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StockTrade {\n");
        sb.append("    t: ").append(this.toIndentedString(this.t)).append("\n");
        sb.append("    x: ").append(this.toIndentedString(this.x)).append("\n");
        sb.append("    p: ").append(this.toIndentedString(this.p)).append("\n");
        sb.append("    s: ").append(this.toIndentedString(this.s)).append("\n");
        sb.append("    i: ").append(this.toIndentedString(this.i)).append("\n");
        sb.append("    c: ").append(this.toIndentedString(this.c)).append("\n");
        sb.append("    z: ").append(this.toIndentedString((Object)this.z)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in StockTrade is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `StockTrade` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_X).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `x` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_X).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_C) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_C).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `c` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_C).toString()));
        }
        StockTape.validateJsonElement(jsonObj.get(SERIALIZED_NAME_Z));
    }

    public static StockTrade fromJson(String jsonString) throws IOException {
        return (StockTrade)JSON.getGson().fromJson(jsonString, StockTrade.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_T);
        openapiFields.add(SERIALIZED_NAME_X);
        openapiFields.add(SERIALIZED_NAME_P);
        openapiFields.add(SERIALIZED_NAME_S);
        openapiFields.add(SERIALIZED_NAME_I);
        openapiFields.add(SERIALIZED_NAME_C);
        openapiFields.add(SERIALIZED_NAME_Z);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_T);
        openapiRequiredFields.add(SERIALIZED_NAME_X);
        openapiRequiredFields.add(SERIALIZED_NAME_P);
        openapiRequiredFields.add(SERIALIZED_NAME_S);
        openapiRequiredFields.add(SERIALIZED_NAME_I);
        openapiRequiredFields.add(SERIALIZED_NAME_C);
        openapiRequiredFields.add(SERIALIZED_NAME_Z);
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!StockTrade.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StockTrade.class));
            return new TypeAdapter<StockTrade>(){

                public void write(JsonWriter out, StockTrade value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public StockTrade read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    StockTrade.validateJsonElement(jsonElement);
                    return (StockTrade)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

