/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.trader.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.jacobpeterson.alpaca.openapi.trader.ApiCallback;
import net.jacobpeterson.alpaca.openapi.trader.ApiClient;
import net.jacobpeterson.alpaca.openapi.trader.ApiException;
import net.jacobpeterson.alpaca.openapi.trader.ApiResponse;
import net.jacobpeterson.alpaca.openapi.trader.Configuration;
import net.jacobpeterson.alpaca.openapi.trader.Pair;
import net.jacobpeterson.alpaca.openapi.trader.model.GetAccountActivities200ResponseInner;
import net.jacobpeterson.alpaca.openapi.trader.model.GetAccountActivitiesByActivityType200ResponseInner;
import okhttp3.Call;

public class AccountActivitiesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AccountActivitiesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AccountActivitiesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    protected Call getAccountActivitiesCall(String activityTypes, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/account/activities";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (activityTypes != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("activity_types", activityTypes));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccountActivitiesValidateBeforeCall(String activityTypes, ApiCallback _callback) throws ApiException {
        return this.getAccountActivitiesCall(activityTypes, _callback);
    }

    public List<GetAccountActivities200ResponseInner> getAccountActivities(String activityTypes) throws ApiException {
        ApiResponse<List<GetAccountActivities200ResponseInner>> localVarResp = this.getAccountActivitiesWithHttpInfo(activityTypes);
        return localVarResp.getData();
    }

    protected ApiResponse<List<GetAccountActivities200ResponseInner>> getAccountActivitiesWithHttpInfo(String activityTypes) throws ApiException {
        Call localVarCall = this.getAccountActivitiesValidateBeforeCall(activityTypes, null);
        Type localVarReturnType = new TypeToken<List<GetAccountActivities200ResponseInner>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getAccountActivitiesAsync(String activityTypes, ApiCallback<List<GetAccountActivities200ResponseInner>> _callback) throws ApiException {
        Call localVarCall = this.getAccountActivitiesValidateBeforeCall(activityTypes, _callback);
        Type localVarReturnType = new TypeToken<List<GetAccountActivities200ResponseInner>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getAccountActivitiesByActivityTypeCall(String activityType, OffsetDateTime date, OffsetDateTime until, OffsetDateTime after, String direction, Integer pageSize, String pageToken, String category, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/account/activities/{activity_type}".replace("{activity_type}", this.localVarApiClient.escapeString(activityType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (date != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("date", date));
        }
        if (until != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("until", until));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (direction != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("direction", direction));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (pageToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_token", pageToken));
        }
        if (category != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("category", category));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccountActivitiesByActivityTypeValidateBeforeCall(String activityType, OffsetDateTime date, OffsetDateTime until, OffsetDateTime after, String direction, Integer pageSize, String pageToken, String category, ApiCallback _callback) throws ApiException {
        if (activityType == null) {
            throw new ApiException("Missing the required parameter 'activityType' when calling getAccountActivitiesByActivityType(Async)");
        }
        return this.getAccountActivitiesByActivityTypeCall(activityType, date, until, after, direction, pageSize, pageToken, category, _callback);
    }

    public List<GetAccountActivitiesByActivityType200ResponseInner> getAccountActivitiesByActivityType(String activityType, OffsetDateTime date, OffsetDateTime until, OffsetDateTime after, String direction, Integer pageSize, String pageToken, String category) throws ApiException {
        ApiResponse<List<GetAccountActivitiesByActivityType200ResponseInner>> localVarResp = this.getAccountActivitiesByActivityTypeWithHttpInfo(activityType, date, until, after, direction, pageSize, pageToken, category);
        return localVarResp.getData();
    }

    protected ApiResponse<List<GetAccountActivitiesByActivityType200ResponseInner>> getAccountActivitiesByActivityTypeWithHttpInfo(String activityType, OffsetDateTime date, OffsetDateTime until, OffsetDateTime after, String direction, Integer pageSize, String pageToken, String category) throws ApiException {
        Call localVarCall = this.getAccountActivitiesByActivityTypeValidateBeforeCall(activityType, date, until, after, direction, pageSize, pageToken, category, null);
        Type localVarReturnType = new TypeToken<List<GetAccountActivitiesByActivityType200ResponseInner>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getAccountActivitiesByActivityTypeAsync(String activityType, OffsetDateTime date, OffsetDateTime until, OffsetDateTime after, String direction, Integer pageSize, String pageToken, String category, ApiCallback<List<GetAccountActivitiesByActivityType200ResponseInner>> _callback) throws ApiException {
        Call localVarCall = this.getAccountActivitiesByActivityTypeValidateBeforeCall(activityType, date, until, after, direction, pageSize, pageToken, category, _callback);
        Type localVarReturnType = new TypeToken<List<GetAccountActivitiesByActivityType200ResponseInner>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

