/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.trader.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.jacobpeterson.alpaca.openapi.trader.ApiCallback;
import net.jacobpeterson.alpaca.openapi.trader.ApiClient;
import net.jacobpeterson.alpaca.openapi.trader.ApiException;
import net.jacobpeterson.alpaca.openapi.trader.ApiResponse;
import net.jacobpeterson.alpaca.openapi.trader.Configuration;
import net.jacobpeterson.alpaca.openapi.trader.Pair;
import net.jacobpeterson.alpaca.openapi.trader.model.Assets;
import net.jacobpeterson.alpaca.openapi.trader.model.GetOptionsContracts200Response;
import net.jacobpeterson.alpaca.openapi.trader.model.OptionContract;
import okhttp3.Call;

public class AssetsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AssetsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AssetsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    protected Call getOptionContractSymbolOrIdCall(String symbolOrId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/options/contracts/{symbol_or_id}".replace("{symbol_or_id}", this.localVarApiClient.escapeString(symbolOrId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOptionContractSymbolOrIdValidateBeforeCall(String symbolOrId, ApiCallback _callback) throws ApiException {
        if (symbolOrId == null) {
            throw new ApiException("Missing the required parameter 'symbolOrId' when calling getOptionContractSymbolOrId(Async)");
        }
        return this.getOptionContractSymbolOrIdCall(symbolOrId, _callback);
    }

    public OptionContract getOptionContractSymbolOrId(String symbolOrId) throws ApiException {
        ApiResponse<OptionContract> localVarResp = this.getOptionContractSymbolOrIdWithHttpInfo(symbolOrId);
        return localVarResp.getData();
    }

    protected ApiResponse<OptionContract> getOptionContractSymbolOrIdWithHttpInfo(String symbolOrId) throws ApiException {
        Call localVarCall = this.getOptionContractSymbolOrIdValidateBeforeCall(symbolOrId, null);
        Type localVarReturnType = new TypeToken<OptionContract>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getOptionContractSymbolOrIdAsync(String symbolOrId, ApiCallback<OptionContract> _callback) throws ApiException {
        Call localVarCall = this.getOptionContractSymbolOrIdValidateBeforeCall(symbolOrId, _callback);
        Type localVarReturnType = new TypeToken<OptionContract>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getOptionsContractsCall(String underlyingSymbols, String status, LocalDate expirationDate, LocalDate expirationDateGte, LocalDate expirationDateLte, String rootSymbol, String type, String style, BigDecimal strikePriceGte, BigDecimal strikePriceLte, String pageToken, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/options/contracts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (underlyingSymbols != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("underlying_symbols", underlyingSymbols));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if (expirationDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expiration_date", expirationDate));
        }
        if (expirationDateGte != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expiration_date_gte", expirationDateGte));
        }
        if (expirationDateLte != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expiration_date_lte", expirationDateLte));
        }
        if (rootSymbol != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("root_symbol", rootSymbol));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (style != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("style", style));
        }
        if (strikePriceGte != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("strike_price_gte", strikePriceGte));
        }
        if (strikePriceLte != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("strike_price_lte", strikePriceLte));
        }
        if (pageToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_token", pageToken));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOptionsContractsValidateBeforeCall(String underlyingSymbols, String status, LocalDate expirationDate, LocalDate expirationDateGte, LocalDate expirationDateLte, String rootSymbol, String type, String style, BigDecimal strikePriceGte, BigDecimal strikePriceLte, String pageToken, Integer limit, ApiCallback _callback) throws ApiException {
        return this.getOptionsContractsCall(underlyingSymbols, status, expirationDate, expirationDateGte, expirationDateLte, rootSymbol, type, style, strikePriceGte, strikePriceLte, pageToken, limit, _callback);
    }

    public GetOptionsContracts200Response getOptionsContracts(String underlyingSymbols, String status, LocalDate expirationDate, LocalDate expirationDateGte, LocalDate expirationDateLte, String rootSymbol, String type, String style, BigDecimal strikePriceGte, BigDecimal strikePriceLte, String pageToken, Integer limit) throws ApiException {
        ApiResponse<GetOptionsContracts200Response> localVarResp = this.getOptionsContractsWithHttpInfo(underlyingSymbols, status, expirationDate, expirationDateGte, expirationDateLte, rootSymbol, type, style, strikePriceGte, strikePriceLte, pageToken, limit);
        return localVarResp.getData();
    }

    protected ApiResponse<GetOptionsContracts200Response> getOptionsContractsWithHttpInfo(String underlyingSymbols, String status, LocalDate expirationDate, LocalDate expirationDateGte, LocalDate expirationDateLte, String rootSymbol, String type, String style, BigDecimal strikePriceGte, BigDecimal strikePriceLte, String pageToken, Integer limit) throws ApiException {
        Call localVarCall = this.getOptionsContractsValidateBeforeCall(underlyingSymbols, status, expirationDate, expirationDateGte, expirationDateLte, rootSymbol, type, style, strikePriceGte, strikePriceLte, pageToken, limit, null);
        Type localVarReturnType = new TypeToken<GetOptionsContracts200Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getOptionsContractsAsync(String underlyingSymbols, String status, LocalDate expirationDate, LocalDate expirationDateGte, LocalDate expirationDateLte, String rootSymbol, String type, String style, BigDecimal strikePriceGte, BigDecimal strikePriceLte, String pageToken, Integer limit, ApiCallback<GetOptionsContracts200Response> _callback) throws ApiException {
        Call localVarCall = this.getOptionsContractsValidateBeforeCall(underlyingSymbols, status, expirationDate, expirationDateGte, expirationDateLte, rootSymbol, type, style, strikePriceGte, strikePriceLte, pageToken, limit, _callback);
        Type localVarReturnType = new TypeToken<GetOptionsContracts200Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getV2AssetsCall(String status, String assetClass, String exchange, List<String> attributes, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/assets";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if (assetClass != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("asset_class", assetClass));
        }
        if (exchange != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("exchange", exchange));
        }
        if (attributes != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "attributes", attributes));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getV2AssetsValidateBeforeCall(String status, String assetClass, String exchange, List<String> attributes, ApiCallback _callback) throws ApiException {
        return this.getV2AssetsCall(status, assetClass, exchange, attributes, _callback);
    }

    public List<Assets> getV2Assets(String status, String assetClass, String exchange, List<String> attributes) throws ApiException {
        ApiResponse<List<Assets>> localVarResp = this.getV2AssetsWithHttpInfo(status, assetClass, exchange, attributes);
        return localVarResp.getData();
    }

    protected ApiResponse<List<Assets>> getV2AssetsWithHttpInfo(String status, String assetClass, String exchange, List<String> attributes) throws ApiException {
        Call localVarCall = this.getV2AssetsValidateBeforeCall(status, assetClass, exchange, attributes, null);
        Type localVarReturnType = new TypeToken<List<Assets>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getV2AssetsAsync(String status, String assetClass, String exchange, List<String> attributes, ApiCallback<List<Assets>> _callback) throws ApiException {
        Call localVarCall = this.getV2AssetsValidateBeforeCall(status, assetClass, exchange, attributes, _callback);
        Type localVarReturnType = new TypeToken<List<Assets>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getV2AssetsSymbolOrAssetIdCall(String symbolOrAssetId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/assets/{symbol_or_asset_id}".replace("{symbol_or_asset_id}", this.localVarApiClient.escapeString(symbolOrAssetId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getV2AssetsSymbolOrAssetIdValidateBeforeCall(String symbolOrAssetId, ApiCallback _callback) throws ApiException {
        if (symbolOrAssetId == null) {
            throw new ApiException("Missing the required parameter 'symbolOrAssetId' when calling getV2AssetsSymbolOrAssetId(Async)");
        }
        return this.getV2AssetsSymbolOrAssetIdCall(symbolOrAssetId, _callback);
    }

    public Assets getV2AssetsSymbolOrAssetId(String symbolOrAssetId) throws ApiException {
        ApiResponse<Assets> localVarResp = this.getV2AssetsSymbolOrAssetIdWithHttpInfo(symbolOrAssetId);
        return localVarResp.getData();
    }

    protected ApiResponse<Assets> getV2AssetsSymbolOrAssetIdWithHttpInfo(String symbolOrAssetId) throws ApiException {
        Call localVarCall = this.getV2AssetsSymbolOrAssetIdValidateBeforeCall(symbolOrAssetId, null);
        Type localVarReturnType = new TypeToken<Assets>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getV2AssetsSymbolOrAssetIdAsync(String symbolOrAssetId, ApiCallback<Assets> _callback) throws ApiException {
        Call localVarCall = this.getV2AssetsSymbolOrAssetIdValidateBeforeCall(symbolOrAssetId, _callback);
        Type localVarReturnType = new TypeToken<Assets>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

