/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.trader.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.jacobpeterson.alpaca.openapi.trader.ApiCallback;
import net.jacobpeterson.alpaca.openapi.trader.ApiClient;
import net.jacobpeterson.alpaca.openapi.trader.ApiException;
import net.jacobpeterson.alpaca.openapi.trader.ApiResponse;
import net.jacobpeterson.alpaca.openapi.trader.Configuration;
import net.jacobpeterson.alpaca.openapi.trader.Pair;
import net.jacobpeterson.alpaca.openapi.trader.model.Calendar;
import okhttp3.Call;

public class CalendarApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public CalendarApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CalendarApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    protected Call getCalendarCall(OffsetDateTime start, OffsetDateTime end, String dateType, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/calendar";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (start != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start", start));
        }
        if (end != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end", end));
        }
        if (dateType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("date_type", dateType));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCalendarValidateBeforeCall(OffsetDateTime start, OffsetDateTime end, String dateType, ApiCallback _callback) throws ApiException {
        return this.getCalendarCall(start, end, dateType, _callback);
    }

    public List<Calendar> getCalendar(OffsetDateTime start, OffsetDateTime end, String dateType) throws ApiException {
        ApiResponse<List<Calendar>> localVarResp = this.getCalendarWithHttpInfo(start, end, dateType);
        return localVarResp.getData();
    }

    protected ApiResponse<List<Calendar>> getCalendarWithHttpInfo(OffsetDateTime start, OffsetDateTime end, String dateType) throws ApiException {
        Call localVarCall = this.getCalendarValidateBeforeCall(start, end, dateType, null);
        Type localVarReturnType = new TypeToken<List<Calendar>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getCalendarAsync(OffsetDateTime start, OffsetDateTime end, String dateType, ApiCallback<List<Calendar>> _callback) throws ApiException {
        Call localVarCall = this.getCalendarValidateBeforeCall(start, end, dateType, _callback);
        Type localVarReturnType = new TypeToken<List<Calendar>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

