/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.trader.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import net.jacobpeterson.alpaca.openapi.trader.ApiCallback;
import net.jacobpeterson.alpaca.openapi.trader.ApiClient;
import net.jacobpeterson.alpaca.openapi.trader.ApiException;
import net.jacobpeterson.alpaca.openapi.trader.ApiResponse;
import net.jacobpeterson.alpaca.openapi.trader.Configuration;
import net.jacobpeterson.alpaca.openapi.trader.Pair;
import net.jacobpeterson.alpaca.openapi.trader.model.CreateCryptoTransferRequest;
import net.jacobpeterson.alpaca.openapi.trader.model.CreateWhitelistedAddressRequest;
import net.jacobpeterson.alpaca.openapi.trader.model.CryptoTransfer;
import net.jacobpeterson.alpaca.openapi.trader.model.CryptoWallet;
import net.jacobpeterson.alpaca.openapi.trader.model.GetCryptoTransferEstimate200Response;
import net.jacobpeterson.alpaca.openapi.trader.model.WhitelistedAddress;
import okhttp3.Call;

public class CryptoFundingApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public CryptoFundingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CryptoFundingApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    protected Call createCryptoTransferForAccountCall(CreateCryptoTransferRequest createCryptoTransferRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateCryptoTransferRequest localVarPostBody = createCryptoTransferRequest;
        String localVarPath = "/v2/wallets/transfers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createCryptoTransferForAccountValidateBeforeCall(CreateCryptoTransferRequest createCryptoTransferRequest, ApiCallback _callback) throws ApiException {
        if (createCryptoTransferRequest == null) {
            throw new ApiException("Missing the required parameter 'createCryptoTransferRequest' when calling createCryptoTransferForAccount(Async)");
        }
        return this.createCryptoTransferForAccountCall(createCryptoTransferRequest, _callback);
    }

    public CryptoTransfer createCryptoTransferForAccount(CreateCryptoTransferRequest createCryptoTransferRequest) throws ApiException {
        ApiResponse<CryptoTransfer> localVarResp = this.createCryptoTransferForAccountWithHttpInfo(createCryptoTransferRequest);
        return localVarResp.getData();
    }

    protected ApiResponse<CryptoTransfer> createCryptoTransferForAccountWithHttpInfo(CreateCryptoTransferRequest createCryptoTransferRequest) throws ApiException {
        Call localVarCall = this.createCryptoTransferForAccountValidateBeforeCall(createCryptoTransferRequest, null);
        Type localVarReturnType = new TypeToken<CryptoTransfer>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call createCryptoTransferForAccountAsync(CreateCryptoTransferRequest createCryptoTransferRequest, ApiCallback<CryptoTransfer> _callback) throws ApiException {
        Call localVarCall = this.createCryptoTransferForAccountValidateBeforeCall(createCryptoTransferRequest, _callback);
        Type localVarReturnType = new TypeToken<CryptoTransfer>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call createWhitelistedAddressCall(CreateWhitelistedAddressRequest createWhitelistedAddressRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateWhitelistedAddressRequest localVarPostBody = createWhitelistedAddressRequest;
        String localVarPath = "/v2/wallets/whitelists";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createWhitelistedAddressValidateBeforeCall(CreateWhitelistedAddressRequest createWhitelistedAddressRequest, ApiCallback _callback) throws ApiException {
        if (createWhitelistedAddressRequest == null) {
            throw new ApiException("Missing the required parameter 'createWhitelistedAddressRequest' when calling createWhitelistedAddress(Async)");
        }
        return this.createWhitelistedAddressCall(createWhitelistedAddressRequest, _callback);
    }

    public WhitelistedAddress createWhitelistedAddress(CreateWhitelistedAddressRequest createWhitelistedAddressRequest) throws ApiException {
        ApiResponse<WhitelistedAddress> localVarResp = this.createWhitelistedAddressWithHttpInfo(createWhitelistedAddressRequest);
        return localVarResp.getData();
    }

    protected ApiResponse<WhitelistedAddress> createWhitelistedAddressWithHttpInfo(CreateWhitelistedAddressRequest createWhitelistedAddressRequest) throws ApiException {
        Call localVarCall = this.createWhitelistedAddressValidateBeforeCall(createWhitelistedAddressRequest, null);
        Type localVarReturnType = new TypeToken<WhitelistedAddress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call createWhitelistedAddressAsync(CreateWhitelistedAddressRequest createWhitelistedAddressRequest, ApiCallback<WhitelistedAddress> _callback) throws ApiException {
        Call localVarCall = this.createWhitelistedAddressValidateBeforeCall(createWhitelistedAddressRequest, _callback);
        Type localVarReturnType = new TypeToken<WhitelistedAddress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call deleteWhitelistedAddressCall(String whitelistedAddressId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/wallets/whitelists/{whitelisted_address_id}".replace("{whitelisted_address_id}", this.localVarApiClient.escapeString(whitelistedAddressId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteWhitelistedAddressValidateBeforeCall(String whitelistedAddressId, ApiCallback _callback) throws ApiException {
        if (whitelistedAddressId == null) {
            throw new ApiException("Missing the required parameter 'whitelistedAddressId' when calling deleteWhitelistedAddress(Async)");
        }
        return this.deleteWhitelistedAddressCall(whitelistedAddressId, _callback);
    }

    public void deleteWhitelistedAddress(String whitelistedAddressId) throws ApiException {
        this.deleteWhitelistedAddressWithHttpInfo(whitelistedAddressId);
    }

    protected ApiResponse<Void> deleteWhitelistedAddressWithHttpInfo(String whitelistedAddressId) throws ApiException {
        Call localVarCall = this.deleteWhitelistedAddressValidateBeforeCall(whitelistedAddressId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    protected Call deleteWhitelistedAddressAsync(String whitelistedAddressId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteWhitelistedAddressValidateBeforeCall(whitelistedAddressId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    protected Call getCryptoFundingTransferCall(String transferId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/wallets/transfers/{transfer_id}".replace("{transfer_id}", this.localVarApiClient.escapeString(transferId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCryptoFundingTransferValidateBeforeCall(String transferId, ApiCallback _callback) throws ApiException {
        if (transferId == null) {
            throw new ApiException("Missing the required parameter 'transferId' when calling getCryptoFundingTransfer(Async)");
        }
        return this.getCryptoFundingTransferCall(transferId, _callback);
    }

    public CryptoTransfer getCryptoFundingTransfer(String transferId) throws ApiException {
        ApiResponse<CryptoTransfer> localVarResp = this.getCryptoFundingTransferWithHttpInfo(transferId);
        return localVarResp.getData();
    }

    protected ApiResponse<CryptoTransfer> getCryptoFundingTransferWithHttpInfo(String transferId) throws ApiException {
        Call localVarCall = this.getCryptoFundingTransferValidateBeforeCall(transferId, null);
        Type localVarReturnType = new TypeToken<CryptoTransfer>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getCryptoFundingTransferAsync(String transferId, ApiCallback<CryptoTransfer> _callback) throws ApiException {
        Call localVarCall = this.getCryptoFundingTransferValidateBeforeCall(transferId, _callback);
        Type localVarReturnType = new TypeToken<CryptoTransfer>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getCryptoTransferEstimateCall(String asset, String fromAddress, String toAddress, String amount, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/wallets/fees/estimate";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (asset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("asset", asset));
        }
        if (fromAddress != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from_address", fromAddress));
        }
        if (toAddress != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to_address", toAddress));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCryptoTransferEstimateValidateBeforeCall(String asset, String fromAddress, String toAddress, String amount, ApiCallback _callback) throws ApiException {
        return this.getCryptoTransferEstimateCall(asset, fromAddress, toAddress, amount, _callback);
    }

    public GetCryptoTransferEstimate200Response getCryptoTransferEstimate(String asset, String fromAddress, String toAddress, String amount) throws ApiException {
        ApiResponse<GetCryptoTransferEstimate200Response> localVarResp = this.getCryptoTransferEstimateWithHttpInfo(asset, fromAddress, toAddress, amount);
        return localVarResp.getData();
    }

    protected ApiResponse<GetCryptoTransferEstimate200Response> getCryptoTransferEstimateWithHttpInfo(String asset, String fromAddress, String toAddress, String amount) throws ApiException {
        Call localVarCall = this.getCryptoTransferEstimateValidateBeforeCall(asset, fromAddress, toAddress, amount, null);
        Type localVarReturnType = new TypeToken<GetCryptoTransferEstimate200Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getCryptoTransferEstimateAsync(String asset, String fromAddress, String toAddress, String amount, ApiCallback<GetCryptoTransferEstimate200Response> _callback) throws ApiException {
        Call localVarCall = this.getCryptoTransferEstimateValidateBeforeCall(asset, fromAddress, toAddress, amount, _callback);
        Type localVarReturnType = new TypeToken<GetCryptoTransferEstimate200Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call listCryptoFundingTransfersCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/wallets/transfers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCryptoFundingTransfersValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.listCryptoFundingTransfersCall(_callback);
    }

    public CryptoTransfer listCryptoFundingTransfers() throws ApiException {
        ApiResponse<CryptoTransfer> localVarResp = this.listCryptoFundingTransfersWithHttpInfo();
        return localVarResp.getData();
    }

    protected ApiResponse<CryptoTransfer> listCryptoFundingTransfersWithHttpInfo() throws ApiException {
        Call localVarCall = this.listCryptoFundingTransfersValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<CryptoTransfer>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call listCryptoFundingTransfersAsync(ApiCallback<CryptoTransfer> _callback) throws ApiException {
        Call localVarCall = this.listCryptoFundingTransfersValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<CryptoTransfer>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call listCryptoFundingWalletsCall(String asset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/wallets";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (asset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("asset", asset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCryptoFundingWalletsValidateBeforeCall(String asset, ApiCallback _callback) throws ApiException {
        return this.listCryptoFundingWalletsCall(asset, _callback);
    }

    public CryptoWallet listCryptoFundingWallets(String asset) throws ApiException {
        ApiResponse<CryptoWallet> localVarResp = this.listCryptoFundingWalletsWithHttpInfo(asset);
        return localVarResp.getData();
    }

    protected ApiResponse<CryptoWallet> listCryptoFundingWalletsWithHttpInfo(String asset) throws ApiException {
        Call localVarCall = this.listCryptoFundingWalletsValidateBeforeCall(asset, null);
        Type localVarReturnType = new TypeToken<CryptoWallet>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call listCryptoFundingWalletsAsync(String asset, ApiCallback<CryptoWallet> _callback) throws ApiException {
        Call localVarCall = this.listCryptoFundingWalletsValidateBeforeCall(asset, _callback);
        Type localVarReturnType = new TypeToken<CryptoWallet>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call listWhitelistedAddressCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/wallets/whitelists";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listWhitelistedAddressValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.listWhitelistedAddressCall(_callback);
    }

    public WhitelistedAddress listWhitelistedAddress() throws ApiException {
        ApiResponse<WhitelistedAddress> localVarResp = this.listWhitelistedAddressWithHttpInfo();
        return localVarResp.getData();
    }

    protected ApiResponse<WhitelistedAddress> listWhitelistedAddressWithHttpInfo() throws ApiException {
        Call localVarCall = this.listWhitelistedAddressValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<WhitelistedAddress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call listWhitelistedAddressAsync(ApiCallback<WhitelistedAddress> _callback) throws ApiException {
        Call localVarCall = this.listWhitelistedAddressValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<WhitelistedAddress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

