/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.trader.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.trader.ApiCallback;
import net.jacobpeterson.alpaca.openapi.trader.ApiClient;
import net.jacobpeterson.alpaca.openapi.trader.ApiException;
import net.jacobpeterson.alpaca.openapi.trader.ApiResponse;
import net.jacobpeterson.alpaca.openapi.trader.Configuration;
import net.jacobpeterson.alpaca.openapi.trader.Pair;
import net.jacobpeterson.alpaca.openapi.trader.model.CanceledOrderResponse;
import net.jacobpeterson.alpaca.openapi.trader.model.Order;
import net.jacobpeterson.alpaca.openapi.trader.model.PatchOrderRequest;
import net.jacobpeterson.alpaca.openapi.trader.model.PostOrderRequest;
import okhttp3.Call;

public class OrdersApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public OrdersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OrdersApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    protected Call deleteAllOrdersCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteAllOrdersValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.deleteAllOrdersCall(_callback);
    }

    public List<CanceledOrderResponse> deleteAllOrders() throws ApiException {
        ApiResponse<List<CanceledOrderResponse>> localVarResp = this.deleteAllOrdersWithHttpInfo();
        return localVarResp.getData();
    }

    protected ApiResponse<List<CanceledOrderResponse>> deleteAllOrdersWithHttpInfo() throws ApiException {
        Call localVarCall = this.deleteAllOrdersValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<CanceledOrderResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call deleteAllOrdersAsync(ApiCallback<List<CanceledOrderResponse>> _callback) throws ApiException {
        Call localVarCall = this.deleteAllOrdersValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<CanceledOrderResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call deleteOrderByOrderIDCall(UUID orderId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/orders/{order_id}".replace("{order_id}", this.localVarApiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteOrderByOrderIDValidateBeforeCall(UUID orderId, ApiCallback _callback) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling deleteOrderByOrderID(Async)");
        }
        return this.deleteOrderByOrderIDCall(orderId, _callback);
    }

    public void deleteOrderByOrderID(UUID orderId) throws ApiException {
        this.deleteOrderByOrderIDWithHttpInfo(orderId);
    }

    protected ApiResponse<Void> deleteOrderByOrderIDWithHttpInfo(UUID orderId) throws ApiException {
        Call localVarCall = this.deleteOrderByOrderIDValidateBeforeCall(orderId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    protected Call deleteOrderByOrderIDAsync(UUID orderId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteOrderByOrderIDValidateBeforeCall(orderId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    protected Call getAllOrdersCall(String status, Integer limit, String after, String until, String direction, Boolean nested, String symbols, String side, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (until != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("until", until));
        }
        if (direction != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("direction", direction));
        }
        if (nested != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("nested", nested));
        }
        if (symbols != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbols", symbols));
        }
        if (side != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("side", side));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAllOrdersValidateBeforeCall(String status, Integer limit, String after, String until, String direction, Boolean nested, String symbols, String side, ApiCallback _callback) throws ApiException {
        return this.getAllOrdersCall(status, limit, after, until, direction, nested, symbols, side, _callback);
    }

    public List<Order> getAllOrders(String status, Integer limit, String after, String until, String direction, Boolean nested, String symbols, String side) throws ApiException {
        ApiResponse<List<Order>> localVarResp = this.getAllOrdersWithHttpInfo(status, limit, after, until, direction, nested, symbols, side);
        return localVarResp.getData();
    }

    protected ApiResponse<List<Order>> getAllOrdersWithHttpInfo(String status, Integer limit, String after, String until, String direction, Boolean nested, String symbols, String side) throws ApiException {
        Call localVarCall = this.getAllOrdersValidateBeforeCall(status, limit, after, until, direction, nested, symbols, side, null);
        Type localVarReturnType = new TypeToken<List<Order>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getAllOrdersAsync(String status, Integer limit, String after, String until, String direction, Boolean nested, String symbols, String side, ApiCallback<List<Order>> _callback) throws ApiException {
        Call localVarCall = this.getAllOrdersValidateBeforeCall(status, limit, after, until, direction, nested, symbols, side, _callback);
        Type localVarReturnType = new TypeToken<List<Order>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getOrderByOrderIDCall(UUID orderId, Boolean nested, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/orders/{order_id}".replace("{order_id}", this.localVarApiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (nested != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("nested", nested));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOrderByOrderIDValidateBeforeCall(UUID orderId, Boolean nested, ApiCallback _callback) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling getOrderByOrderID(Async)");
        }
        return this.getOrderByOrderIDCall(orderId, nested, _callback);
    }

    public Order getOrderByOrderID(UUID orderId, Boolean nested) throws ApiException {
        ApiResponse<Order> localVarResp = this.getOrderByOrderIDWithHttpInfo(orderId, nested);
        return localVarResp.getData();
    }

    protected ApiResponse<Order> getOrderByOrderIDWithHttpInfo(UUID orderId, Boolean nested) throws ApiException {
        Call localVarCall = this.getOrderByOrderIDValidateBeforeCall(orderId, nested, null);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getOrderByOrderIDAsync(UUID orderId, Boolean nested, ApiCallback<Order> _callback) throws ApiException {
        Call localVarCall = this.getOrderByOrderIDValidateBeforeCall(orderId, nested, _callback);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call patchOrderByOrderIdCall(UUID orderId, PatchOrderRequest patchOrderRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PatchOrderRequest localVarPostBody = patchOrderRequest;
        String localVarPath = "/v2/orders/{order_id}".replace("{order_id}", this.localVarApiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchOrderByOrderIdValidateBeforeCall(UUID orderId, PatchOrderRequest patchOrderRequest, ApiCallback _callback) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling patchOrderByOrderId(Async)");
        }
        if (patchOrderRequest == null) {
            throw new ApiException("Missing the required parameter 'patchOrderRequest' when calling patchOrderByOrderId(Async)");
        }
        return this.patchOrderByOrderIdCall(orderId, patchOrderRequest, _callback);
    }

    public Order patchOrderByOrderId(UUID orderId, PatchOrderRequest patchOrderRequest) throws ApiException {
        ApiResponse<Order> localVarResp = this.patchOrderByOrderIdWithHttpInfo(orderId, patchOrderRequest);
        return localVarResp.getData();
    }

    protected ApiResponse<Order> patchOrderByOrderIdWithHttpInfo(UUID orderId, PatchOrderRequest patchOrderRequest) throws ApiException {
        Call localVarCall = this.patchOrderByOrderIdValidateBeforeCall(orderId, patchOrderRequest, null);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call patchOrderByOrderIdAsync(UUID orderId, PatchOrderRequest patchOrderRequest, ApiCallback<Order> _callback) throws ApiException {
        Call localVarCall = this.patchOrderByOrderIdValidateBeforeCall(orderId, patchOrderRequest, _callback);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call postOrderCall(PostOrderRequest postOrderRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PostOrderRequest localVarPostBody = postOrderRequest;
        String localVarPath = "/v2/orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postOrderValidateBeforeCall(PostOrderRequest postOrderRequest, ApiCallback _callback) throws ApiException {
        if (postOrderRequest == null) {
            throw new ApiException("Missing the required parameter 'postOrderRequest' when calling postOrder(Async)");
        }
        return this.postOrderCall(postOrderRequest, _callback);
    }

    public Order postOrder(PostOrderRequest postOrderRequest) throws ApiException {
        ApiResponse<Order> localVarResp = this.postOrderWithHttpInfo(postOrderRequest);
        return localVarResp.getData();
    }

    protected ApiResponse<Order> postOrderWithHttpInfo(PostOrderRequest postOrderRequest) throws ApiException {
        Call localVarCall = this.postOrderValidateBeforeCall(postOrderRequest, null);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call postOrderAsync(PostOrderRequest postOrderRequest, ApiCallback<Order> _callback) throws ApiException {
        Call localVarCall = this.postOrderValidateBeforeCall(postOrderRequest, _callback);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

