/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.trader.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import net.jacobpeterson.alpaca.openapi.trader.ApiCallback;
import net.jacobpeterson.alpaca.openapi.trader.ApiClient;
import net.jacobpeterson.alpaca.openapi.trader.ApiException;
import net.jacobpeterson.alpaca.openapi.trader.ApiResponse;
import net.jacobpeterson.alpaca.openapi.trader.Configuration;
import net.jacobpeterson.alpaca.openapi.trader.Pair;
import net.jacobpeterson.alpaca.openapi.trader.model.PortfolioHistory;
import okhttp3.Call;

public class PortfolioHistoryApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public PortfolioHistoryApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PortfolioHistoryApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    protected Call getAccountPortfolioHistoryCall(String period, String timeframe, String intradayReporting, OffsetDateTime start, String pnlReset, OffsetDateTime end, LocalDate dateEnd, String extendedHours, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/account/portfolio/history";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (period != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("period", period));
        }
        if (timeframe != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeframe", timeframe));
        }
        if (intradayReporting != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("intraday_reporting", intradayReporting));
        }
        if (start != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start", start));
        }
        if (pnlReset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pnl_reset", pnlReset));
        }
        if (end != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end", end));
        }
        if (dateEnd != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("date_end", dateEnd));
        }
        if (extendedHours != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("extended_hours", extendedHours));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccountPortfolioHistoryValidateBeforeCall(String period, String timeframe, String intradayReporting, OffsetDateTime start, String pnlReset, OffsetDateTime end, LocalDate dateEnd, String extendedHours, ApiCallback _callback) throws ApiException {
        return this.getAccountPortfolioHistoryCall(period, timeframe, intradayReporting, start, pnlReset, end, dateEnd, extendedHours, _callback);
    }

    public PortfolioHistory getAccountPortfolioHistory(String period, String timeframe, String intradayReporting, OffsetDateTime start, String pnlReset, OffsetDateTime end, LocalDate dateEnd, String extendedHours) throws ApiException {
        ApiResponse<PortfolioHistory> localVarResp = this.getAccountPortfolioHistoryWithHttpInfo(period, timeframe, intradayReporting, start, pnlReset, end, dateEnd, extendedHours);
        return localVarResp.getData();
    }

    protected ApiResponse<PortfolioHistory> getAccountPortfolioHistoryWithHttpInfo(String period, String timeframe, String intradayReporting, OffsetDateTime start, String pnlReset, OffsetDateTime end, LocalDate dateEnd, String extendedHours) throws ApiException {
        Call localVarCall = this.getAccountPortfolioHistoryValidateBeforeCall(period, timeframe, intradayReporting, start, pnlReset, end, dateEnd, extendedHours, null);
        Type localVarReturnType = new TypeToken<PortfolioHistory>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getAccountPortfolioHistoryAsync(String period, String timeframe, String intradayReporting, OffsetDateTime start, String pnlReset, OffsetDateTime end, LocalDate dateEnd, String extendedHours, ApiCallback<PortfolioHistory> _callback) throws ApiException {
        Call localVarCall = this.getAccountPortfolioHistoryValidateBeforeCall(period, timeframe, intradayReporting, start, pnlReset, end, dateEnd, extendedHours, _callback);
        Type localVarReturnType = new TypeToken<PortfolioHistory>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

