/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.trader.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.trader.ApiCallback;
import net.jacobpeterson.alpaca.openapi.trader.ApiClient;
import net.jacobpeterson.alpaca.openapi.trader.ApiException;
import net.jacobpeterson.alpaca.openapi.trader.ApiResponse;
import net.jacobpeterson.alpaca.openapi.trader.Configuration;
import net.jacobpeterson.alpaca.openapi.trader.Pair;
import net.jacobpeterson.alpaca.openapi.trader.model.Order;
import net.jacobpeterson.alpaca.openapi.trader.model.Position;
import net.jacobpeterson.alpaca.openapi.trader.model.PositionClosedReponse;
import okhttp3.Call;

public class PositionsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public PositionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PositionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    protected Call deleteAllOpenPositionsCall(Boolean cancelOrders, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/positions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (cancelOrders != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cancel_orders", cancelOrders));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteAllOpenPositionsValidateBeforeCall(Boolean cancelOrders, ApiCallback _callback) throws ApiException {
        return this.deleteAllOpenPositionsCall(cancelOrders, _callback);
    }

    public List<PositionClosedReponse> deleteAllOpenPositions(Boolean cancelOrders) throws ApiException {
        ApiResponse<List<PositionClosedReponse>> localVarResp = this.deleteAllOpenPositionsWithHttpInfo(cancelOrders);
        return localVarResp.getData();
    }

    protected ApiResponse<List<PositionClosedReponse>> deleteAllOpenPositionsWithHttpInfo(Boolean cancelOrders) throws ApiException {
        Call localVarCall = this.deleteAllOpenPositionsValidateBeforeCall(cancelOrders, null);
        Type localVarReturnType = new TypeToken<List<PositionClosedReponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call deleteAllOpenPositionsAsync(Boolean cancelOrders, ApiCallback<List<PositionClosedReponse>> _callback) throws ApiException {
        Call localVarCall = this.deleteAllOpenPositionsValidateBeforeCall(cancelOrders, _callback);
        Type localVarReturnType = new TypeToken<List<PositionClosedReponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call deleteOpenPositionCall(String symbolOrAssetId, BigDecimal qty, BigDecimal percentage, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/positions/{symbol_or_asset_id}".replace("{symbol_or_asset_id}", this.localVarApiClient.escapeString(symbolOrAssetId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (qty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("qty", qty));
        }
        if (percentage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("percentage", percentage));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteOpenPositionValidateBeforeCall(String symbolOrAssetId, BigDecimal qty, BigDecimal percentage, ApiCallback _callback) throws ApiException {
        if (symbolOrAssetId == null) {
            throw new ApiException("Missing the required parameter 'symbolOrAssetId' when calling deleteOpenPosition(Async)");
        }
        return this.deleteOpenPositionCall(symbolOrAssetId, qty, percentage, _callback);
    }

    public Order deleteOpenPosition(String symbolOrAssetId, BigDecimal qty, BigDecimal percentage) throws ApiException {
        ApiResponse<Order> localVarResp = this.deleteOpenPositionWithHttpInfo(symbolOrAssetId, qty, percentage);
        return localVarResp.getData();
    }

    protected ApiResponse<Order> deleteOpenPositionWithHttpInfo(String symbolOrAssetId, BigDecimal qty, BigDecimal percentage) throws ApiException {
        Call localVarCall = this.deleteOpenPositionValidateBeforeCall(symbolOrAssetId, qty, percentage, null);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call deleteOpenPositionAsync(String symbolOrAssetId, BigDecimal qty, BigDecimal percentage, ApiCallback<Order> _callback) throws ApiException {
        Call localVarCall = this.deleteOpenPositionValidateBeforeCall(symbolOrAssetId, qty, percentage, _callback);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getAllOpenPositionsCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/positions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAllOpenPositionsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getAllOpenPositionsCall(_callback);
    }

    public List<Position> getAllOpenPositions() throws ApiException {
        ApiResponse<List<Position>> localVarResp = this.getAllOpenPositionsWithHttpInfo();
        return localVarResp.getData();
    }

    protected ApiResponse<List<Position>> getAllOpenPositionsWithHttpInfo() throws ApiException {
        Call localVarCall = this.getAllOpenPositionsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<Position>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getAllOpenPositionsAsync(ApiCallback<List<Position>> _callback) throws ApiException {
        Call localVarCall = this.getAllOpenPositionsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<Position>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getOpenPositionCall(String symbolOrAssetId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/positions/{symbol_or_asset_id}".replace("{symbol_or_asset_id}", this.localVarApiClient.escapeString(symbolOrAssetId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOpenPositionValidateBeforeCall(String symbolOrAssetId, ApiCallback _callback) throws ApiException {
        if (symbolOrAssetId == null) {
            throw new ApiException("Missing the required parameter 'symbolOrAssetId' when calling getOpenPosition(Async)");
        }
        return this.getOpenPositionCall(symbolOrAssetId, _callback);
    }

    public Position getOpenPosition(String symbolOrAssetId) throws ApiException {
        ApiResponse<Position> localVarResp = this.getOpenPositionWithHttpInfo(symbolOrAssetId);
        return localVarResp.getData();
    }

    protected ApiResponse<Position> getOpenPositionWithHttpInfo(String symbolOrAssetId) throws ApiException {
        Call localVarCall = this.getOpenPositionValidateBeforeCall(symbolOrAssetId, null);
        Type localVarReturnType = new TypeToken<Position>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getOpenPositionAsync(String symbolOrAssetId, ApiCallback<Position> _callback) throws ApiException {
        Call localVarCall = this.getOpenPositionValidateBeforeCall(symbolOrAssetId, _callback);
        Type localVarReturnType = new TypeToken<Position>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call optionExerciseCall(UUID symbolOrContractId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/positions/{symbol_or_contract_id}/exercise".replace("{symbol_or_contract_id}", this.localVarApiClient.escapeString(symbolOrContractId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call optionExerciseValidateBeforeCall(UUID symbolOrContractId, ApiCallback _callback) throws ApiException {
        if (symbolOrContractId == null) {
            throw new ApiException("Missing the required parameter 'symbolOrContractId' when calling optionExercise(Async)");
        }
        return this.optionExerciseCall(symbolOrContractId, _callback);
    }

    public void optionExercise(UUID symbolOrContractId) throws ApiException {
        this.optionExerciseWithHttpInfo(symbolOrContractId);
    }

    protected ApiResponse<Void> optionExerciseWithHttpInfo(UUID symbolOrContractId) throws ApiException {
        Call localVarCall = this.optionExerciseValidateBeforeCall(symbolOrContractId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    protected Call optionExerciseAsync(UUID symbolOrContractId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.optionExerciseValidateBeforeCall(symbolOrContractId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

